/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.Util;
import java.io.InvalidObjectException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.Descriptor;
import javax.management.RuntimeOperationsException;

public class ImmutableDescriptor
implements Descriptor {
    private static final long serialVersionUID = 8853308591080540165L;
    private final String[] names;
    private final Object[] values;
    private transient int hashCode = -1;
    public static final ImmutableDescriptor EMPTY_DESCRIPTOR = new ImmutableDescriptor(new String[0]);

    public ImmutableDescriptor(String[] fieldNames, Object[] fieldValues) {
        this(ImmutableDescriptor.makeMap(fieldNames, fieldValues));
    }

    public ImmutableDescriptor(String ... fields) {
        this(ImmutableDescriptor.makeMap(fields));
    }

    public ImmutableDescriptor(Map<String, ?> fields) {
        if (fields == null) {
            throw new IllegalArgumentException("Null Map");
        }
        TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, ?> entry : fields.entrySet()) {
            String name = entry.getKey();
            if (name == null || name.equals("")) {
                throw new IllegalArgumentException("Empty or null field name");
            }
            if (map.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate name: " + name);
            }
            map.put(name, entry.getValue());
        }
        int size = map.size();
        this.names = map.keySet().toArray(new String[size]);
        this.values = map.values().toArray(new Object[size]);
    }

    private Object readResolve() throws InvalidObjectException {
        boolean bad = false;
        if (this.names == null || this.values == null || this.names.length != this.values.length) {
            bad = true;
        }
        if (!bad) {
            if (this.names.length == 0 && this.getClass() == ImmutableDescriptor.class) {
                return EMPTY_DESCRIPTOR;
            }
            Comparator compare = String.CASE_INSENSITIVE_ORDER;
            String lastName = "";
            for (int i = 0; i < this.names.length; ++i) {
                if (this.names[i] == null || compare.compare(lastName, this.names[i]) >= 0) {
                    bad = true;
                    break;
                }
                lastName = this.names[i];
            }
        }
        if (bad) {
            throw new InvalidObjectException("Bad names or values");
        }
        return this;
    }

    private static SortedMap<String, ?> makeMap(String[] fieldNames, Object[] fieldValues) {
        if (fieldNames == null || fieldValues == null) {
            throw new IllegalArgumentException("Null array parameter");
        }
        if (fieldNames.length != fieldValues.length) {
            throw new IllegalArgumentException("Different size arrays");
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < fieldNames.length; ++i) {
            String name = fieldNames[i];
            if (name == null || name.equals("")) {
                throw new IllegalArgumentException("Empty or null field name");
            }
            Object old = map.put(name, fieldValues[i]);
            if (old == null) continue;
            throw new IllegalArgumentException("Duplicate field name: " + name);
        }
        return map;
    }

    private static SortedMap<String, ?> makeMap(String[] fields) {
        if (fields == null) {
            throw new IllegalArgumentException("Null fields parameter");
        }
        String[] fieldNames = new String[fields.length];
        Object[] fieldValues = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            int eq = field.indexOf(61);
            if (eq < 0) {
                throw new IllegalArgumentException("Missing = character: " + field);
            }
            fieldNames[i] = field.substring(0, eq);
            fieldValues[i] = field.substring(eq + 1);
        }
        return ImmutableDescriptor.makeMap(fieldNames, fieldValues);
    }

    public static ImmutableDescriptor union(Descriptor ... descriptors) {
        int index = ImmutableDescriptor.findNonEmpty(descriptors, 0);
        if (index < 0) {
            return EMPTY_DESCRIPTOR;
        }
        if (descriptors[index] instanceof ImmutableDescriptor && ImmutableDescriptor.findNonEmpty(descriptors, index + 1) < 0) {
            return (ImmutableDescriptor)descriptors[index];
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        ImmutableDescriptor biggestImmutable = EMPTY_DESCRIPTOR;
        for (Descriptor d : descriptors) {
            String[] names;
            if (d == null) continue;
            if (d instanceof ImmutableDescriptor) {
                ImmutableDescriptor id = (ImmutableDescriptor)d;
                names = id.names;
                if (id.getClass() == ImmutableDescriptor.class && names.length > biggestImmutable.names.length) {
                    biggestImmutable = id;
                }
            } else {
                names = d.getFieldNames();
            }
            for (String n : names) {
                boolean equal;
                Object v = d.getFieldValue(n);
                Object old = map.put(n, v);
                if (old == null || (equal = old.getClass().isArray() ? Arrays.deepEquals(new Object[]{old}, new Object[]{v}) : old.equals(v))) continue;
                String msg = "Inconsistent values for descriptor field " + n + ": " + old + " :: " + v;
                throw new IllegalArgumentException(msg);
            }
        }
        if (biggestImmutable.names.length == map.size()) {
            return biggestImmutable;
        }
        return new ImmutableDescriptor(map);
    }

    private static boolean isEmpty(Descriptor d) {
        if (d == null) {
            return true;
        }
        if (d instanceof ImmutableDescriptor) {
            return ((ImmutableDescriptor)d).names.length == 0;
        }
        return d.getFieldNames().length == 0;
    }

    private static int findNonEmpty(Descriptor[] ds, int start) {
        for (int i = start; i < ds.length; ++i) {
            if (ImmutableDescriptor.isEmpty(ds[i])) continue;
            return i;
        }
        return -1;
    }

    private int fieldIndex(String name) {
        return Arrays.binarySearch(this.names, name, String.CASE_INSENSITIVE_ORDER);
    }

    @Override
    public final Object getFieldValue(String fieldName) {
        ImmutableDescriptor.checkIllegalFieldName(fieldName);
        int i = this.fieldIndex(fieldName);
        if (i < 0) {
            return null;
        }
        Object v = this.values[i];
        if (v == null || !v.getClass().isArray()) {
            return v;
        }
        if (v instanceof Object[]) {
            return ((Object[])v).clone();
        }
        int len = Array.getLength(v);
        Object a = Array.newInstance(v.getClass().getComponentType(), len);
        System.arraycopy(v, 0, a, 0, len);
        return a;
    }

    @Override
    public final String[] getFields() {
        String[] result = new String[this.names.length];
        for (int i = 0; i < result.length; ++i) {
            Object value = this.values[i];
            if (value == null) {
                value = "";
            } else if (!(value instanceof String)) {
                value = "(" + value + ")";
            }
            result[i] = this.names[i] + "=" + value;
        }
        return result;
    }

    @Override
    public final Object[] getFieldValues(String ... fieldNames) {
        if (fieldNames == null) {
            return (Object[])this.values.clone();
        }
        Object[] result = new Object[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String name = fieldNames[i];
            if (name == null || name.equals("")) continue;
            result[i] = this.getFieldValue(name);
        }
        return result;
    }

    @Override
    public final String[] getFieldNames() {
        return (String[])this.names.clone();
    }

    @Override
    public boolean equals(Object o) {
        String[] onames;
        if (o == this) {
            return true;
        }
        if (!(o instanceof Descriptor)) {
            return false;
        }
        if (o instanceof ImmutableDescriptor) {
            onames = ((ImmutableDescriptor)o).names;
        } else {
            onames = ((Descriptor)o).getFieldNames();
            Arrays.sort(onames, String.CASE_INSENSITIVE_ORDER);
        }
        if (this.names.length != onames.length) {
            return false;
        }
        for (int i = 0; i < this.names.length; ++i) {
            if (this.names[i].equalsIgnoreCase(onames[i])) continue;
            return false;
        }
        Object[] ovalues = o instanceof ImmutableDescriptor ? ((ImmutableDescriptor)o).values : ((Descriptor)o).getFieldValues(onames);
        return Arrays.deepEquals(this.values, ovalues);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = Util.hashCode(this.names, this.values);
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.names[i]).append("=");
            Object v = this.values[i];
            if (v != null && v.getClass().isArray()) {
                String s = Arrays.deepToString(new Object[]{v});
                s = s.substring(1, s.length() - 1);
                v = s;
            }
            sb.append(String.valueOf(v));
        }
        return sb.append("}").toString();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public Descriptor clone() {
        return this;
    }

    @Override
    public final void setFields(String[] fieldNames, Object[] fieldValues) throws RuntimeOperationsException {
        int i;
        if (fieldNames == null || fieldValues == null) {
            ImmutableDescriptor.illegal("Null argument");
        }
        if (fieldNames.length != fieldValues.length) {
            ImmutableDescriptor.illegal("Different array sizes");
        }
        for (i = 0; i < fieldNames.length; ++i) {
            ImmutableDescriptor.checkIllegalFieldName(fieldNames[i]);
        }
        for (i = 0; i < fieldNames.length; ++i) {
            this.setField(fieldNames[i], fieldValues[i]);
        }
    }

    @Override
    public final void setField(String fieldName, Object fieldValue) throws RuntimeOperationsException {
        Object value;
        ImmutableDescriptor.checkIllegalFieldName(fieldName);
        int i = this.fieldIndex(fieldName);
        if (i < 0) {
            ImmutableDescriptor.unsupported();
        }
        if ((value = this.values[i]) == null ? fieldValue != null : !value.equals(fieldValue)) {
            ImmutableDescriptor.unsupported();
        }
    }

    @Override
    public final void removeField(String fieldName) {
        if (fieldName != null && this.fieldIndex(fieldName) >= 0) {
            ImmutableDescriptor.unsupported();
        }
    }

    static Descriptor nonNullDescriptor(Descriptor d) {
        if (d == null) {
            return EMPTY_DESCRIPTOR;
        }
        return d;
    }

    private static void checkIllegalFieldName(String name) {
        if (name == null || name.equals("")) {
            ImmutableDescriptor.illegal("Null or empty field name");
        }
    }

    private static void unsupported() {
        UnsupportedOperationException uoe = new UnsupportedOperationException("Descriptor is read-only");
        throw new RuntimeOperationsException(uoe);
    }

    private static void illegal(String message) {
        IllegalArgumentException iae = new IllegalArgumentException(message);
        throw new RuntimeOperationsException(iae);
    }
}

