/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.relation.InvalidRelationIdException;
import javax.management.relation.InvalidRelationServiceException;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationNotification;
import javax.management.relation.RelationServiceMBean;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupport;
import javax.management.relation.RelationType;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.RelationTypeSupport;
import javax.management.relation.Role;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;

public class RelationService
extends NotificationBroadcasterSupport
implements RelationServiceMBean,
MBeanRegistration,
NotificationListener {
    private Map<String, Object> myRelId2ObjMap = new HashMap<String, Object>();
    private Map<String, String> myRelId2RelTypeMap = new HashMap<String, String>();
    private Map<ObjectName, String> myRelMBeanObjName2RelIdMap = new HashMap<ObjectName, String>();
    private Map<String, RelationType> myRelType2ObjMap = new HashMap<String, RelationType>();
    private Map<String, List<String>> myRelType2RelIdsMap = new HashMap<String, List<String>>();
    private final Map<ObjectName, Map<String, List<String>>> myRefedMBeanObjName2RelIdsMap = new HashMap<ObjectName, Map<String, List<String>>>();
    private boolean myPurgeFlag = true;
    private final AtomicLong atomicSeqNo = new AtomicLong();
    private ObjectName myObjName = null;
    private MBeanServer myMBeanServer = null;
    private MBeanServerNotificationFilter myUnregNtfFilter = null;
    private List<MBeanServerNotification> myUnregNtfList = new ArrayList<MBeanServerNotification>();

    public RelationService(boolean immediatePurgeFlag) {
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "RelationService");
        this.setPurgeFlag(immediatePurgeFlag);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "RelationService");
    }

    @Override
    public void isActive() throws RelationServiceNotRegisteredException {
        if (this.myMBeanServer == null) {
            String excMsg = "Relation Service not registered in the MBean Server.";
            throw new RelationServiceNotRegisteredException(excMsg);
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.myMBeanServer = server;
        this.myObjName = name;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public boolean getPurgeFlag() {
        return this.myPurgeFlag;
    }

    @Override
    public void setPurgeFlag(boolean purgeFlag) {
        this.myPurgeFlag = purgeFlag;
    }

    @Override
    public void createRelationType(String relationTypeName, RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (relationTypeName == null || roleInfoArray == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "createRelationType", relationTypeName);
        RelationTypeSupport relType = new RelationTypeSupport(relationTypeName, roleInfoArray);
        this.addRelationTypeInt(relType);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "createRelationType");
    }

    @Override
    public void addRelationType(RelationType relationTypeObj) throws IllegalArgumentException, InvalidRelationTypeException {
        if (relationTypeObj == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "addRelationType");
        List<RoleInfo> roleInfoList = relationTypeObj.getRoleInfos();
        if (roleInfoList == null) {
            String excMsg = "No role info provided.";
            throw new InvalidRelationTypeException(excMsg);
        }
        RoleInfo[] roleInfoArray = new RoleInfo[roleInfoList.size()];
        int i = 0;
        Iterator<RoleInfo> i$ = roleInfoList.iterator();
        while (i$.hasNext()) {
            RoleInfo currRoleInfo;
            roleInfoArray[i] = currRoleInfo = i$.next();
            ++i;
        }
        RelationTypeSupport.checkRoleInfos(roleInfoArray);
        this.addRelationTypeInt(relationTypeObj);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "addRelationType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllRelationTypeNames() {
        ArrayList<String> result;
        Map<String, RelationType> map = this.myRelType2ObjMap;
        synchronized (map) {
            result = new ArrayList<String>(this.myRelType2ObjMap.keySet());
        }
        return result;
    }

    @Override
    public List<RoleInfo> getRoleInfos(String relationTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (relationTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRoleInfos", relationTypeName);
        RelationType relType = this.getRelationType(relationTypeName);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRoleInfos");
        return relType.getRoleInfos();
    }

    @Override
    public RoleInfo getRoleInfo(String relationTypeName, String roleInfoName) throws IllegalArgumentException, RelationTypeNotFoundException, RoleInfoNotFoundException {
        if (relationTypeName == null || roleInfoName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRoleInfo", new Object[]{relationTypeName, roleInfoName});
        RelationType relType = this.getRelationType(relationTypeName);
        RoleInfo roleInfo = relType.getRoleInfo(roleInfoName);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRoleInfo");
        return roleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRelationType(String relationTypeName) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationTypeNotFoundException {
        this.isActive();
        if (relationTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "removeRelationType", relationTypeName);
        RelationType relType = this.getRelationType(relationTypeName);
        ArrayList<String> relIdList = null;
        Map<String, Object> map = this.myRelType2RelIdsMap;
        synchronized (map) {
            List<String> relIdList1 = this.myRelType2RelIdsMap.get(relationTypeName);
            if (relIdList1 != null) {
                relIdList = new ArrayList<String>(relIdList1);
            }
        }
        map = this.myRelType2ObjMap;
        synchronized (map) {
            this.myRelType2ObjMap.remove(relationTypeName);
        }
        map = this.myRelType2RelIdsMap;
        synchronized (map) {
            this.myRelType2RelIdsMap.remove(relationTypeName);
        }
        if (relIdList != null) {
            for (String currRelId : relIdList) {
                try {
                    this.removeRelation(currRelId);
                }
                catch (RelationNotFoundException exc1) {
                    throw new RuntimeException(exc1.getMessage());
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "removeRelationType");
    }

    @Override
    public void createRelation(String relationId, String relationTypeName, RoleList roleList) throws RelationServiceNotRegisteredException, IllegalArgumentException, RoleNotFoundException, InvalidRelationIdException, RelationTypeNotFoundException, InvalidRoleValueException {
        this.isActive();
        if (relationId == null || relationTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "createRelation", new Object[]{relationId, relationTypeName, roleList});
        RelationSupport relObj = new RelationSupport(relationId, this.myObjName, relationTypeName, roleList);
        this.addRelationInt(true, relObj, null, relationId, relationTypeName, roleList);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "createRelation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRelation(ObjectName relationObjectName) throws IllegalArgumentException, RelationServiceNotRegisteredException, NoSuchMethodException, InvalidRelationIdException, InstanceNotFoundException, InvalidRelationServiceException, RelationTypeNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        RoleList roleList;
        String relTypeName;
        ObjectName relServObjName;
        String relId;
        if (relationObjectName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "addRelation", relationObjectName);
        this.isActive();
        if (!this.myMBeanServer.isInstanceOf(relationObjectName, "javax.management.relation.Relation")) {
            String excMsg = "This MBean does not implement the Relation interface.";
            throw new NoSuchMethodException(excMsg);
        }
        try {
            relId = (String)this.myMBeanServer.getAttribute(relationObjectName, "RelationId");
        }
        catch (MBeanException exc1) {
            throw new RuntimeException(exc1.getTargetException().getMessage());
        }
        catch (ReflectionException exc2) {
            throw new RuntimeException(exc2.getMessage());
        }
        catch (AttributeNotFoundException exc3) {
            throw new RuntimeException(exc3.getMessage());
        }
        if (relId == null) {
            String excMsg = "This MBean does not provide a relation id.";
            throw new InvalidRelationIdException(excMsg);
        }
        try {
            relServObjName = (ObjectName)this.myMBeanServer.getAttribute(relationObjectName, "RelationServiceName");
        }
        catch (MBeanException exc1) {
            throw new RuntimeException(exc1.getTargetException().getMessage());
        }
        catch (ReflectionException exc2) {
            throw new RuntimeException(exc2.getMessage());
        }
        catch (AttributeNotFoundException exc3) {
            throw new RuntimeException(exc3.getMessage());
        }
        boolean badRelServFlag = false;
        if (relServObjName == null) {
            badRelServFlag = true;
        } else if (!relServObjName.equals(this.myObjName)) {
            badRelServFlag = true;
        }
        if (badRelServFlag) {
            String excMsg = "The Relation Service referenced in the MBean is not the current one.";
            throw new InvalidRelationServiceException(excMsg);
        }
        try {
            relTypeName = (String)this.myMBeanServer.getAttribute(relationObjectName, "RelationTypeName");
        }
        catch (MBeanException exc1) {
            throw new RuntimeException(exc1.getTargetException().getMessage());
        }
        catch (ReflectionException exc2) {
            throw new RuntimeException(exc2.getMessage());
        }
        catch (AttributeNotFoundException exc3) {
            throw new RuntimeException(exc3.getMessage());
        }
        if (relTypeName == null) {
            String excMsg = "No relation type provided.";
            throw new RelationTypeNotFoundException(excMsg);
        }
        try {
            roleList = (RoleList)this.myMBeanServer.invoke(relationObjectName, "retrieveAllRoles", null, null);
        }
        catch (MBeanException exc1) {
            throw new RuntimeException(exc1.getTargetException().getMessage());
        }
        catch (ReflectionException exc42) {
            throw new RuntimeException(exc42.getMessage());
        }
        this.addRelationInt(false, null, relationObjectName, relId, relTypeName, roleList);
        Map<ObjectName, String> exc42 = this.myRelMBeanObjName2RelIdMap;
        synchronized (exc42) {
            this.myRelMBeanObjName2RelIdMap.put(relationObjectName, relId);
        }
        try {
            this.myMBeanServer.setAttribute(relationObjectName, new Attribute("RelationServiceManagementFlag", Boolean.TRUE));
        }
        catch (Exception exc42) {
            // empty catch block
        }
        ArrayList<ObjectName> newRefList = new ArrayList<ObjectName>();
        newRefList.add(relationObjectName);
        this.updateUnregistrationListener(newRefList, null);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "addRelation");
    }

    @Override
    public ObjectName isRelationMBean(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        if (relationId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "isRelationMBean", relationId);
        Object result = this.getRelation(relationId);
        if (result instanceof ObjectName) {
            return (ObjectName)result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String isRelation(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "isRelation", objectName);
        String result = null;
        Map<ObjectName, String> map = this.myRelMBeanObjName2RelIdMap;
        synchronized (map) {
            String relId = this.myRelMBeanObjName2RelIdMap.get(objectName);
            if (relId != null) {
                result = relId;
            }
        }
        return result;
    }

    @Override
    public Boolean hasRelation(String relationId) throws IllegalArgumentException {
        if (relationId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "hasRelation", relationId);
        try {
            Object result = this.getRelation(relationId);
            return true;
        }
        catch (RelationNotFoundException exc) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllRelationIds() {
        ArrayList<String> result;
        Map<String, Object> map = this.myRelId2ObjMap;
        synchronized (map) {
            result = new ArrayList<String>(this.myRelId2ObjMap.keySet());
        }
        return result;
    }

    @Override
    public Integer checkRoleReading(String roleName, String relationTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        Integer result;
        if (roleName == null || relationTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "checkRoleReading", new Object[]{roleName, relationTypeName});
        RelationType relType = this.getRelationType(relationTypeName);
        try {
            RoleInfo roleInfo = relType.getRoleInfo(roleName);
            result = this.checkRoleInt(1, roleName, null, roleInfo, false);
        }
        catch (RoleInfoNotFoundException exc) {
            result = 1;
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleReading");
        return result;
    }

    @Override
    public Integer checkRoleWriting(Role role, String relationTypeName, Boolean initFlag) throws IllegalArgumentException, RelationTypeNotFoundException {
        RoleInfo roleInfo;
        if (role == null || relationTypeName == null || initFlag == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "checkRoleWriting", new Object[]{role, relationTypeName, initFlag});
        RelationType relType = this.getRelationType(relationTypeName);
        String roleName = role.getRoleName();
        List<ObjectName> roleValue = role.getRoleValue();
        boolean writeChkFlag = true;
        if (initFlag.booleanValue()) {
            writeChkFlag = false;
        }
        try {
            roleInfo = relType.getRoleInfo(roleName);
        }
        catch (RoleInfoNotFoundException exc) {
            JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleWriting");
            return 1;
        }
        Integer result = this.checkRoleInt(2, roleName, roleValue, roleInfo, writeChkFlag);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleWriting");
        return result;
    }

    @Override
    public void sendRelationCreationNotification(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        if (relationId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "sendRelationCreationNotification", relationId);
        StringBuilder ntfMsg = new StringBuilder("Creation of relation ");
        ntfMsg.append(relationId);
        this.sendNotificationInt(1, ntfMsg.toString(), relationId, null, null, null, null);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "sendRelationCreationNotification");
    }

    @Override
    public void sendRoleUpdateNotification(String relationId, Role newRole, List<ObjectName> oldValue) throws IllegalArgumentException, RelationNotFoundException {
        if (relationId == null || newRole == null || oldValue == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (!(oldValue instanceof ArrayList)) {
            oldValue = new ArrayList<ObjectName>(oldValue);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "sendRoleUpdateNotification", new Object[]{relationId, newRole, oldValue});
        String roleName = newRole.getRoleName();
        List<ObjectName> newRoleVal = newRole.getRoleValue();
        String newRoleValString = Role.roleValueToString(newRoleVal);
        String oldRoleValString = Role.roleValueToString(oldValue);
        StringBuilder ntfMsg = new StringBuilder("Value of role ");
        ntfMsg.append(roleName);
        ntfMsg.append(" has changed\nOld value:\n");
        ntfMsg.append(oldRoleValString);
        ntfMsg.append("\nNew value:\n");
        ntfMsg.append(newRoleValString);
        this.sendNotificationInt(2, ntfMsg.toString(), relationId, null, roleName, newRoleVal, oldValue);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "sendRoleUpdateNotification");
    }

    @Override
    public void sendRelationRemovalNotification(String relationId, List<ObjectName> unregMBeanList) throws IllegalArgumentException, RelationNotFoundException {
        if (relationId == null) {
            String excMsg = "Invalid parameter";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "sendRelationRemovalNotification", new Object[]{relationId, unregMBeanList});
        this.sendNotificationInt(3, "Removal of relation " + relationId, relationId, unregMBeanList, null, null, null);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "sendRelationRemovalNotification");
    }

    @Override
    public void updateRoleMap(String relationId, Role newRole, List<ObjectName> oldValue) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (relationId == null || newRole == null || oldValue == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "updateRoleMap", new Object[]{relationId, newRole, oldValue});
        this.isActive();
        Object result = this.getRelation(relationId);
        String roleName = newRole.getRoleName();
        List<ObjectName> newRoleValue = newRole.getRoleValue();
        ArrayList<ObjectName> oldRoleValue = new ArrayList<ObjectName>(oldValue);
        ArrayList<ObjectName> newRefList = new ArrayList<ObjectName>();
        for (ObjectName currObjName : newRoleValue) {
            int currObjNamePos = oldRoleValue.indexOf(currObjName);
            if (currObjNamePos == -1) {
                boolean isNewFlag = this.addNewMBeanReference(currObjName, relationId, roleName);
                if (!isNewFlag) continue;
                newRefList.add(currObjName);
                continue;
            }
            oldRoleValue.remove(currObjNamePos);
        }
        ArrayList<ObjectName> obsRefList = new ArrayList<ObjectName>();
        for (ObjectName currObjName : oldRoleValue) {
            boolean noLongerRefFlag = this.removeMBeanReference(currObjName, relationId, roleName, false);
            if (!noLongerRefFlag) continue;
            obsRefList.add(currObjName);
        }
        this.updateUnregistrationListener(newRefList, obsRefList);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "updateRoleMap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRelation(String relationId) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        String relTypeName;
        this.isActive();
        if (relationId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "removeRelation", relationId);
        Object result = this.getRelation(relationId);
        if (result instanceof ObjectName) {
            ArrayList<ObjectName> obsRefList = new ArrayList<ObjectName>();
            obsRefList.add((ObjectName)result);
            this.updateUnregistrationListener(null, obsRefList);
        }
        this.sendRelationRemovalNotification(relationId, null);
        ArrayList<ObjectName> refMBeanList = new ArrayList<ObjectName>();
        ArrayList<ObjectName> nonRefObjNameList = new ArrayList<ObjectName>();
        Map<Object, Object> map = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (map) {
            for (ObjectName currRefObjName : this.myRefedMBeanObjName2RelIdsMap.keySet()) {
                Map<String, List<String>> relIdMap = this.myRefedMBeanObjName2RelIdsMap.get(currRefObjName);
                if (relIdMap.containsKey(relationId)) {
                    relIdMap.remove(relationId);
                    refMBeanList.add(currRefObjName);
                }
                if (!relIdMap.isEmpty()) continue;
                nonRefObjNameList.add(currRefObjName);
            }
            for (ObjectName currRefObjName : nonRefObjNameList) {
                this.myRefedMBeanObjName2RelIdsMap.remove(currRefObjName);
            }
        }
        map = this.myRelId2ObjMap;
        synchronized (map) {
            this.myRelId2ObjMap.remove(relationId);
        }
        if (result instanceof ObjectName) {
            map = this.myRelMBeanObjName2RelIdMap;
            synchronized (map) {
                this.myRelMBeanObjName2RelIdMap.remove((ObjectName)result);
            }
        }
        Map<String, Object> map2 = this.myRelId2RelTypeMap;
        synchronized (map2) {
            relTypeName = this.myRelId2RelTypeMap.get(relationId);
            this.myRelId2RelTypeMap.remove(relationId);
        }
        map2 = this.myRelType2RelIdsMap;
        synchronized (map2) {
            List<String> relIdList = this.myRelType2RelIdsMap.get(relTypeName);
            if (relIdList != null) {
                relIdList.remove(relationId);
                if (relIdList.isEmpty()) {
                    this.myRelType2RelIdsMap.remove(relTypeName);
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "removeRelation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeRelations() throws RelationServiceNotRegisteredException {
        ArrayList<MBeanServerNotification> localUnregNtfList;
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "purgeRelations");
        this.isActive();
        Map<ObjectName, Map<String, List<String>>> map = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (map) {
            localUnregNtfList = new ArrayList<MBeanServerNotification>(this.myUnregNtfList);
            this.myUnregNtfList = new ArrayList<MBeanServerNotification>();
        }
        ArrayList<ObjectName> obsRefList = new ArrayList<ObjectName>();
        HashMap<ObjectName, Map<String, List<String>>> localMBean2RelIdMap = new HashMap<ObjectName, Map<String, List<String>>>();
        Map<ObjectName, Map<String, List<String>>> map2 = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (map2) {
            for (MBeanServerNotification currNtf : localUnregNtfList) {
                ObjectName unregMBeanName = currNtf.getMBeanName();
                obsRefList.add(unregMBeanName);
                Map<String, List<String>> relIdMap = this.myRefedMBeanObjName2RelIdsMap.get(unregMBeanName);
                localMBean2RelIdMap.put(unregMBeanName, relIdMap);
                this.myRefedMBeanObjName2RelIdsMap.remove(unregMBeanName);
            }
        }
        this.updateUnregistrationListener(null, obsRefList);
        for (MBeanServerNotification currNtf : localUnregNtfList) {
            ObjectName unregMBeanName = currNtf.getMBeanName();
            Map localRelIdMap = (Map)localMBean2RelIdMap.get(unregMBeanName);
            for (Map.Entry currRel : localRelIdMap.entrySet()) {
                String currRelId = (String)currRel.getKey();
                List localRoleNameList = (List)currRel.getValue();
                try {
                    this.handleReferenceUnregistration(currRelId, unregMBeanName, localRoleNameList);
                }
                catch (RelationNotFoundException exc1) {
                    throw new RuntimeException(exc1.getMessage());
                }
                catch (RoleNotFoundException exc2) {
                    throw new RuntimeException(exc2.getMessage());
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "purgeRelations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> findReferencingRelations(ObjectName mbeanName, String relationTypeName, String roleName) throws IllegalArgumentException {
        if (mbeanName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "findReferencingRelations", new Object[]{mbeanName, relationTypeName, roleName});
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Map<ObjectName, Map<String, List<String>>> map = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (map) {
            Map<String, List<String>> relId2RoleNamesMap = this.myRefedMBeanObjName2RelIdsMap.get(mbeanName);
            if (relId2RoleNamesMap != null) {
                ArrayList<Object> relIdList;
                Set<String> allRelIdSet = relId2RoleNamesMap.keySet();
                if (relationTypeName == null) {
                    relIdList = new ArrayList<String>(allRelIdSet);
                } else {
                    relIdList = new ArrayList();
                    for (String string : allRelIdSet) {
                        String currRelTypeName;
                        Map<String, String> map2 = this.myRelId2RelTypeMap;
                        synchronized (map2) {
                            currRelTypeName = this.myRelId2RelTypeMap.get(string);
                        }
                        if (!currRelTypeName.equals(relationTypeName)) continue;
                        relIdList.add(string);
                    }
                }
                for (String string : relIdList) {
                    List<String> currRoleNameList = relId2RoleNamesMap.get(string);
                    if (roleName == null) {
                        result.put(string, new ArrayList<String>(currRoleNameList));
                        continue;
                    }
                    if (!currRoleNameList.contains(roleName)) continue;
                    ArrayList<String> dummyList = new ArrayList<String>();
                    dummyList.add(roleName);
                    result.put(string, dummyList);
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "findReferencingRelations");
        return result;
    }

    @Override
    public Map<ObjectName, List<String>> findAssociatedMBeans(ObjectName mbeanName, String relationTypeName, String roleName) throws IllegalArgumentException {
        if (mbeanName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "findAssociatedMBeans", new Object[]{mbeanName, relationTypeName, roleName});
        Map<String, List<String>> relId2RoleNamesMap = this.findReferencingRelations(mbeanName, relationTypeName, roleName);
        HashMap<ObjectName, List<String>> result = new HashMap<ObjectName, List<String>>();
        for (String currRelId : relId2RoleNamesMap.keySet()) {
            Map<ObjectName, List<String>> objName2RoleNamesMap;
            try {
                objName2RoleNamesMap = this.getReferencedMBeans(currRelId);
            }
            catch (RelationNotFoundException exc) {
                throw new RuntimeException(exc.getMessage());
            }
            for (ObjectName currObjName : objName2RoleNamesMap.keySet()) {
                if (currObjName.equals(mbeanName)) continue;
                ArrayList<String> currRelIdList = (ArrayList<String>)result.get(currObjName);
                if (currRelIdList == null) {
                    currRelIdList = new ArrayList<String>();
                    currRelIdList.add(currRelId);
                    result.put(currObjName, currRelIdList);
                    continue;
                }
                currRelIdList.add(currRelId);
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "findAssociatedMBeans");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> findRelationsOfType(String relationTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        ArrayList<Object> result;
        if (relationTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "findRelationsOfType");
        RelationType relType = this.getRelationType(relationTypeName);
        Map<String, List<String>> map = this.myRelType2RelIdsMap;
        synchronized (map) {
            List<String> result1 = this.myRelType2RelIdsMap.get(relationTypeName);
            result = result1 == null ? new ArrayList() : new ArrayList<String>(result1);
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "findRelationsOfType");
        return result;
    }

    @Override
    public List<ObjectName> getRole(String relationId, String roleName) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException, RoleNotFoundException {
        List result;
        if (relationId == null || roleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRole", new Object[]{relationId, roleName});
        this.isActive();
        Object relObj = this.getRelation(relationId);
        if (relObj instanceof RelationSupport) {
            result = (ArrayList)Util.cast(((RelationSupport)relObj).getRoleInt(roleName, true, this, false));
        } else {
            Object[] params = new Object[]{roleName};
            String[] signature = new String[]{"java.lang.String"};
            try {
                List invokeResult = (List)Util.cast(this.myMBeanServer.invoke((ObjectName)relObj, "getRole", params, signature));
                result = invokeResult == null || invokeResult instanceof ArrayList ? invokeResult : new ArrayList(invokeResult);
            }
            catch (InstanceNotFoundException exc1) {
                throw new RuntimeException(exc1.getMessage());
            }
            catch (ReflectionException exc2) {
                throw new RuntimeException(exc2.getMessage());
            }
            catch (MBeanException exc3) {
                Exception wrappedExc = exc3.getTargetException();
                if (wrappedExc instanceof RoleNotFoundException) {
                    throw (RoleNotFoundException)wrappedExc;
                }
                throw new RuntimeException(wrappedExc.getMessage());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRole");
        return result;
    }

    @Override
    public RoleResult getRoles(String relationId, String[] roleNameArray) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        RoleResult result;
        if (relationId == null || roleNameArray == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRoles", relationId);
        this.isActive();
        Object relObj = this.getRelation(relationId);
        if (relObj instanceof RelationSupport) {
            result = ((RelationSupport)relObj).getRolesInt(roleNameArray, true, this);
        } else {
            Object[] params = new Object[]{roleNameArray};
            String[] signature = new String[1];
            try {
                signature[0] = roleNameArray.getClass().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                result = (RoleResult)this.myMBeanServer.invoke((ObjectName)relObj, "getRoles", params, signature);
            }
            catch (InstanceNotFoundException exc1) {
                throw new RuntimeException(exc1.getMessage());
            }
            catch (ReflectionException exc2) {
                throw new RuntimeException(exc2.getMessage());
            }
            catch (MBeanException exc3) {
                throw new RuntimeException(exc3.getTargetException().getMessage());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRoles");
        return result;
    }

    @Override
    public RoleResult getAllRoles(String relationId) throws IllegalArgumentException, RelationNotFoundException, RelationServiceNotRegisteredException {
        RoleResult result;
        if (relationId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRoles", relationId);
        Object relObj = this.getRelation(relationId);
        if (relObj instanceof RelationSupport) {
            result = ((RelationSupport)relObj).getAllRolesInt(true, this);
        } else {
            try {
                result = (RoleResult)this.myMBeanServer.getAttribute((ObjectName)relObj, "AllRoles");
            }
            catch (Exception exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRoles");
        return result;
    }

    @Override
    public Integer getRoleCardinality(String relationId, String roleName) throws IllegalArgumentException, RelationNotFoundException, RoleNotFoundException {
        Integer result;
        if (relationId == null || roleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRoleCardinality", new Object[]{relationId, roleName});
        Object relObj = this.getRelation(relationId);
        if (relObj instanceof RelationSupport) {
            result = ((RelationSupport)relObj).getRoleCardinality(roleName);
        } else {
            Object[] params = new Object[]{roleName};
            String[] signature = new String[]{"java.lang.String"};
            try {
                result = (Integer)this.myMBeanServer.invoke((ObjectName)relObj, "getRoleCardinality", params, signature);
            }
            catch (InstanceNotFoundException exc1) {
                throw new RuntimeException(exc1.getMessage());
            }
            catch (ReflectionException exc2) {
                throw new RuntimeException(exc2.getMessage());
            }
            catch (MBeanException exc3) {
                Exception wrappedExc = exc3.getTargetException();
                if (wrappedExc instanceof RoleNotFoundException) {
                    throw (RoleNotFoundException)wrappedExc;
                }
                throw new RuntimeException(wrappedExc.getMessage());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRoleCardinality");
        return result;
    }

    @Override
    public void setRole(String relationId, Role role) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        if (relationId == null || role == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "setRole", new Object[]{relationId, role});
        this.isActive();
        Object relObj = this.getRelation(relationId);
        if (relObj instanceof RelationSupport) {
            try {
                ((RelationSupport)relObj).setRoleInt(role, true, this, false);
            }
            catch (RelationTypeNotFoundException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        Object[] params = new Object[]{role};
        String[] signature = new String[]{"javax.management.relation.Role"};
        try {
            this.myMBeanServer.setAttribute((ObjectName)relObj, new Attribute("Role", role));
        }
        catch (InstanceNotFoundException exc1) {
            throw new RuntimeException(exc1.getMessage());
        }
        catch (ReflectionException exc3) {
            throw new RuntimeException(exc3.getMessage());
        }
        catch (MBeanException exc2) {
            Exception wrappedExc = exc2.getTargetException();
            if (wrappedExc instanceof RoleNotFoundException) {
                throw (RoleNotFoundException)wrappedExc;
            }
            if (wrappedExc instanceof InvalidRoleValueException) {
                throw (InvalidRoleValueException)wrappedExc;
            }
            throw new RuntimeException(wrappedExc.getMessage());
        }
        catch (AttributeNotFoundException exc4) {
            throw new RuntimeException(exc4.getMessage());
        }
        catch (InvalidAttributeValueException exc5) {
            throw new RuntimeException(exc5.getMessage());
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "setRole");
    }

    @Override
    public RoleResult setRoles(String relationId, RoleList roleList) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        RoleResult result;
        if (relationId == null || roleList == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "setRoles", new Object[]{relationId, roleList});
        this.isActive();
        Object relObj = this.getRelation(relationId);
        if (relObj instanceof RelationSupport) {
            try {
                result = ((RelationSupport)relObj).setRolesInt(roleList, true, this);
            }
            catch (RelationTypeNotFoundException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        Object[] params = new Object[]{roleList};
        String[] signature = new String[]{"javax.management.relation.RoleList"};
        try {
            result = (RoleResult)this.myMBeanServer.invoke((ObjectName)relObj, "setRoles", params, signature);
        }
        catch (InstanceNotFoundException exc1) {
            throw new RuntimeException(exc1.getMessage());
        }
        catch (ReflectionException exc3) {
            throw new RuntimeException(exc3.getMessage());
        }
        catch (MBeanException exc2) {
            throw new RuntimeException(exc2.getTargetException().getMessage());
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "setRoles");
        return result;
    }

    @Override
    public Map<ObjectName, List<String>> getReferencedMBeans(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        Map result;
        if (relationId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getReferencedMBeans", relationId);
        Object relObj = this.getRelation(relationId);
        if (relObj instanceof RelationSupport) {
            result = ((RelationSupport)relObj).getReferencedMBeans();
        } else {
            try {
                result = (Map)Util.cast(this.myMBeanServer.getAttribute((ObjectName)relObj, "ReferencedMBeans"));
            }
            catch (Exception exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getReferencedMBeans");
        return result;
    }

    @Override
    public String getRelationTypeName(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        String result;
        if (relationId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRelationTypeName", relationId);
        Object relObj = this.getRelation(relationId);
        if (relObj instanceof RelationSupport) {
            result = ((RelationSupport)relObj).getRelationTypeName();
        } else {
            try {
                result = (String)this.myMBeanServer.getAttribute((ObjectName)relObj, "RelationTypeName");
            }
            catch (Exception exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRelationTypeName");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notif, Object handback) {
        if (notif == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "handleNotification", notif);
        if (notif instanceof MBeanServerNotification) {
            MBeanServerNotification mbsNtf = (MBeanServerNotification)notif;
            String ntfType = notif.getType();
            if (ntfType.equals("JMX.mbean.unregistered")) {
                String relId;
                ObjectName mbeanName = ((MBeanServerNotification)notif).getMBeanName();
                boolean isRefedMBeanFlag = false;
                Map<ObjectName, Map<String, List<String>>> map = this.myRefedMBeanObjName2RelIdsMap;
                synchronized (map) {
                    if (this.myRefedMBeanObjName2RelIdsMap.containsKey(mbeanName)) {
                        List<MBeanServerNotification> list = this.myUnregNtfList;
                        synchronized (list) {
                            this.myUnregNtfList.add(mbsNtf);
                        }
                        isRefedMBeanFlag = true;
                    }
                    if (isRefedMBeanFlag && this.myPurgeFlag) {
                        try {
                            this.purgeRelations();
                        }
                        catch (Exception exc) {
                            throw new RuntimeException(exc.getMessage());
                        }
                    }
                }
                Map<ObjectName, String> exc = this.myRelMBeanObjName2RelIdMap;
                synchronized (exc) {
                    relId = this.myRelMBeanObjName2RelIdMap.get(mbeanName);
                }
                if (relId != null) {
                    try {
                        this.removeRelation(relId);
                    }
                    catch (Exception exc2) {
                        throw new RuntimeException(exc2.getMessage());
                    }
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "handleNotification");
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getNotificationInfo");
        String ntfClass = "javax.management.relation.RelationNotification";
        String[] ntfTypes = new String[]{"jmx.relation.creation.basic", "jmx.relation.creation.mbean", "jmx.relation.update.basic", "jmx.relation.update.mbean", "jmx.relation.removal.basic", "jmx.relation.removal.mbean"};
        String ntfDesc = "Sent when a relation is created, updated or deleted.";
        MBeanNotificationInfo ntfInfo = new MBeanNotificationInfo(ntfTypes, ntfClass, ntfDesc);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getNotificationInfo");
        return new MBeanNotificationInfo[]{ntfInfo};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRelationTypeInt(RelationType relationTypeObj) throws IllegalArgumentException, InvalidRelationTypeException {
        if (relationTypeObj == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "addRelationTypeInt");
        String relTypeName = relationTypeObj.getRelationTypeName();
        try {
            RelationType relType = this.getRelationType(relTypeName);
            if (relType != null) {
                String excMsg = "There is already a relation type in the Relation Service with name ";
                StringBuilder excMsgStrB = new StringBuilder(excMsg);
                excMsgStrB.append(relTypeName);
                throw new InvalidRelationTypeException(excMsgStrB.toString());
            }
        }
        catch (RelationTypeNotFoundException relationTypeNotFoundException) {
            // empty catch block
        }
        Map<String, RelationType> map = this.myRelType2ObjMap;
        synchronized (map) {
            this.myRelType2ObjMap.put(relTypeName, relationTypeObj);
        }
        if (relationTypeObj instanceof RelationTypeSupport) {
            ((RelationTypeSupport)relationTypeObj).setRelationServiceFlag(true);
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "addRelationTypeInt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RelationType getRelationType(String relationTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        RelationType relType;
        if (relationTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRelationType", relationTypeName);
        Map<String, RelationType> map = this.myRelType2ObjMap;
        synchronized (map) {
            relType = this.myRelType2ObjMap.get(relationTypeName);
        }
        if (relType == null) {
            String excMsg = "No relation type created in the Relation Service with the name ";
            StringBuilder excMsgStrB = new StringBuilder(excMsg);
            excMsgStrB.append(relationTypeName);
            throw new RelationTypeNotFoundException(excMsgStrB.toString());
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRelationType");
        return relType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getRelation(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        Object rel;
        if (relationId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRelation", relationId);
        Map<String, Object> map = this.myRelId2ObjMap;
        synchronized (map) {
            rel = this.myRelId2ObjMap.get(relationId);
        }
        if (rel == null) {
            String excMsg = "No relation associated to relation id " + relationId;
            throw new RelationNotFoundException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRelation");
        return rel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addNewMBeanReference(ObjectName objectName, String relationId, String roleName) throws IllegalArgumentException {
        if (objectName == null || relationId == null || roleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "addNewMBeanReference", new Object[]{objectName, relationId, roleName});
        boolean isNewFlag = false;
        Map<ObjectName, Map<String, List<String>>> map = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (map) {
            Map<String, List<String>> mbeanRefMap = this.myRefedMBeanObjName2RelIdsMap.get(objectName);
            if (mbeanRefMap == null) {
                isNewFlag = true;
                ArrayList<String> roleNames = new ArrayList<String>();
                roleNames.add(roleName);
                mbeanRefMap = new HashMap<String, List<String>>();
                mbeanRefMap.put(relationId, roleNames);
                this.myRefedMBeanObjName2RelIdsMap.put(objectName, mbeanRefMap);
            } else {
                List<String> roleNames = mbeanRefMap.get(relationId);
                if (roleNames == null) {
                    roleNames = new ArrayList<String>();
                    roleNames.add(roleName);
                    mbeanRefMap.put(relationId, roleNames);
                } else {
                    roleNames.add(roleName);
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "addNewMBeanReference");
        return isNewFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMBeanReference(ObjectName objectName, String relationId, String roleName, boolean allRolesFlag) throws IllegalArgumentException {
        if (objectName == null || relationId == null || roleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "removeMBeanReference", new Object[]{objectName, relationId, roleName, allRolesFlag});
        boolean noLongerRefFlag = false;
        Map<ObjectName, Map<String, List<String>>> map = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (map) {
            int obsRefIdx;
            Map<String, List<String>> mbeanRefMap = this.myRefedMBeanObjName2RelIdsMap.get(objectName);
            if (mbeanRefMap == null) {
                JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "removeMBeanReference");
                return true;
            }
            List<String> roleNames = null;
            if (!allRolesFlag && (obsRefIdx = (roleNames = mbeanRefMap.get(relationId)).indexOf(roleName)) != -1) {
                roleNames.remove(obsRefIdx);
            }
            if (roleNames.isEmpty() || allRolesFlag) {
                mbeanRefMap.remove(relationId);
            }
            if (mbeanRefMap.isEmpty()) {
                this.myRefedMBeanObjName2RelIdsMap.remove(objectName);
                noLongerRefFlag = true;
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "removeMBeanReference");
        return noLongerRefFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUnregistrationListener(List<ObjectName> newRefList, List<ObjectName> obsoleteRefList) throws RelationServiceNotRegisteredException {
        if (newRefList != null && obsoleteRefList != null && newRefList.isEmpty() && obsoleteRefList.isEmpty()) {
            return;
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "updateUnregistrationListener", new Object[]{newRefList, obsoleteRefList});
        this.isActive();
        if (newRefList != null || obsoleteRefList != null) {
            boolean newListenerFlag = false;
            if (this.myUnregNtfFilter == null) {
                this.myUnregNtfFilter = new MBeanServerNotificationFilter();
                newListenerFlag = true;
            }
            MBeanServerNotificationFilter mBeanServerNotificationFilter = this.myUnregNtfFilter;
            synchronized (mBeanServerNotificationFilter) {
                if (newRefList != null) {
                    for (ObjectName newObjName : newRefList) {
                        this.myUnregNtfFilter.enableObjectName(newObjName);
                    }
                }
                if (obsoleteRefList != null) {
                    for (ObjectName obsObjName : obsoleteRefList) {
                        this.myUnregNtfFilter.disableObjectName(obsObjName);
                    }
                }
                if (newListenerFlag) {
                    try {
                        this.myMBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this, (NotificationFilter)this.myUnregNtfFilter, null);
                    }
                    catch (InstanceNotFoundException exc) {
                        throw new RelationServiceNotRegisteredException(exc.getMessage());
                    }
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "updateUnregistrationListener");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRelationInt(boolean relationBaseFlag, RelationSupport relationObj, ObjectName relationObjName, String relationId, String relationTypeName, RoleList roleList) throws IllegalArgumentException, RelationServiceNotRegisteredException, RoleNotFoundException, InvalidRelationIdException, RelationTypeNotFoundException, InvalidRoleValueException {
        if (relationId == null || relationTypeName == null || relationBaseFlag && (relationObj == null || relationObjName != null) || !relationBaseFlag && (relationObjName == null || relationObj != null)) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "addRelationInt", new Object[]{relationBaseFlag, relationObj, relationObjName, relationId, relationTypeName, roleList});
        this.isActive();
        try {
            Object rel = this.getRelation(relationId);
            if (rel != null) {
                String excMsg = "There is already a relation with id ";
                StringBuilder excMsgStrB = new StringBuilder(excMsg);
                excMsgStrB.append(relationId);
                throw new InvalidRelationIdException(excMsgStrB.toString());
            }
        }
        catch (RelationNotFoundException rel) {
            // empty catch block
        }
        RelationType relType = this.getRelationType(relationTypeName);
        ArrayList<RoleInfo> roleInfoList = new ArrayList<RoleInfo>(relType.getRoleInfos());
        if (roleList != null) {
            for (Role currRole : roleList.asList()) {
                RoleInfo roleInfo;
                String currRoleName = currRole.getRoleName();
                List<ObjectName> currRoleValue = currRole.getRoleValue();
                try {
                    roleInfo = relType.getRoleInfo(currRoleName);
                }
                catch (RoleInfoNotFoundException exc) {
                    throw new RoleNotFoundException(exc.getMessage());
                }
                Integer status = this.checkRoleInt(2, currRoleName, currRoleValue, roleInfo, false);
                int pbType = status;
                if (pbType != 0) {
                    RelationService.throwRoleProblemException(pbType, currRoleName);
                }
                int roleInfoIdx = roleInfoList.indexOf(roleInfo);
                roleInfoList.remove(roleInfoIdx);
            }
        }
        this.initializeMissingRoles(relationBaseFlag, relationObj, relationObjName, relationId, relationTypeName, roleInfoList);
        Object i$ = this.myRelId2ObjMap;
        synchronized (i$) {
            if (relationBaseFlag) {
                this.myRelId2ObjMap.put(relationId, relationObj);
            } else {
                this.myRelId2ObjMap.put(relationId, relationObjName);
            }
        }
        i$ = this.myRelId2RelTypeMap;
        synchronized (i$) {
            this.myRelId2RelTypeMap.put(relationId, relationTypeName);
        }
        i$ = this.myRelType2RelIdsMap;
        synchronized (i$) {
            List<String> relIdList = this.myRelType2RelIdsMap.get(relationTypeName);
            boolean firstRelFlag = false;
            if (relIdList == null) {
                firstRelFlag = true;
                relIdList = new ArrayList<String>();
            }
            relIdList.add(relationId);
            if (firstRelFlag) {
                this.myRelType2RelIdsMap.put(relationTypeName, relIdList);
            }
        }
        for (Role currRole : roleList.asList()) {
            ArrayList<ObjectName> dummyList = new ArrayList<ObjectName>();
            try {
                this.updateRoleMap(relationId, currRole, dummyList);
            }
            catch (RelationNotFoundException relationNotFoundException) {}
        }
        try {
            this.sendRelationCreationNotification(relationId);
        }
        catch (RelationNotFoundException relationNotFoundException) {
            // empty catch block
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "addRelationInt");
    }

    private Integer checkRoleInt(int chkType, String roleName, List<ObjectName> roleValue, RoleInfo roleInfo, boolean writeChkFlag) throws IllegalArgumentException {
        boolean isWritable;
        if (roleName == null || roleInfo == null || chkType == 2 && roleValue == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "checkRoleInt", new Object[]{chkType, roleName, roleValue, roleInfo, writeChkFlag});
        String expName = roleInfo.getName();
        if (!roleName.equals(expName)) {
            JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
            return 1;
        }
        if (chkType == 1) {
            boolean isReadable = roleInfo.isReadable();
            if (!isReadable) {
                JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
                return 2;
            }
            JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
            return new Integer(0);
        }
        if (writeChkFlag && !(isWritable = roleInfo.isWritable())) {
            JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
            return new Integer(3);
        }
        int refNbr = roleValue.size();
        boolean chkMinFlag = roleInfo.checkMinDegree(refNbr);
        if (!chkMinFlag) {
            JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
            return new Integer(4);
        }
        boolean chkMaxFlag = roleInfo.checkMaxDegree(refNbr);
        if (!chkMaxFlag) {
            JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
            return new Integer(5);
        }
        String expClassName = roleInfo.getRefMBeanClassName();
        for (ObjectName currObjName : roleValue) {
            if (currObjName == null) {
                JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
                return new Integer(7);
            }
            try {
                boolean classSts = this.myMBeanServer.isInstanceOf(currObjName, expClassName);
                if (classSts) continue;
                JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
                return new Integer(6);
            }
            catch (InstanceNotFoundException exc) {
                JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
                return new Integer(7);
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
        return new Integer(0);
    }

    private void initializeMissingRoles(boolean relationBaseFlag, RelationSupport relationObj, ObjectName relationObjName, String relationId, String relationTypeName, List<RoleInfo> roleInfoList) throws IllegalArgumentException, RelationServiceNotRegisteredException, InvalidRoleValueException {
        if (relationBaseFlag && (relationObj == null || relationObjName != null) || !relationBaseFlag && (relationObjName == null || relationObj != null) || relationId == null || relationTypeName == null || roleInfoList == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "initializeMissingRoles", new Object[]{relationBaseFlag, relationObj, relationObjName, relationId, relationTypeName, roleInfoList});
        this.isActive();
        for (RoleInfo currRoleInfo : roleInfoList) {
            String roleName = currRoleInfo.getName();
            ArrayList<ObjectName> emptyValue = new ArrayList<ObjectName>();
            Role role = new Role(roleName, emptyValue);
            if (relationBaseFlag) {
                try {
                    relationObj.setRoleInt(role, true, this, false);
                    continue;
                }
                catch (RoleNotFoundException exc1) {
                    throw new RuntimeException(exc1.getMessage());
                }
                catch (RelationNotFoundException exc2) {
                    throw new RuntimeException(exc2.getMessage());
                }
                catch (RelationTypeNotFoundException exc3) {
                    throw new RuntimeException(exc3.getMessage());
                }
            }
            Object[] params = new Object[]{role};
            String[] signature = new String[]{"javax.management.relation.Role"};
            try {
                this.myMBeanServer.setAttribute(relationObjName, new Attribute("Role", role));
            }
            catch (InstanceNotFoundException exc1) {
                throw new RuntimeException(exc1.getMessage());
            }
            catch (ReflectionException exc3) {
                throw new RuntimeException(exc3.getMessage());
            }
            catch (MBeanException exc2) {
                Exception wrappedExc = exc2.getTargetException();
                if (wrappedExc instanceof InvalidRoleValueException) {
                    throw (InvalidRoleValueException)wrappedExc;
                }
                throw new RuntimeException(wrappedExc.getMessage());
            }
            catch (AttributeNotFoundException exc4) {
                throw new RuntimeException(exc4.getMessage());
            }
            catch (InvalidAttributeValueException exc5) {
                throw new RuntimeException(exc5.getMessage());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "initializeMissingRoles");
    }

    static void throwRoleProblemException(int pbType, String roleName) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException {
        if (roleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        int excType = 0;
        String excMsgPart = null;
        switch (pbType) {
            case 1: {
                excMsgPart = " does not exist in relation.";
                excType = 1;
                break;
            }
            case 2: {
                excMsgPart = " is not readable.";
                excType = 1;
                break;
            }
            case 3: {
                excMsgPart = " is not writable.";
                excType = 1;
                break;
            }
            case 4: {
                excMsgPart = " has a number of MBean references less than the expected minimum degree.";
                excType = 2;
                break;
            }
            case 5: {
                excMsgPart = " has a number of MBean references greater than the expected maximum degree.";
                excType = 2;
                break;
            }
            case 6: {
                excMsgPart = " has an MBean reference to an MBean not of the expected class of references for that role.";
                excType = 2;
                break;
            }
            case 7: {
                excMsgPart = " has a reference to null or to an MBean not registered.";
                excType = 2;
            }
        }
        StringBuilder excMsgStrB = new StringBuilder(roleName);
        excMsgStrB.append(excMsgPart);
        String excMsg = excMsgStrB.toString();
        if (excType == 1) {
            throw new RoleNotFoundException(excMsg);
        }
        if (excType == 2) {
            throw new InvalidRoleValueException(excMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotificationInt(int intNtfType, String message, String relationId, List<ObjectName> unregMBeanList, String roleName, List<ObjectName> roleNewValue, List<ObjectName> oldValue) throws IllegalArgumentException, RelationNotFoundException {
        String relTypeName;
        if (message == null || relationId == null || intNtfType != 3 && unregMBeanList != null || intNtfType == 2 && (roleName == null || roleNewValue == null || oldValue == null)) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "sendNotificationInt", new Object[]{intNtfType, message, relationId, unregMBeanList, roleName, roleNewValue, oldValue});
        Map<String, String> map = this.myRelId2RelTypeMap;
        synchronized (map) {
            relTypeName = this.myRelId2RelTypeMap.get(relationId);
        }
        ObjectName relObjName = this.isRelationMBean(relationId);
        String ntfType = null;
        if (relObjName != null) {
            switch (intNtfType) {
                case 1: {
                    ntfType = "jmx.relation.creation.mbean";
                    break;
                }
                case 2: {
                    ntfType = "jmx.relation.update.mbean";
                    break;
                }
                case 3: {
                    ntfType = "jmx.relation.removal.mbean";
                }
            }
        } else {
            switch (intNtfType) {
                case 1: {
                    ntfType = "jmx.relation.creation.basic";
                    break;
                }
                case 2: {
                    ntfType = "jmx.relation.update.basic";
                    break;
                }
                case 3: {
                    ntfType = "jmx.relation.removal.basic";
                }
            }
        }
        Long seqNo = this.atomicSeqNo.incrementAndGet();
        Date currDate = new Date();
        long timeStamp = currDate.getTime();
        RelationNotification ntf = null;
        if (ntfType.equals("jmx.relation.creation.basic") || ntfType.equals("jmx.relation.creation.mbean") || ntfType.equals("jmx.relation.removal.basic") || ntfType.equals("jmx.relation.removal.mbean")) {
            ntf = new RelationNotification(ntfType, this, seqNo, timeStamp, message, relationId, relTypeName, relObjName, unregMBeanList);
        } else if (ntfType.equals("jmx.relation.update.basic") || ntfType.equals("jmx.relation.update.mbean")) {
            ntf = new RelationNotification(ntfType, this, seqNo, timeStamp, message, relationId, relTypeName, relObjName, roleName, roleNewValue, oldValue);
        }
        this.sendNotification(ntf);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "sendNotificationInt");
    }

    private void handleReferenceUnregistration(String relationId, ObjectName objectName, List<String> roleNameList) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException, RoleNotFoundException {
        if (relationId == null || roleNameList == null || objectName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "handleReferenceUnregistration", new Object[]{relationId, objectName, roleNameList});
        this.isActive();
        String currRelTypeName = this.getRelationTypeName(relationId);
        Object relObj = this.getRelation(relationId);
        boolean deleteRelFlag = false;
        for (String currRoleName : roleNameList) {
            RoleInfo currRoleInfo;
            if (deleteRelFlag) break;
            int currRoleRefNbr = this.getRoleCardinality(relationId, currRoleName);
            int currRoleNewRefNbr = currRoleRefNbr - 1;
            try {
                currRoleInfo = this.getRoleInfo(currRelTypeName, currRoleName);
            }
            catch (RelationTypeNotFoundException exc1) {
                throw new RuntimeException(exc1.getMessage());
            }
            catch (RoleInfoNotFoundException exc2) {
                throw new RuntimeException(exc2.getMessage());
            }
            boolean chkMinFlag = currRoleInfo.checkMinDegree(currRoleNewRefNbr);
            if (chkMinFlag) continue;
            deleteRelFlag = true;
        }
        if (deleteRelFlag) {
            this.removeRelation(relationId);
        } else {
            for (String currRoleName : roleNameList) {
                if (relObj instanceof RelationSupport) {
                    try {
                        ((RelationSupport)relObj).handleMBeanUnregistrationInt(objectName, currRoleName, true, this);
                        continue;
                    }
                    catch (RelationTypeNotFoundException exc3) {
                        throw new RuntimeException(exc3.getMessage());
                    }
                    catch (InvalidRoleValueException exc4) {
                        throw new RuntimeException(exc4.getMessage());
                    }
                }
                Object[] params = new Object[]{objectName, currRoleName};
                String[] signature = new String[]{"javax.management.ObjectName", "java.lang.String"};
                try {
                    this.myMBeanServer.invoke((ObjectName)relObj, "handleMBeanUnregistration", params, signature);
                }
                catch (InstanceNotFoundException exc1) {
                    throw new RuntimeException(exc1.getMessage());
                }
                catch (ReflectionException exc3) {
                    throw new RuntimeException(exc3.getMessage());
                }
                catch (MBeanException exc2) {
                    Exception wrappedExc = exc2.getTargetException();
                    throw new RuntimeException(wrappedExc.getMessage());
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "handleReferenceUnregistration");
    }
}

