/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.ConstructorProperties;
import javax.swing.border.AbstractBorder;

public class EtchedBorder
extends AbstractBorder {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int etchType;
    protected Color highlight;
    protected Color shadow;

    public EtchedBorder() {
        this(1);
    }

    public EtchedBorder(int etchType) {
        this(etchType, null, null);
    }

    public EtchedBorder(Color highlight, Color shadow) {
        this(1, highlight, shadow);
    }

    @ConstructorProperties(value={"etchType", "highlightColor", "shadowColor"})
    public EtchedBorder(int etchType, Color highlight, Color shadow) {
        this.etchType = etchType;
        this.highlight = highlight;
        this.shadow = shadow;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        g.translate(x, y);
        g.setColor(this.etchType == 1 ? this.getShadowColor(c) : this.getHighlightColor(c));
        g.drawRect(0, 0, w - 2, h - 2);
        g.setColor(this.etchType == 1 ? this.getHighlightColor(c) : this.getShadowColor(c));
        g.drawLine(1, h - 3, 1, 1);
        g.drawLine(1, 1, w - 3, 1);
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, h - 1, w - 1, 0);
        g.translate(-x, -y);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.set(2, 2, 2, 2);
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public int getEtchType() {
        return this.etchType;
    }

    public Color getHighlightColor(Component c) {
        return this.highlight != null ? this.highlight : c.getBackground().brighter();
    }

    public Color getHighlightColor() {
        return this.highlight;
    }

    public Color getShadowColor(Component c) {
        return this.shadow != null ? this.shadow : c.getBackground().darker();
    }

    public Color getShadowColor() {
        return this.shadow;
    }
}

