/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixNativeDispatcher;

class UnixUserPrincipals {
    static final User SPECIAL_OWNER = UnixUserPrincipals.createSpecial("OWNER@");
    static final User SPECIAL_GROUP = UnixUserPrincipals.createSpecial("GROUP@");
    static final User SPECIAL_EVERYONE = UnixUserPrincipals.createSpecial("EVERYONE@");

    UnixUserPrincipals() {
    }

    private static User createSpecial(String name) {
        return new User(-1, name);
    }

    static User fromUid(int uid) {
        String name = null;
        try {
            name = new String(UnixNativeDispatcher.getpwuid(uid));
        }
        catch (UnixException x) {
            name = Integer.toString(uid);
        }
        return new User(uid, name);
    }

    static Group fromGid(int gid) {
        String name = null;
        try {
            name = new String(UnixNativeDispatcher.getgrgid(gid));
        }
        catch (UnixException x) {
            name = Integer.toString(gid);
        }
        return new Group(gid, name);
    }

    private static int lookupName(String name, boolean isGroup) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("lookupUserInformation"));
        }
        int id = -1;
        try {
            id = isGroup ? UnixNativeDispatcher.getgrnam(name) : UnixNativeDispatcher.getpwnam(name);
        }
        catch (UnixException x) {
            throw new IOException(name + ": " + x.errorString());
        }
        if (id == -1) {
            try {
                id = Integer.parseInt(name);
            }
            catch (NumberFormatException ignore) {
                throw new UserPrincipalNotFoundException(name);
            }
        }
        return id;
    }

    static UserPrincipal lookupUser(String name) throws IOException {
        if (name.equals(SPECIAL_OWNER.getName())) {
            return SPECIAL_OWNER;
        }
        if (name.equals(SPECIAL_GROUP.getName())) {
            return SPECIAL_GROUP;
        }
        if (name.equals(SPECIAL_EVERYONE.getName())) {
            return SPECIAL_EVERYONE;
        }
        int uid = UnixUserPrincipals.lookupName(name, false);
        return new User(uid, name);
    }

    static GroupPrincipal lookupGroup(String group) throws IOException {
        int gid = UnixUserPrincipals.lookupName(group, true);
        return new Group(gid, group);
    }

    static class Group
    extends User
    implements GroupPrincipal {
        Group(int id, String name) {
            super(id, true, name);
        }
    }

    static class User
    implements UserPrincipal {
        private final int id;
        private final boolean isGroup;
        private final String name;

        private User(int id, boolean isGroup, String name) {
            this.id = id;
            this.isGroup = isGroup;
            this.name = name;
        }

        User(int id, String name) {
            this(id, false, name);
        }

        int uid() {
            if (this.isGroup) {
                throw new AssertionError();
            }
            return this.id;
        }

        int gid() {
            if (this.isGroup) {
                return this.id;
            }
            throw new AssertionError();
        }

        boolean isSpecial() {
            return this.id == -1;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof User)) {
                return false;
            }
            User other = (User)obj;
            if (this.id != other.id || this.isGroup != other.isGroup) {
                return false;
            }
            if (this.id == -1 && other.id == -1) {
                return this.name.equals(other.name);
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.id != -1 ? this.id : this.name.hashCode();
        }
    }
}

