/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XExtData
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 32;
    }

    @Override
    public int getDataSize() {
        return XExtData.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XExtData(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XExtData() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XExtData.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_number() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_number(int v) {
        log.finest("");
        Native.putInt(this.pData + 0L, v);
    }

    public XExtData get_next(int index) {
        log.finest("");
        return Native.getLong(this.pData + 8L) != 0L ? new XExtData(Native.getLong(this.pData + 8L) + (long)(index * 32)) : null;
    }

    public long get_next() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_next(long v) {
        log.finest("");
        Native.putLong(this.pData + 8L, v);
    }

    public long get_free_private(int index) {
        log.finest("");
        return Native.getLong(this.pData + 16L) + (long)(index * Native.getLongSize());
    }

    public long get_free_private() {
        log.finest("");
        return Native.getLong(this.pData + 16L);
    }

    public void set_free_private(long v) {
        log.finest("");
        Native.putLong(this.pData + 16L, v);
    }

    public long get_private_data(int index) {
        log.finest("");
        return Native.getLong(this.pData + 24L) + (long)(index * Native.getLongSize());
    }

    public long get_private_data() {
        log.finest("");
        return Native.getLong(this.pData + 24L);
    }

    public void set_private_data(long v) {
        log.finest("");
        Native.putLong(this.pData + 24L, v);
    }

    @Override
    String getName() {
        return "XExtData";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(160);
        ret.append("number = ").append(this.get_number()).append(", ");
        ret.append("next = ").append(this.get_next()).append(", ");
        ret.append("free_private = ").append(this.get_free_private()).append(", ");
        ret.append("private_data = ").append(this.get_private_data()).append(", ");
        return ret.toString();
    }
}

