/*
 * Decompiled with CFR 0.152.
 */
package javax.annotation.processing;

import javax.annotation.processing.Completion;

public class Completions {
    private Completions() {
    }

    public static Completion of(String value, String message) {
        return new SimpleCompletion(value, message);
    }

    public static Completion of(String value) {
        return new SimpleCompletion(value, "");
    }

    private static class SimpleCompletion
    implements Completion {
        private String value;
        private String message;

        SimpleCompletion(String value, String message) {
            if (value == null || message == null) {
                throw new NullPointerException("Null completion strings not accepted.");
            }
            this.value = value;
            this.message = message;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "[\"" + this.value + "\", \"" + this.message + "\"]";
        }
    }
}

