/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.BooleanValueExp;
import javax.management.InvalidApplicationException;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class BinaryRelQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -5690656271650491000L;
    private int relOp;
    private ValueExp exp1;
    private ValueExp exp2;

    public BinaryRelQueryExp() {
    }

    public BinaryRelQueryExp(int op, ValueExp v1, ValueExp v2) {
        this.relOp = op;
        this.exp1 = v1;
        this.exp2 = v2;
    }

    public int getOperator() {
        return this.relOp;
    }

    public ValueExp getLeftValue() {
        return this.exp1;
    }

    public ValueExp getRightValue() {
        return this.exp2;
    }

    @Override
    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp val1 = this.exp1.apply(name);
        ValueExp val2 = this.exp2.apply(name);
        boolean numeric = val1 instanceof NumericValueExp;
        boolean bool = val1 instanceof BooleanValueExp;
        if (numeric) {
            if (((NumericValueExp)val1).isLong()) {
                long lval1 = ((NumericValueExp)val1).longValue();
                long lval2 = ((NumericValueExp)val2).longValue();
                switch (this.relOp) {
                    case 0: {
                        return lval1 > lval2;
                    }
                    case 1: {
                        return lval1 < lval2;
                    }
                    case 2: {
                        return lval1 >= lval2;
                    }
                    case 3: {
                        return lval1 <= lval2;
                    }
                    case 4: {
                        return lval1 == lval2;
                    }
                }
            } else {
                double dval1 = ((NumericValueExp)val1).doubleValue();
                double dval2 = ((NumericValueExp)val2).doubleValue();
                switch (this.relOp) {
                    case 0: {
                        return dval1 > dval2;
                    }
                    case 1: {
                        return dval1 < dval2;
                    }
                    case 2: {
                        return dval1 >= dval2;
                    }
                    case 3: {
                        return dval1 <= dval2;
                    }
                    case 4: {
                        return dval1 == dval2;
                    }
                }
            }
        } else if (bool) {
            boolean bval1 = ((BooleanValueExp)val1).getValue();
            boolean bval2 = ((BooleanValueExp)val2).getValue();
            switch (this.relOp) {
                case 0: {
                    return bval1 && !bval2;
                }
                case 1: {
                    return !bval1 && bval2;
                }
                case 2: {
                    return bval1 || !bval2;
                }
                case 3: {
                    return !bval1 || bval2;
                }
                case 4: {
                    return bval1 == bval2;
                }
            }
        } else {
            String sval1 = ((StringValueExp)val1).getValue();
            String sval2 = ((StringValueExp)val2).getValue();
            switch (this.relOp) {
                case 0: {
                    return sval1.compareTo(sval2) > 0;
                }
                case 1: {
                    return sval1.compareTo(sval2) < 0;
                }
                case 2: {
                    return sval1.compareTo(sval2) >= 0;
                }
                case 3: {
                    return sval1.compareTo(sval2) <= 0;
                }
                case 4: {
                    return sval1.compareTo(sval2) == 0;
                }
            }
        }
        return false;
    }

    public String toString() {
        return "(" + this.exp1 + ") " + this.relOpString() + " (" + this.exp2 + ")";
    }

    private String relOpString() {
        switch (this.relOp) {
            case 0: {
                return ">";
            }
            case 1: {
                return "<";
            }
            case 2: {
                return ">=";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return "=";
            }
        }
        return "=";
    }
}

