/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import sun.print.RasterPrinterJob;

public class ProxyGraphics2D
extends Graphics2D
implements PrinterGraphics {
    Graphics2D mGraphics;
    PrinterJob mPrinterJob;

    public ProxyGraphics2D(Graphics2D graphics, PrinterJob printerJob) {
        this.mGraphics = graphics;
        this.mPrinterJob = printerJob;
    }

    public Graphics2D getDelegate() {
        return this.mGraphics;
    }

    public void setDelegate(Graphics2D graphics) {
        this.mGraphics = graphics;
    }

    @Override
    public PrinterJob getPrinterJob() {
        return this.mPrinterJob;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return ((RasterPrinterJob)this.mPrinterJob).getPrinterGraphicsConfig();
    }

    @Override
    public Graphics create() {
        return new ProxyGraphics2D((Graphics2D)this.mGraphics.create(), this.mPrinterJob);
    }

    @Override
    public void translate(int x, int y) {
        this.mGraphics.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.mGraphics.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.mGraphics.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.mGraphics.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.mGraphics.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.mGraphics.shear(shx, shy);
    }

    @Override
    public Color getColor() {
        return this.mGraphics.getColor();
    }

    @Override
    public void setColor(Color c) {
        this.mGraphics.setColor(c);
    }

    @Override
    public void setPaintMode() {
        this.mGraphics.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.mGraphics.setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this.mGraphics.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.mGraphics.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.mGraphics.getFontMetrics(f);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.mGraphics.getFontRenderContext();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.mGraphics.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.mGraphics.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.mGraphics.setClip(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        return this.mGraphics.getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.mGraphics.setClip(clip);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.mGraphics.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.mGraphics.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.mGraphics.fillRect(x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.mGraphics.clearRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.mGraphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.mGraphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.mGraphics.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.mGraphics.fillOval(x, y, width, height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.mGraphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.mGraphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.mGraphics.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.mGraphics.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.mGraphics.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.mGraphics.drawString(str, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.mGraphics.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.mGraphics.drawString(iterator, x, y);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.mGraphics.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.mGraphics.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        boolean result;
        if (img == null) {
            return true;
        }
        if (this.needToCopyBgColorImage(img)) {
            BufferedImage imageCopy = this.getBufferedImageCopy(img, bgcolor);
            result = this.mGraphics.drawImage((Image)imageCopy, x, y, null);
        } else {
            result = this.mGraphics.drawImage(img, x, y, bgcolor, observer);
        }
        return result;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        boolean result;
        if (img == null) {
            return true;
        }
        if (this.needToCopyBgColorImage(img)) {
            BufferedImage imageCopy = this.getBufferedImageCopy(img, bgcolor);
            result = this.mGraphics.drawImage(imageCopy, x, y, width, height, null);
        } else {
            result = this.mGraphics.drawImage(img, x, y, width, height, bgcolor, observer);
        }
        return result;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.mGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        boolean result;
        if (img == null) {
            return true;
        }
        if (this.needToCopyBgColorImage(img)) {
            BufferedImage imageCopy = this.getBufferedImageCopy(img, bgcolor);
            result = this.mGraphics.drawImage(imageCopy, dx1, dy1, dx2, dy2, sy1, sy1, sx2, sy2, null);
        } else {
            result = this.mGraphics.drawImage(img, dx1, dy1, dx2, dy2, sy1, sy1, sx2, sy2, bgcolor, observer);
        }
        return result;
    }

    private boolean needToCopyBgColorImage(Image img) {
        AffineTransform transform = this.getTransform();
        return (transform.getType() & 0x30) != 0;
    }

    private BufferedImage getBufferedImageCopy(Image img, Color bgcolor) {
        BufferedImage imageCopy = null;
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        if (width > 0 && height > 0) {
            int imageType;
            if (img instanceof BufferedImage) {
                BufferedImage bufImage = (BufferedImage)img;
                imageType = bufImage.getType();
            } else {
                imageType = 2;
            }
            imageCopy = new BufferedImage(width, height, imageType);
            Graphics2D g = imageCopy.createGraphics();
            g.drawImage(img, 0, 0, bgcolor, null);
            g.dispose();
        } else {
            imageCopy = null;
        }
        return imageCopy;
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.mGraphics.drawRenderedImage(img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        AffineTransform reverseTransform;
        if (img == null) {
            return;
        }
        AffineTransform pipeTransform = this.getTransform();
        AffineTransform concatTransform = new AffineTransform(xform);
        concatTransform.concatenate(pipeTransform);
        RenderContext rc = new RenderContext(concatTransform);
        try {
            reverseTransform = pipeTransform.createInverse();
        }
        catch (NoninvertibleTransformException nte) {
            rc = new RenderContext(pipeTransform);
            reverseTransform = new AffineTransform();
        }
        RenderedImage rendering = img.createRendering(rc);
        this.drawRenderedImage(rendering, reverseTransform);
    }

    @Override
    public void dispose() {
        this.mGraphics.dispose();
    }

    @Override
    public void finalize() {
    }

    @Override
    public void draw(Shape s) {
        this.mGraphics.draw(s);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.mGraphics.drawImage(img, xform, obs);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.mGraphics.drawImage(img, op, x, y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.mGraphics.drawString(str, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.mGraphics.drawGlyphVector(g, x, y);
    }

    @Override
    public void fill(Shape s) {
        this.mGraphics.fill(s);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.mGraphics.hit(rect, s, onStroke);
    }

    @Override
    public void setComposite(Composite comp) {
        this.mGraphics.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.mGraphics.setPaint(paint);
    }

    @Override
    public void setStroke(Stroke s) {
        this.mGraphics.setStroke(s);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintCategory, Object hintValue) {
        this.mGraphics.setRenderingHint(hintCategory, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintCategory) {
        return this.mGraphics.getRenderingHint(hintCategory);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.mGraphics.setRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.mGraphics.addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.mGraphics.getRenderingHints();
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.mGraphics.transform(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.mGraphics.setTransform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return this.mGraphics.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.mGraphics.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.mGraphics.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.mGraphics.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.mGraphics.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.mGraphics.getStroke();
    }

    @Override
    public void clip(Shape s) {
        this.mGraphics.clip(s);
    }
}

