/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class APRep {
    public int pvno;
    public int msgType;
    public EncryptedData encPart;

    public APRep(EncryptedData new_encPart) {
        this.pvno = 5;
        this.msgType = 15;
        this.encPart = new_encPart;
    }

    public APRep(byte[] data) throws Asn1Exception, KrbApErrException, IOException {
        this.init(new DerValue(data));
    }

    public APRep(DerValue encoding) throws Asn1Exception, KrbApErrException, IOException {
        this.init(encoding);
    }

    private void init(DerValue encoding) throws Asn1Exception, KrbApErrException, IOException {
        if ((encoding.getTag() & 0x1F) != 15 || !encoding.isApplication() || !encoding.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.pvno = subDer.getData().getBigInteger().intValue();
        if (this.pvno != 5) {
            throw new KrbApErrException(39);
        }
        subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.msgType = subDer.getData().getBigInteger().intValue();
        if (this.msgType != 15) {
            throw new KrbApErrException(40);
        }
        this.encPart = EncryptedData.parse(der.getData(), (byte)2, false);
        if (der.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.pvno));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.msgType));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)2), this.encPart.asn1Encode());
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        DerOutputStream aprep = new DerOutputStream();
        aprep.write(DerValue.createTag((byte)64, true, (byte)15), temp);
        return aprep.toByteArray();
    }
}

