/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import sun.misc.BASE64Encoder;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpURLConnection;

class BasicAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    String auth;

    public BasicAuthentication(boolean isProxy, String host, int port, String realm, PasswordAuthentication pw) {
        byte[] nameBytes;
        block3: {
            super(isProxy ? (char)'p' : 's', AuthScheme.BASIC, host, port, realm);
            String plain2 = pw.getUserName() + ":";
            nameBytes = null;
            try {
                nameBytes = plain2.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        char[] passwd = pw.getPassword();
        byte[] passwdBytes = new byte[passwd.length];
        for (int i = 0; i < passwd.length; ++i) {
            passwdBytes[i] = (byte)passwd[i];
        }
        byte[] concat = new byte[nameBytes.length + passwdBytes.length];
        System.arraycopy(nameBytes, 0, concat, 0, nameBytes.length);
        System.arraycopy(passwdBytes, 0, concat, nameBytes.length, passwdBytes.length);
        this.auth = "Basic " + new BasicBASE64Encoder().encode(concat);
        this.pw = pw;
    }

    public BasicAuthentication(boolean isProxy, String host, int port, String realm, String auth) {
        super(isProxy ? (char)'p' : 's', AuthScheme.BASIC, host, port, realm);
        this.auth = "Basic " + auth;
    }

    public BasicAuthentication(boolean isProxy, URL url, String realm, PasswordAuthentication pw) {
        byte[] nameBytes;
        block3: {
            super(isProxy ? (char)'p' : 's', AuthScheme.BASIC, url, realm);
            String plain2 = pw.getUserName() + ":";
            nameBytes = null;
            try {
                nameBytes = plain2.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        char[] passwd = pw.getPassword();
        byte[] passwdBytes = new byte[passwd.length];
        for (int i = 0; i < passwd.length; ++i) {
            passwdBytes[i] = (byte)passwd[i];
        }
        byte[] concat = new byte[nameBytes.length + passwdBytes.length];
        System.arraycopy(nameBytes, 0, concat, 0, nameBytes.length);
        System.arraycopy(passwdBytes, 0, concat, nameBytes.length, passwdBytes.length);
        this.auth = "Basic " + new BasicBASE64Encoder().encode(concat);
        this.pw = pw;
    }

    public BasicAuthentication(boolean isProxy, URL url, String realm, String auth) {
        super(isProxy ? (char)'p' : 's', AuthScheme.BASIC, url, realm);
        this.auth = "Basic " + auth;
    }

    @Override
    public boolean supportsPreemptiveAuthorization() {
        return true;
    }

    @Override
    public boolean setHeaders(HttpURLConnection conn, HeaderParser p, String raw) {
        conn.setAuthenticationProperty(this.getHeaderName(), this.getHeaderValue(null, null));
        return true;
    }

    @Override
    public String getHeaderValue(URL url, String method) {
        return this.auth;
    }

    @Override
    public boolean isAuthorizationStale(String header) {
        return false;
    }

    static String getRootPath(String npath, String opath) {
        int index = 0;
        try {
            npath = new URI(npath).normalize().getPath();
            opath = new URI(opath).normalize().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        while (index < opath.length()) {
            int toindex = opath.indexOf(47, index + 1);
            if (toindex != -1 && opath.regionMatches(0, npath, 0, toindex + 1)) {
                index = toindex;
                continue;
            }
            return opath.substring(0, index + 1);
        }
        return npath;
    }

    private class BasicBASE64Encoder
    extends BASE64Encoder {
        private BasicBASE64Encoder() {
        }

        @Override
        protected int bytesPerLine() {
            return 10000;
        }
    }
}

