/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

public final class Parsing {
    public static int parseUnsignedInt(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 5 || radix == 10 && len <= 9) {
                return Integer.parseInt(s, radix);
            }
            long ell = Long.parseLong(s, radix);
            if ((ell & 0xFFFFFFFF00000000L) == 0L) {
                return (int)ell;
            }
            throw new NumberFormatException(String.format("String value %s exceeds range of unsigned int.", s));
        }
        throw new NumberFormatException("For input string: \"" + s + "\"");
    }

    public static int parseUnsignedInt(String s) throws NumberFormatException {
        return Parsing.parseUnsignedInt(s, 10);
    }
}

