/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Control;

public abstract class EnumControl
extends Control {
    private Object[] values;
    private Object value;

    protected EnumControl(Type type, Object[] values, Object value) {
        super(type);
        this.values = values;
        this.value = value;
    }

    public void setValue(Object value) {
        if (!this.isValueSupported(value)) {
            throw new IllegalArgumentException("Requested value " + value + " is not supported.");
        }
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Object[] getValues() {
        Object[] localArray = new Object[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            localArray[i] = this.values[i];
        }
        return localArray;
    }

    private boolean isValueSupported(Object value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!value.equals(this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return new String(this.getType() + " with current value: " + this.getValue());
    }

    public static class Type
    extends Control.Type {
        public static final Type REVERB = new Type("Reverb");

        protected Type(String name) {
            super(name);
        }
    }
}

