/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.text.normalizer.ICUBinary;

final class NormalizerDataReader
implements ICUBinary.Authenticate {
    private DataInputStream dataInputStream;
    private byte[] unicodeVersion;
    private static final byte[] DATA_FORMAT_ID = new byte[]{78, 111, 114, 109};
    private static final byte[] DATA_FORMAT_VERSION = new byte[]{2, 2, 5, 2};

    protected NormalizerDataReader(InputStream inputStream) throws IOException {
        this.unicodeVersion = ICUBinary.readHeader(inputStream, DATA_FORMAT_ID, this);
        this.dataInputStream = new DataInputStream(inputStream);
    }

    protected int[] readIndexes(int length) throws IOException {
        int[] indexes = new int[length];
        for (int i = 0; i < length; ++i) {
            indexes[i] = this.dataInputStream.readInt();
        }
        return indexes;
    }

    protected void read(byte[] normBytes, byte[] fcdBytes, byte[] auxBytes, char[] extraData, char[] combiningTable) throws IOException {
        int i;
        this.dataInputStream.readFully(normBytes);
        for (i = 0; i < extraData.length; ++i) {
            extraData[i] = this.dataInputStream.readChar();
        }
        for (i = 0; i < combiningTable.length; ++i) {
            combiningTable[i] = this.dataInputStream.readChar();
        }
        this.dataInputStream.readFully(fcdBytes);
        this.dataInputStream.readFully(auxBytes);
    }

    public byte[] getDataFormatVersion() {
        return DATA_FORMAT_VERSION;
    }

    @Override
    public boolean isDataVersionAcceptable(byte[] version) {
        return version[0] == DATA_FORMAT_VERSION[0] && version[2] == DATA_FORMAT_VERSION[2] && version[3] == DATA_FORMAT_VERSION[3];
    }

    public byte[] getUnicodeVersion() {
        return this.unicodeVersion;
    }
}

