/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLUtils {
    private static final String PROPS_DTD_URI = "http://java.sun.com/dtd/properties.dtd";
    private static final String PROPS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for properties --><!ELEMENT properties ( comment?, entry* ) ><!ATTLIST properties version CDATA #FIXED \"1.0\"><!ELEMENT comment (#PCDATA) ><!ELEMENT entry (#PCDATA) ><!ATTLIST entry  key CDATA #REQUIRED>";
    private static final String EXTERNAL_XML_VERSION = "1.0";

    XMLUtils() {
    }

    static void load(Properties props, InputStream in) throws IOException, InvalidPropertiesFormatException {
        Document doc = null;
        try {
            doc = XMLUtils.getLoadingDoc(in);
        }
        catch (SAXException saxe) {
            throw new InvalidPropertiesFormatException(saxe);
        }
        Element propertiesElement = doc.getDocumentElement();
        String xmlVersion = propertiesElement.getAttribute("version");
        if (xmlVersion.compareTo(EXTERNAL_XML_VERSION) > 0) {
            throw new InvalidPropertiesFormatException("Exported Properties file format version " + xmlVersion + " is not supported. This java installation can read" + " versions " + EXTERNAL_XML_VERSION + " or older. You" + " may need to install a newer version of JDK.");
        }
        XMLUtils.importProperties(props, propertiesElement);
    }

    static Document getLoadingDoc(InputStream in) throws SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setValidating(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringComments(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new Resolver());
            db.setErrorHandler(new EH());
            InputSource is = new InputSource(in);
            return db.parse(is);
        }
        catch (ParserConfigurationException x) {
            throw new Error(x);
        }
    }

    static void importProperties(Properties props, Element propertiesElement) {
        int start;
        int numEntries;
        for (int i = start = (numEntries = (entries = propertiesElement.getChildNodes()).getLength()) > 0 && entries.item(0).getNodeName().equals("comment") ? 1 : 0; i < numEntries; ++i) {
            NodeList entries;
            Element entry = (Element)entries.item(i);
            if (!entry.hasAttribute("key")) continue;
            Node n = entry.getFirstChild();
            String val = n == null ? "" : n.getNodeValue();
            props.setProperty(entry.getAttribute("key"), val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void save(Properties props, OutputStream os, String comment, String encoding) throws IOException {
        DocumentBuilder db;
        block7: {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            db = null;
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
        Document doc = db.newDocument();
        Element properties = (Element)doc.appendChild(doc.createElement("properties"));
        if (comment != null) {
            Element comments = (Element)properties.appendChild(doc.createElement("comment"));
            comments.appendChild(doc.createTextNode(comment));
        }
        Properties properties2 = props;
        synchronized (properties2) {
            for (String key : props.stringPropertyNames()) {
                Element entry = (Element)properties.appendChild(doc.createElement("entry"));
                entry.setAttribute("key", key);
                entry.appendChild(doc.createTextNode(props.getProperty(key)));
            }
        }
        XMLUtils.emitDocument(doc, os, encoding);
    }

    static void emitDocument(Document doc, OutputStream os, String encoding) throws IOException {
        Transformer t;
        block4: {
            TransformerFactory tf = TransformerFactory.newInstance();
            t = null;
            try {
                t = tf.newTransformer();
                t.setOutputProperty("doctype-system", PROPS_DTD_URI);
                t.setOutputProperty("indent", "yes");
                t.setOutputProperty("method", "xml");
                t.setOutputProperty("encoding", encoding);
            }
            catch (TransformerConfigurationException tce) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        DOMSource doms = new DOMSource(doc);
        StreamResult sr = new StreamResult(os);
        try {
            t.transform(doms, sr);
        }
        catch (TransformerException te) {
            IOException ioe = new IOException();
            ioe.initCause(te);
            throw ioe;
        }
    }

    private static class EH
    implements ErrorHandler {
        private EH() {
        }

        @Override
        public void error(SAXParseException x) throws SAXException {
            throw x;
        }

        @Override
        public void fatalError(SAXParseException x) throws SAXException {
            throw x;
        }

        @Override
        public void warning(SAXParseException x) throws SAXException {
            throw x;
        }
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        @Override
        public InputSource resolveEntity(String pid, String sid) throws SAXException {
            if (sid.equals(XMLUtils.PROPS_DTD_URI)) {
                InputSource is = new InputSource(new StringReader(XMLUtils.PROPS_DTD));
                is.setSystemId(XMLUtils.PROPS_DTD_URI);
                return is;
            }
            throw new SAXException("Invalid system identifier: " + sid);
        }
    }
}

