/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import sun.security.krb5.Config;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.KdcErrException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.crypto.Crc32CksumType;
import sun.security.krb5.internal.crypto.DesMacCksumType;
import sun.security.krb5.internal.crypto.DesMacKCksumType;
import sun.security.krb5.internal.crypto.HmacMd5ArcFourCksumType;
import sun.security.krb5.internal.crypto.HmacSha1Aes128CksumType;
import sun.security.krb5.internal.crypto.HmacSha1Aes256CksumType;
import sun.security.krb5.internal.crypto.HmacSha1Des3KdCksumType;
import sun.security.krb5.internal.crypto.RsaMd5CksumType;
import sun.security.krb5.internal.crypto.RsaMd5DesCksumType;

public abstract class CksumType {
    private static boolean DEBUG = Krb5.DEBUG;

    public static CksumType getInstance(int cksumTypeConst) throws KdcErrException {
        CksumType cksumType = null;
        String cksumTypeName = null;
        switch (cksumTypeConst) {
            case 1: {
                cksumType = new Crc32CksumType();
                cksumTypeName = "sun.security.krb5.internal.crypto.Crc32CksumType";
                break;
            }
            case 4: {
                cksumType = new DesMacCksumType();
                cksumTypeName = "sun.security.krb5.internal.crypto.DesMacCksumType";
                break;
            }
            case 5: {
                cksumType = new DesMacKCksumType();
                cksumTypeName = "sun.security.krb5.internal.crypto.DesMacKCksumType";
                break;
            }
            case 7: {
                cksumType = new RsaMd5CksumType();
                cksumTypeName = "sun.security.krb5.internal.crypto.RsaMd5CksumType";
                break;
            }
            case 8: {
                cksumType = new RsaMd5DesCksumType();
                cksumTypeName = "sun.security.krb5.internal.crypto.RsaMd5DesCksumType";
                break;
            }
            case 12: {
                cksumType = new HmacSha1Des3KdCksumType();
                cksumTypeName = "sun.security.krb5.internal.crypto.HmacSha1Des3KdCksumType";
                break;
            }
            case 15: {
                cksumType = new HmacSha1Aes128CksumType();
                cksumTypeName = "sun.security.krb5.internal.crypto.HmacSha1Aes128CksumType";
                break;
            }
            case 16: {
                cksumType = new HmacSha1Aes256CksumType();
                cksumTypeName = "sun.security.krb5.internal.crypto.HmacSha1Aes256CksumType";
                break;
            }
            case -138: {
                cksumType = new HmacMd5ArcFourCksumType();
                cksumTypeName = "sun.security.krb5.internal.crypto.HmacMd5ArcFourCksumType";
                break;
            }
            default: {
                throw new KdcErrException(15);
            }
        }
        if (DEBUG) {
            System.out.println(">>> CksumType: " + cksumTypeName);
        }
        return cksumType;
    }

    public static CksumType getInstance() throws KdcErrException {
        int cksumType = 7;
        try {
            Config c = Config.getInstance();
            cksumType = c.getType(c.getDefault("ap_req_checksum_type", "libdefaults"));
            if (cksumType == -1 && (cksumType = c.getType(c.getDefault("checksum_type", "libdefaults"))) == -1) {
                cksumType = 7;
            }
        }
        catch (KrbException krbException) {
            // empty catch block
        }
        return CksumType.getInstance(cksumType);
    }

    public abstract int confounderSize();

    public abstract int cksumType();

    public abstract boolean isSafe();

    public abstract int cksumSize();

    public abstract int keyType();

    public abstract int keySize();

    public abstract byte[] calculateChecksum(byte[] var1, int var2) throws KrbCryptoException;

    public abstract byte[] calculateKeyedChecksum(byte[] var1, int var2, byte[] var3, int var4) throws KrbCryptoException;

    public abstract boolean verifyKeyedChecksum(byte[] var1, int var2, byte[] var3, byte[] var4, int var5) throws KrbCryptoException;

    public static boolean isChecksumEqual(byte[] cksum1, byte[] cksum2) {
        if (cksum1 == cksum2) {
            return true;
        }
        if (cksum1 == null && cksum2 != null || cksum1 != null && cksum2 == null) {
            return false;
        }
        if (cksum1.length != cksum2.length) {
            return false;
        }
        for (int i = 0; i < cksum1.length; ++i) {
            if (cksum1[i] == cksum2[i]) continue;
            return false;
        }
        return true;
    }
}

