/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

public final class IntHashtable {
    private int defaultValue = 0;
    private int primeIndex;
    private static final float HIGH_WATER_FACTOR = 0.4f;
    private int highWaterMark;
    private static final float LOW_WATER_FACTOR = 0.0f;
    private int lowWaterMark;
    private int count;
    private int[] values;
    private int[] keyList;
    private static final int EMPTY = Integer.MIN_VALUE;
    private static final int DELETED = -2147483647;
    private static final int MAX_UNUSED = -2147483647;
    private static final int[] PRIMES = new int[]{17, 37, 67, 131, 257, 521, 1031, 2053, 4099, 8209, 16411, 32771, 65537, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000003, Integer.MAX_VALUE};

    public IntHashtable() {
        this.initialize(3);
    }

    public IntHashtable(int initialSize) {
        this.initialize(IntHashtable.leastGreaterPrimeIndex((int)((float)initialSize / 0.4f)));
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void put(int key, int value) {
        int index;
        if (this.count > this.highWaterMark) {
            this.rehash();
        }
        if (this.keyList[index = this.find(key)] <= -2147483647) {
            this.keyList[index] = key;
            ++this.count;
        }
        this.values[index] = value;
    }

    public int get(int key) {
        return this.values[this.find(key)];
    }

    public void remove(int key) {
        int index = this.find(key);
        if (this.keyList[index] > -2147483647) {
            this.keyList[index] = -2147483647;
            this.values[index] = this.defaultValue;
            --this.count;
            if (this.count < this.lowWaterMark) {
                this.rehash();
            }
        }
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int newValue) {
        this.defaultValue = newValue;
        this.rehash();
    }

    public boolean equals(Object that) {
        if (that.getClass() != this.getClass()) {
            return false;
        }
        IntHashtable other = (IntHashtable)that;
        if (other.size() != this.count || other.defaultValue != this.defaultValue) {
            return false;
        }
        for (int i = 0; i < this.keyList.length; ++i) {
            int key = this.keyList[i];
            if (key <= -2147483647 || other.get(key) == this.values[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int i;
        int result = 465;
        int scrambler = 1362796821;
        for (i = 0; i < this.keyList.length; ++i) {
            result = result * scrambler + 1;
            result += this.keyList[i];
        }
        for (i = 0; i < this.values.length; ++i) {
            result = result * scrambler + 1;
            result += this.values[i];
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        IntHashtable result = (IntHashtable)super.clone();
        this.values = (int[])this.values.clone();
        this.keyList = (int[])this.keyList.clone();
        return result;
    }

    private void initialize(int primeIndex) {
        if (primeIndex < 0) {
            primeIndex = 0;
        } else if (primeIndex >= PRIMES.length) {
            System.out.println("TOO BIG");
            primeIndex = PRIMES.length - 1;
        }
        this.primeIndex = primeIndex;
        int initialSize = PRIMES[primeIndex];
        this.values = new int[initialSize];
        this.keyList = new int[initialSize];
        for (int i = 0; i < initialSize; ++i) {
            this.keyList[i] = Integer.MIN_VALUE;
            this.values[i] = this.defaultValue;
        }
        this.count = 0;
        this.lowWaterMark = (int)((float)initialSize * 0.0f);
        this.highWaterMark = (int)((float)initialSize * 0.4f);
    }

    private void rehash() {
        int[] oldValues = this.values;
        int[] oldkeyList = this.keyList;
        int newPrimeIndex = this.primeIndex;
        if (this.count > this.highWaterMark) {
            ++newPrimeIndex;
        } else if (this.count < this.lowWaterMark) {
            newPrimeIndex -= 2;
        }
        this.initialize(newPrimeIndex);
        for (int i = oldValues.length - 1; i >= 0; --i) {
            int key = oldkeyList[i];
            if (key <= -2147483647) continue;
            this.putInternal(key, oldValues[i]);
        }
    }

    public void putInternal(int key, int value) {
        int index = this.find(key);
        if (this.keyList[index] < -2147483647) {
            this.keyList[index] = key;
            ++this.count;
        }
        this.values[index] = value;
    }

    private int find(int key) {
        if (key <= -2147483647) {
            throw new IllegalArgumentException("key can't be less than 0xFFFFFFFE");
        }
        int firstDeleted = -1;
        int index = (key ^ 0x4000000) % this.keyList.length;
        if (index < 0) {
            index = -index;
        }
        int jump = 0;
        do {
            int tableHash;
            if ((tableHash = this.keyList[index]) == key) {
                return index;
            }
            if (tableHash <= -2147483647) {
                if (tableHash == Integer.MIN_VALUE) {
                    if (firstDeleted >= 0) {
                        index = firstDeleted;
                    }
                    return index;
                }
                if (firstDeleted < 0) {
                    firstDeleted = index;
                }
            }
            if (jump != 0) continue;
            jump = key % (this.keyList.length - 1);
            if (jump < 0) {
                jump = -jump;
            }
            ++jump;
        } while ((index = (index + jump) % this.keyList.length) != firstDeleted);
        return index;
    }

    private static int leastGreaterPrimeIndex(int source) {
        int i;
        for (i = 0; i < PRIMES.length && source >= PRIMES[i]; ++i) {
        }
        return i == 0 ? 0 : i - 1;
    }
}

