/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertStore;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import sun.security.util.Cache;

public abstract class CertStoreHelper {
    private static final int NUM_TYPES = 2;
    private static final Map<String, String> classMap = new HashMap<String, String>(2);
    private static Cache cache;

    public static CertStoreHelper getInstance(final String type) throws NoSuchAlgorithmException {
        CertStoreHelper helper = (CertStoreHelper)cache.get(type);
        if (helper != null) {
            return helper;
        }
        final String cl = classMap.get(type);
        if (cl == null) {
            throw new NoSuchAlgorithmException(type + " not available");
        }
        try {
            helper = AccessController.doPrivileged(new PrivilegedExceptionAction<CertStoreHelper>(){

                @Override
                public CertStoreHelper run() throws ClassNotFoundException {
                    try {
                        Class<?> c = Class.forName(cl, true, null);
                        CertStoreHelper csh = (CertStoreHelper)c.newInstance();
                        cache.put(type, csh);
                        return csh;
                    }
                    catch (InstantiationException e) {
                        throw new AssertionError((Object)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            });
            return helper;
        }
        catch (PrivilegedActionException e) {
            throw new NoSuchAlgorithmException(type + " not available", e.getException());
        }
    }

    public abstract CertStore getCertStore(URI var1) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract X509CertSelector wrap(X509CertSelector var1, X500Principal var2, String var3) throws IOException;

    public abstract X509CRLSelector wrap(X509CRLSelector var1, Collection<X500Principal> var2, String var3) throws IOException;

    static {
        classMap.put("LDAP", "sun.security.provider.certpath.ldap.LDAPCertStoreHelper");
        classMap.put("SSLServer", "sun.security.provider.certpath.ssl.SSLServerCertStoreHelper");
        cache = Cache.newSoftMemoryCache(2);
    }
}

