/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Vector;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialDatalink;
import javax.sql.rowset.serial.SerialRef;
import javax.sql.rowset.serial.SerialStruct;

public class SQLOutputImpl
implements SQLOutput {
    private Vector attribs;
    private Map map;

    public SQLOutputImpl(Vector<?> attributes, Map<String, ?> map) throws SQLException {
        if (attributes == null || map == null) {
            throw new SQLException("Cannot instantiate a SQLOutputImpl instance with null parameters");
        }
        this.attribs = attributes;
        this.map = map;
    }

    @Override
    public void writeString(String x) throws SQLException {
        this.attribs.add(x);
    }

    @Override
    public void writeBoolean(boolean x) throws SQLException {
        this.attribs.add(x);
    }

    @Override
    public void writeByte(byte x) throws SQLException {
        this.attribs.add(x);
    }

    @Override
    public void writeShort(short x) throws SQLException {
        this.attribs.add(x);
    }

    @Override
    public void writeInt(int x) throws SQLException {
        this.attribs.add(x);
    }

    @Override
    public void writeLong(long x) throws SQLException {
        this.attribs.add(x);
    }

    @Override
    public void writeFloat(float x) throws SQLException {
        this.attribs.add(new Float(x));
    }

    @Override
    public void writeDouble(double x) throws SQLException {
        this.attribs.add(new Double(x));
    }

    @Override
    public void writeBigDecimal(BigDecimal x) throws SQLException {
        this.attribs.add(x);
    }

    @Override
    public void writeBytes(byte[] x) throws SQLException {
        this.attribs.add(x);
    }

    @Override
    public void writeDate(Date x) throws SQLException {
        this.attribs.add(x);
    }

    @Override
    public void writeTime(Time x) throws SQLException {
        this.attribs.add(x);
    }

    @Override
    public void writeTimestamp(Timestamp x) throws SQLException {
        this.attribs.add(x);
    }

    @Override
    public void writeCharacterStream(Reader x) throws SQLException {
        BufferedReader bufReader = new BufferedReader(x);
        try {
            int i;
            while ((i = bufReader.read()) != -1) {
                char ch = (char)i;
                StringBuffer strBuf = new StringBuffer();
                strBuf.append(ch);
                String str = new String(strBuf);
                String strLine = bufReader.readLine();
                this.writeString(str.concat(strLine));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void writeAsciiStream(InputStream x) throws SQLException {
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(x));
        try {
            int i;
            while ((i = bufReader.read()) != -1) {
                char ch = (char)i;
                StringBuffer strBuf = new StringBuffer();
                strBuf.append(ch);
                String str = new String(strBuf);
                String strLine = bufReader.readLine();
                this.writeString(str.concat(strLine));
            }
        }
        catch (IOException ioe) {
            throw new SQLException(ioe.getMessage());
        }
    }

    @Override
    public void writeBinaryStream(InputStream x) throws SQLException {
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(x));
        try {
            int i;
            while ((i = bufReader.read()) != -1) {
                char ch = (char)i;
                StringBuffer strBuf = new StringBuffer();
                strBuf.append(ch);
                String str = new String(strBuf);
                String strLine = bufReader.readLine();
                this.writeString(str.concat(strLine));
            }
        }
        catch (IOException ioe) {
            throw new SQLException(ioe.getMessage());
        }
    }

    @Override
    public void writeObject(SQLData x) throws SQLException {
        if (x == null) {
            this.attribs.add(x);
            return;
        }
        this.attribs.add(new SerialStruct(x, this.map));
    }

    @Override
    public void writeRef(Ref x) throws SQLException {
        if (x == null) {
            this.attribs.add(x);
            return;
        }
        this.attribs.add(new SerialRef(x));
    }

    @Override
    public void writeBlob(Blob x) throws SQLException {
        if (x == null) {
            this.attribs.add(x);
            return;
        }
        this.attribs.add(new SerialBlob(x));
    }

    @Override
    public void writeClob(Clob x) throws SQLException {
        if (x == null) {
            this.attribs.add(x);
            return;
        }
        this.attribs.add(new SerialClob(x));
    }

    @Override
    public void writeStruct(Struct x) throws SQLException {
        SerialStruct s = new SerialStruct(x, this.map);
        this.attribs.add(s);
    }

    @Override
    public void writeArray(Array x) throws SQLException {
        if (x == null) {
            this.attribs.add(x);
            return;
        }
        this.attribs.add(new SerialArray(x, this.map));
    }

    @Override
    public void writeURL(URL url) throws SQLException {
        if (url == null) {
            this.attribs.add(url);
            return;
        }
        this.attribs.add(new SerialDatalink(url));
    }

    @Override
    public void writeNString(String x) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void writeNClob(NClob x) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void writeRowId(RowId x) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void writeSQLXML(SQLXML x) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported");
    }
}

