/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.image.ColorModel;
import sun.java2d.loops.PixelWriter;

abstract class XorPixelWriter
extends PixelWriter {
    protected ColorModel dstCM;

    XorPixelWriter() {
    }

    @Override
    public void writePixel(int x, int y) {
        Object dstPixel = this.dstRast.getDataElements(x, y, null);
        this.xorPixel(dstPixel);
        this.dstRast.setDataElements(x, y, dstPixel);
    }

    protected abstract void xorPixel(Object var1);

    public static class DoubleData
    extends XorPixelWriter {
        long[] xorData;

        DoubleData(Object srcPixel, Object xorPixel) {
            double[] srcData = (double[])srcPixel;
            double[] xorData = (double[])xorPixel;
            this.xorData = new long[srcData.length];
            for (int i = 0; i < srcData.length; ++i) {
                this.xorData[i] = Double.doubleToLongBits(srcData[i]) ^ Double.doubleToLongBits(xorData[i]);
            }
        }

        @Override
        protected void xorPixel(Object pixData) {
            double[] dstData = (double[])pixData;
            for (int i = 0; i < dstData.length; ++i) {
                long v = Double.doubleToLongBits(dstData[i]) ^ this.xorData[i];
                dstData[i] = Double.longBitsToDouble(v);
            }
        }
    }

    public static class FloatData
    extends XorPixelWriter {
        int[] xorData;

        FloatData(Object srcPixel, Object xorPixel) {
            float[] srcData = (float[])srcPixel;
            float[] xorData = (float[])xorPixel;
            this.xorData = new int[srcData.length];
            for (int i = 0; i < srcData.length; ++i) {
                this.xorData[i] = Float.floatToIntBits(srcData[i]) ^ Float.floatToIntBits(xorData[i]);
            }
        }

        @Override
        protected void xorPixel(Object pixData) {
            float[] dstData = (float[])pixData;
            for (int i = 0; i < dstData.length; ++i) {
                int v = Float.floatToIntBits(dstData[i]) ^ this.xorData[i];
                dstData[i] = Float.intBitsToFloat(v);
            }
        }
    }

    public static class IntData
    extends XorPixelWriter {
        int[] xorData;

        IntData(Object srcPixel, Object xorPixel) {
            this.xorData = (int[])srcPixel;
            this.xorPixel(xorPixel);
            this.xorData = (int[])xorPixel;
        }

        @Override
        protected void xorPixel(Object pixData) {
            int[] dstData = (int[])pixData;
            for (int i = 0; i < dstData.length; ++i) {
                int n = i;
                dstData[n] = dstData[n] ^ this.xorData[i];
            }
        }
    }

    public static class ShortData
    extends XorPixelWriter {
        short[] xorData;

        ShortData(Object srcPixel, Object xorPixel) {
            this.xorData = (short[])srcPixel;
            this.xorPixel(xorPixel);
            this.xorData = (short[])xorPixel;
        }

        @Override
        protected void xorPixel(Object pixData) {
            short[] dstData = (short[])pixData;
            for (int i = 0; i < dstData.length; ++i) {
                int n = i;
                dstData[n] = (short)(dstData[n] ^ this.xorData[i]);
            }
        }
    }

    public static class ByteData
    extends XorPixelWriter {
        byte[] xorData;

        ByteData(Object srcPixel, Object xorPixel) {
            this.xorData = (byte[])srcPixel;
            this.xorPixel(xorPixel);
            this.xorData = (byte[])xorPixel;
        }

        @Override
        protected void xorPixel(Object pixData) {
            byte[] dstData = (byte[])pixData;
            for (int i = 0; i < dstData.length; ++i) {
                int n = i;
                dstData[n] = (byte)(dstData[n] ^ this.xorData[i]);
            }
        }
    }
}

