/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.naming.pcosnaming;

import com.sun.corba.se.impl.naming.pcosnaming.CounterDB;
import com.sun.corba.se.impl.naming.pcosnaming.NameService;
import com.sun.corba.se.impl.naming.pcosnaming.NamingContextImpl;
import com.sun.corba.se.spi.orb.ORB;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import org.omg.CORBA.LocalObject;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;

public class ServantManagerImpl
extends LocalObject
implements ServantLocator {
    private static final long serialVersionUID = 4028710359865748280L;
    private ORB orb;
    private NameService theNameService;
    private File logDir;
    private Hashtable contexts;
    private CounterDB counterDb;
    private int counter;
    private static final String objKeyPrefix = "NC";

    ServantManagerImpl(ORB orb, File logDir, NameService aNameService) {
        this.logDir = logDir;
        this.orb = orb;
        this.counterDb = new CounterDB(logDir);
        this.contexts = new Hashtable();
        this.theNameService = aNameService;
    }

    @Override
    public Servant preinvoke(byte[] oid, POA adapter, String operation, CookieHolder cookie) throws ForwardRequest {
        String objKey = new String(oid);
        Servant servant = (Servant)this.contexts.get(objKey);
        if (servant == null) {
            servant = this.readInContext(objKey);
        }
        return servant;
    }

    @Override
    public void postinvoke(byte[] oid, POA adapter, String operation, Object cookie, Servant servant) {
    }

    public NamingContextImpl readInContext(String objKey) {
        NamingContextImpl context = (NamingContextImpl)this.contexts.get(objKey);
        if (context != null) {
            return context;
        }
        File contextFile = new File(this.logDir, objKey);
        if (contextFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(contextFile);
                ObjectInputStream ois = new ObjectInputStream(fis);
                context = (NamingContextImpl)ois.readObject();
                context.setORB(this.orb);
                context.setServantManagerImpl(this);
                context.setRootNameService(this.theNameService);
                ois.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (context != null) {
            this.contexts.put(objKey, context);
        }
        return context;
    }

    public NamingContextImpl addContext(String objKey, NamingContextImpl context) {
        File contextFile = new File(this.logDir, objKey);
        if (contextFile.exists()) {
            context = this.readInContext(objKey);
        } else {
            try {
                FileOutputStream fos = new FileOutputStream(contextFile);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(context);
                oos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.contexts.remove(objKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.contexts.put(objKey, context);
        return context;
    }

    public void updateContext(String objKey, NamingContextImpl context) {
        File contextFile = new File(this.logDir, objKey);
        if (contextFile.exists()) {
            contextFile.delete();
            contextFile = new File(this.logDir, objKey);
        }
        try {
            FileOutputStream fos = new FileOutputStream(contextFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(context);
            oos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getRootObjectKey() {
        return "NC0";
    }

    public String getNewObjectKey() {
        return objKeyPrefix + this.counterDb.getNextCounter();
    }
}

