/*
 * Decompiled with CFR 0.152.
 */
package javax.management.timer;

import com.sun.jmx.defaults.JmxProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.timer.TimerAlarmClock;
import javax.management.timer.TimerAlarmClockNotification;
import javax.management.timer.TimerMBean;
import javax.management.timer.TimerNotification;

public class Timer
extends NotificationBroadcasterSupport
implements TimerMBean,
MBeanRegistration {
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    private Map<Integer, Object[]> timerTable = new Hashtable<Integer, Object[]>();
    private boolean sendPastNotifications = false;
    private transient boolean isActive = false;
    private transient long sequenceNumber = 0L;
    private static final int TIMER_NOTIF_INDEX = 0;
    private static final int TIMER_DATE_INDEX = 1;
    private static final int TIMER_PERIOD_INDEX = 2;
    private static final int TIMER_NB_OCCUR_INDEX = 3;
    private static final int ALARM_CLOCK_INDEX = 4;
    private static final int FIXED_RATE_INDEX = 5;
    private int counterID = 0;
    private java.util.Timer timer;

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "preDeregister", "stop the timer");
        this.stop();
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public synchronized MBeanNotificationInfo[] getNotificationInfo() {
        TreeSet<String> notifTypes = new TreeSet<String>();
        for (Object[] entry : this.timerTable.values()) {
            TimerNotification notif = (TimerNotification)entry[0];
            notifTypes.add(notif.getType());
        }
        String[] notifTypesArray = notifTypes.toArray(new String[0]);
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypesArray, TimerNotification.class.getName(), "Notification sent by Timer MBean")};
    }

    @Override
    public synchronized void start() {
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "start", "starting the timer");
        if (!this.isActive) {
            this.timer = new java.util.Timer();
            Date currentDate = new Date();
            this.sendPastNotifications(currentDate, this.sendPastNotifications);
            for (Object[] obj : this.timerTable.values()) {
                TimerAlarmClock alarmClock;
                Date date = (Date)obj[1];
                boolean fixedRate = (Boolean)obj[5];
                if (fixedRate) {
                    alarmClock = new TimerAlarmClock(this, date);
                    obj[4] = alarmClock;
                    this.timer.schedule((TimerTask)alarmClock, alarmClock.next);
                    continue;
                }
                alarmClock = new TimerAlarmClock(this, date.getTime() - currentDate.getTime());
                obj[4] = alarmClock;
                this.timer.schedule((TimerTask)alarmClock, alarmClock.timeout);
            }
            this.isActive = true;
            JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "start", "timer started");
        } else {
            JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "start", "the timer is already activated");
        }
    }

    @Override
    public synchronized void stop() {
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "stop", "stopping the timer");
        if (this.isActive) {
            for (Object[] obj : this.timerTable.values()) {
                TimerAlarmClock alarmClock = (TimerAlarmClock)obj[4];
                if (alarmClock == null) continue;
                alarmClock.cancel();
            }
            this.timer.cancel();
            this.isActive = false;
            JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "stop", "timer stopped");
        } else {
            JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "stop", "the timer is already deactivated");
        }
    }

    @Override
    public synchronized Integer addNotification(String type, String message, Object userData, Date date, long period, long nbOccurences, boolean fixedRate) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("Timer notification date cannot be null.");
        }
        if (period < 0L || nbOccurences < 0L) {
            throw new IllegalArgumentException("Negative values for the periodicity");
        }
        Date currentDate = new Date();
        if (currentDate.after(date)) {
            date.setTime(currentDate.getTime());
            if (JmxProperties.TIMER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "addNotification", "update timer notification to add with:\n\tNotification date = " + date);
            }
        }
        Integer notifID = ++this.counterID;
        TimerNotification notif = new TimerNotification(type, this, 0L, 0L, message, notifID);
        notif.setUserData(userData);
        Object[] obj = new Object[6];
        TimerAlarmClock alarmClock = fixedRate ? new TimerAlarmClock(this, date) : new TimerAlarmClock(this, date.getTime() - currentDate.getTime());
        Date d = new Date(date.getTime());
        obj[0] = notif;
        obj[1] = d;
        obj[2] = period;
        obj[3] = nbOccurences;
        obj[4] = alarmClock;
        obj[5] = fixedRate;
        if (JmxProperties.TIMER_LOGGER.isLoggable(Level.FINER)) {
            StringBuilder strb = new StringBuilder().append("adding timer notification:\n\t").append("Notification source = ").append(notif.getSource()).append("\n\tNotification type = ").append(notif.getType()).append("\n\tNotification ID = ").append(notifID).append("\n\tNotification date = ").append(d).append("\n\tNotification period = ").append(period).append("\n\tNotification nb of occurrences = ").append(nbOccurences).append("\n\tNotification executes at fixed rate = ").append(fixedRate);
            JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "addNotification", strb.toString());
        }
        this.timerTable.put(notifID, obj);
        if (this.isActive) {
            if (fixedRate) {
                this.timer.schedule((TimerTask)alarmClock, alarmClock.next);
            } else {
                this.timer.schedule((TimerTask)alarmClock, alarmClock.timeout);
            }
        }
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "addNotification", "timer notification added");
        return notifID;
    }

    @Override
    public synchronized Integer addNotification(String type, String message, Object userData, Date date, long period, long nbOccurences) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, nbOccurences, false);
    }

    @Override
    public synchronized Integer addNotification(String type, String message, Object userData, Date date, long period) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, 0L);
    }

    @Override
    public synchronized Integer addNotification(String type, String message, Object userData, Date date) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, 0L, 0L);
    }

    @Override
    public synchronized void removeNotification(Integer id) throws InstanceNotFoundException {
        if (!this.timerTable.containsKey(id)) {
            throw new InstanceNotFoundException("Timer notification to remove not in the list of notifications");
        }
        Object[] obj = this.timerTable.get(id);
        TimerAlarmClock alarmClock = (TimerAlarmClock)obj[4];
        if (alarmClock != null) {
            alarmClock.cancel();
        }
        if (JmxProperties.TIMER_LOGGER.isLoggable(Level.FINER)) {
            StringBuilder strb = new StringBuilder().append("removing timer notification:").append("\n\tNotification source = ").append(((TimerNotification)obj[0]).getSource()).append("\n\tNotification type = ").append(((TimerNotification)obj[0]).getType()).append("\n\tNotification ID = ").append(((TimerNotification)obj[0]).getNotificationID()).append("\n\tNotification date = ").append(obj[1]).append("\n\tNotification period = ").append(obj[2]).append("\n\tNotification nb of occurrences = ").append(obj[3]).append("\n\tNotification executes at fixed rate = ").append(obj[5]);
            JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "removeNotification", strb.toString());
        }
        this.timerTable.remove(id);
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "removeNotification", "timer notification removed");
    }

    @Override
    public synchronized void removeNotifications(String type) throws InstanceNotFoundException {
        Vector<Integer> v = this.getNotificationIDs(type);
        if (v.isEmpty()) {
            throw new InstanceNotFoundException("Timer notifications to remove not in the list of notifications");
        }
        for (Integer i : v) {
            this.removeNotification(i);
        }
    }

    @Override
    public synchronized void removeAllNotifications() {
        for (Object[] obj : this.timerTable.values()) {
            TimerAlarmClock alarmClock = (TimerAlarmClock)obj[4];
            alarmClock.cancel();
        }
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "removeAllNotifications", "removing all timer notifications");
        this.timerTable.clear();
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "removeAllNotifications", "all timer notifications removed");
        this.counterID = 0;
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "removeAllNotifications", "timer notification counter ID reset");
    }

    @Override
    public int getNbNotifications() {
        return this.timerTable.size();
    }

    @Override
    public synchronized Vector<Integer> getAllNotificationIDs() {
        return new Vector<Integer>(this.timerTable.keySet());
    }

    @Override
    public synchronized Vector<Integer> getNotificationIDs(String type) {
        Vector<Integer> v = new Vector<Integer>();
        for (Map.Entry<Integer, Object[]> entry : this.timerTable.entrySet()) {
            Object[] obj = entry.getValue();
            String s = ((TimerNotification)obj[0]).getType();
            if (!(type == null ? s == null : type.equals(s))) continue;
            v.addElement(entry.getKey());
        }
        return v;
    }

    @Override
    public String getNotificationType(Integer id) {
        Object[] obj = this.timerTable.get(id);
        if (obj != null) {
            return ((TimerNotification)obj[0]).getType();
        }
        return null;
    }

    @Override
    public String getNotificationMessage(Integer id) {
        Object[] obj = this.timerTable.get(id);
        if (obj != null) {
            return ((TimerNotification)obj[0]).getMessage();
        }
        return null;
    }

    @Override
    public Object getNotificationUserData(Integer id) {
        Object[] obj = this.timerTable.get(id);
        if (obj != null) {
            return ((TimerNotification)obj[0]).getUserData();
        }
        return null;
    }

    @Override
    public Date getDate(Integer id) {
        Object[] obj = this.timerTable.get(id);
        if (obj != null) {
            Date date = (Date)obj[1];
            return new Date(date.getTime());
        }
        return null;
    }

    @Override
    public Long getPeriod(Integer id) {
        Object[] obj = this.timerTable.get(id);
        if (obj != null) {
            return (Long)obj[2];
        }
        return null;
    }

    @Override
    public Long getNbOccurences(Integer id) {
        Object[] obj = this.timerTable.get(id);
        if (obj != null) {
            return (Long)obj[3];
        }
        return null;
    }

    @Override
    public Boolean getFixedRate(Integer id) {
        Object[] obj = this.timerTable.get(id);
        if (obj != null) {
            Boolean fixedRate = (Boolean)obj[5];
            return (boolean)fixedRate;
        }
        return null;
    }

    @Override
    public boolean getSendPastNotifications() {
        return this.sendPastNotifications;
    }

    @Override
    public void setSendPastNotifications(boolean value) {
        this.sendPastNotifications = value;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean isEmpty() {
        return this.timerTable.isEmpty();
    }

    private synchronized void sendPastNotifications(Date currentDate, boolean currentFlag) {
        ArrayList<Object[]> values = new ArrayList<Object[]>(this.timerTable.values());
        for (Object[] obj : values) {
            TimerNotification notif = (TimerNotification)obj[0];
            Integer notifID = notif.getNotificationID();
            Date date = (Date)obj[1];
            while (currentDate.after(date) && this.timerTable.containsKey(notifID)) {
                if (currentFlag) {
                    if (JmxProperties.TIMER_LOGGER.isLoggable(Level.FINER)) {
                        StringBuilder strb = new StringBuilder().append("sending past timer notification:").append("\n\tNotification source = ").append(notif.getSource()).append("\n\tNotification type = ").append(notif.getType()).append("\n\tNotification ID = ").append(notif.getNotificationID()).append("\n\tNotification date = ").append(date).append("\n\tNotification period = ").append(obj[2]).append("\n\tNotification nb of occurrences = ").append(obj[3]).append("\n\tNotification executes at fixed rate = ").append(obj[5]);
                        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "sendPastNotifications", strb.toString());
                    }
                    this.sendNotification(date, notif);
                    JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "sendPastNotifications", "past timer notification sent");
                }
                this.updateTimerTable(notif.getNotificationID());
            }
        }
    }

    private synchronized void updateTimerTable(Integer notifID) {
        Object[] obj = this.timerTable.get(notifID);
        Date date = (Date)obj[1];
        Long period = (Long)obj[2];
        Long nbOccurences = (Long)obj[3];
        Boolean fixedRate = (Boolean)obj[5];
        TimerAlarmClock alarmClock = (TimerAlarmClock)obj[4];
        if (period != 0L) {
            if (nbOccurences == 0L || nbOccurences > 1L) {
                date.setTime(date.getTime() + period);
                obj[3] = Math.max(0L, nbOccurences - 1L);
                nbOccurences = (Long)obj[3];
                if (this.isActive) {
                    if (fixedRate.booleanValue()) {
                        alarmClock = new TimerAlarmClock(this, date);
                        obj[4] = alarmClock;
                        this.timer.schedule((TimerTask)alarmClock, alarmClock.next);
                    } else {
                        alarmClock = new TimerAlarmClock(this, period);
                        obj[4] = alarmClock;
                        this.timer.schedule((TimerTask)alarmClock, alarmClock.timeout);
                    }
                }
                if (JmxProperties.TIMER_LOGGER.isLoggable(Level.FINER)) {
                    TimerNotification notif = (TimerNotification)obj[0];
                    StringBuilder strb = new StringBuilder().append("update timer notification with:").append("\n\tNotification source = ").append(notif.getSource()).append("\n\tNotification type = ").append(notif.getType()).append("\n\tNotification ID = ").append(notifID).append("\n\tNotification date = ").append(date).append("\n\tNotification period = ").append(period).append("\n\tNotification nb of occurrences = ").append(nbOccurences).append("\n\tNotification executes at fixed rate = ").append(fixedRate);
                    JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "updateTimerTable", strb.toString());
                }
            } else {
                if (alarmClock != null) {
                    alarmClock.cancel();
                }
                this.timerTable.remove(notifID);
            }
        } else {
            if (alarmClock != null) {
                alarmClock.cancel();
            }
            this.timerTable.remove(notifID);
        }
    }

    void notifyAlarmClock(TimerAlarmClockNotification notification) {
        TimerNotification timerNotification = null;
        Date timerDate = null;
        TimerAlarmClock alarmClock = (TimerAlarmClock)notification.getSource();
        for (Object[] obj : this.timerTable.values()) {
            if (obj[4] != alarmClock) continue;
            timerNotification = (TimerNotification)obj[0];
            timerDate = (Date)obj[1];
            break;
        }
        this.sendNotification(timerDate, timerNotification);
        this.updateTimerTable(timerNotification.getNotificationID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNotification(Date timeStamp, TimerNotification notification) {
        long curSeqNumber;
        if (JmxProperties.TIMER_LOGGER.isLoggable(Level.FINER)) {
            StringBuilder strb = new StringBuilder().append("sending timer notification:").append("\n\tNotification source = ").append(notification.getSource()).append("\n\tNotification type = ").append(notification.getType()).append("\n\tNotification ID = ").append(notification.getNotificationID()).append("\n\tNotification date = ").append(timeStamp);
            JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "sendNotification", strb.toString());
        }
        Object object = this;
        synchronized (object) {
            ++this.sequenceNumber;
            curSeqNumber = this.sequenceNumber;
        }
        object = notification;
        synchronized (object) {
            notification.setTimeStamp(timeStamp.getTime());
            notification.setSequenceNumber(curSeqNumber);
            this.sendNotification((TimerNotification)notification.cloneTimerNotification());
        }
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "sendNotification", "timer notification sent");
    }
}

