/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public abstract class CharToByteSingleByte
extends CharToByteConverter {
    protected char[] index1;
    protected char[] index2;
    protected int mask1;
    protected int mask2;
    protected int shift;
    private char highHalfZoneCode;

    public char[] getIndex1() {
        return this.index1;
    }

    public char[] getIndex2() {
        return this.index2;
    }

    @Override
    public int flush(byte[] output, int outStart, int outEnd) throws MalformedInputException {
        if (this.highHalfZoneCode != '\u0000') {
            this.highHalfZoneCode = '\u0000';
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int convert(char[] input, int inOff, int inEnd, byte[] output, int outOff, int outEnd) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException {
        byte[] tmpArray = new byte[1];
        this.charOff = inOff;
        this.byteOff = outOff;
        if (this.highHalfZoneCode != '\u0000') {
            char inputChar = this.highHalfZoneCode;
            this.highHalfZoneCode = '\u0000';
            if (input[inOff] >= '\udc00' && input[inOff] <= '\udfff') {
                this.badInputLength = 1;
                throw new UnknownCharacterException();
            }
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        while (this.charOff < inEnd) {
            int inputSize;
            int outputSize;
            byte[] outputByte;
            block13: {
                outputByte = tmpArray;
                char inputChar = input[this.charOff];
                outputSize = 1;
                inputSize = 1;
                if (inputChar >= '\ud800' && inputChar <= '\udbff') {
                    if (this.charOff + 1 >= inEnd) {
                        this.highHalfZoneCode = inputChar;
                        return this.byteOff - outOff;
                    }
                    inputChar = input[this.charOff + 1];
                    if (inputChar >= '\udc00' && inputChar <= '\udfff') {
                        if (!this.subMode) {
                            this.badInputLength = 2;
                            throw new UnknownCharacterException();
                        }
                        outputByte = this.subBytes;
                        outputSize = this.subBytes.length;
                        inputSize = 2;
                        break block13;
                    } else {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                }
                if (inputChar >= '\udc00' && inputChar <= '\udfff') {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                outputByte[0] = this.getNative(inputChar);
                if (outputByte[0] == 0 && input[this.charOff] != '\u0000') {
                    if (!this.subMode) {
                        this.badInputLength = 1;
                        throw new UnknownCharacterException();
                    }
                    outputByte = this.subBytes;
                    outputSize = this.subBytes.length;
                }
            }
            if (this.byteOff + outputSize > outEnd) {
                throw new ConversionBufferFullException();
            }
            for (int i = 0; i < outputSize; ++i) {
                output[this.byteOff++] = outputByte[i];
            }
            this.charOff += inputSize;
        }
        return this.byteOff - outOff;
    }

    @Override
    public int getMaxBytesPerChar() {
        return 1;
    }

    int encodeChar(char ch) {
        char index = this.index1[ch >> 8];
        if (index == '\ufffd') {
            return 65533;
        }
        return this.index2[index + (ch & 0xFF)];
    }

    public byte getNative(char inputChar) {
        int b = this.encodeChar(inputChar);
        if (b == 65533) {
            return 0;
        }
        return (byte)b;
    }

    @Override
    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.highHalfZoneCode = '\u0000';
    }

    @Override
    public boolean canConvert(char ch) {
        return this.encodeChar(ch) != 65533;
    }
}

