/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateNetworkInterfaceRequestMarshaller
implements Marshaller<Request<CreateNetworkInterfaceRequest>, CreateNetworkInterfaceRequest> {
    public Request<CreateNetworkInterfaceRequest> marshall(CreateNetworkInterfaceRequest createNetworkInterfaceRequest) {
        if (createNetworkInterfaceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createNetworkInterfaceRequest, "AmazonEC2");
        request.addParameter("Action", "CreateNetworkInterface");
        request.addParameter("Version", "2014-10-01");
        if (createNetworkInterfaceRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)createNetworkInterfaceRequest.getSubnetId()));
        }
        if (createNetworkInterfaceRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createNetworkInterfaceRequest.getDescription()));
        }
        if (createNetworkInterfaceRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString((String)createNetworkInterfaceRequest.getPrivateIpAddress()));
        }
        List<String> groupsList = createNetworkInterfaceRequest.getGroups();
        int groupsListIndex = 1;
        for (String groupsListValue : groupsList) {
            if (groupsListValue != null) {
                request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)groupsListValue));
            }
            ++groupsListIndex;
        }
        List<PrivateIpAddressSpecification> privateIpAddressesList = createNetworkInterfaceRequest.getPrivateIpAddresses();
        int privateIpAddressesListIndex = 1;
        for (PrivateIpAddressSpecification privateIpAddressesListValue : privateIpAddressesList) {
            PrivateIpAddressSpecification privateIpAddressSpecificationMember = privateIpAddressesListValue;
            if (privateIpAddressSpecificationMember != null) {
                if (privateIpAddressSpecificationMember.getPrivateIpAddress() != null) {
                    request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)privateIpAddressSpecificationMember.getPrivateIpAddress()));
                }
                if (privateIpAddressSpecificationMember.isPrimary() != null) {
                    request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)privateIpAddressSpecificationMember.isPrimary()));
                }
            }
            ++privateIpAddressesListIndex;
        }
        if (createNetworkInterfaceRequest.getSecondaryPrivateIpAddressCount() != null) {
            request.addParameter("SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)createNetworkInterfaceRequest.getSecondaryPrivateIpAddressCount()));
        }
        if (createNetworkInterfaceRequest.isDryRun() != null) {
            request.addParameter("DryRun", StringUtils.fromBoolean((Boolean)createNetworkInterfaceRequest.isDryRun()));
        }
        return request;
    }
}

