/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftAudioBuffer;

public final class SoftFilter {
    public static final int FILTERTYPE_LP6 = 0;
    public static final int FILTERTYPE_LP12 = 1;
    public static final int FILTERTYPE_HP12 = 17;
    public static final int FILTERTYPE_BP12 = 33;
    public static final int FILTERTYPE_NP12 = 49;
    public static final int FILTERTYPE_LP24 = 3;
    public static final int FILTERTYPE_HP24 = 19;
    private int filtertype = 0;
    private final float samplerate;
    private float x1;
    private float x2;
    private float y1;
    private float y2;
    private float xx1;
    private float xx2;
    private float yy1;
    private float yy2;
    private float a0;
    private float a1;
    private float a2;
    private float b1;
    private float b2;
    private float q;
    private float gain = 1.0f;
    private float wet = 0.0f;
    private float last_wet = 0.0f;
    private float last_a0;
    private float last_a1;
    private float last_a2;
    private float last_b1;
    private float last_b2;
    private float last_q;
    private float last_gain;
    private boolean last_set = false;
    private double cutoff = 44100.0;
    private double resonancedB = 0.0;
    private boolean dirty = true;

    public SoftFilter(float samplerate) {
        this.samplerate = samplerate;
        this.dirty = true;
    }

    public void setFrequency(double cent) {
        if (this.cutoff == cent) {
            return;
        }
        this.cutoff = cent;
        this.dirty = true;
    }

    public void setResonance(double db) {
        if (this.resonancedB == db) {
            return;
        }
        this.resonancedB = db;
        this.dirty = true;
    }

    public void reset() {
        this.dirty = true;
        this.last_set = false;
        this.x1 = 0.0f;
        this.x2 = 0.0f;
        this.y1 = 0.0f;
        this.y2 = 0.0f;
        this.xx1 = 0.0f;
        this.xx2 = 0.0f;
        this.yy1 = 0.0f;
        this.yy2 = 0.0f;
        this.wet = 0.0f;
        this.gain = 1.0f;
        this.a0 = 0.0f;
        this.a1 = 0.0f;
        this.a2 = 0.0f;
        this.b1 = 0.0f;
        this.b2 = 0.0f;
    }

    public void setFilterType(int filtertype) {
        this.filtertype = filtertype;
    }

    public void processAudio(SoftAudioBuffer sbuffer) {
        if (this.filtertype == 0) {
            this.filter1(sbuffer);
        }
        if (this.filtertype == 1) {
            this.filter2(sbuffer);
        }
        if (this.filtertype == 17) {
            this.filter2(sbuffer);
        }
        if (this.filtertype == 33) {
            this.filter2(sbuffer);
        }
        if (this.filtertype == 49) {
            this.filter2(sbuffer);
        }
        if (this.filtertype == 3) {
            this.filter4(sbuffer);
        }
        if (this.filtertype == 19) {
            this.filter4(sbuffer);
        }
    }

    public void filter4(SoftAudioBuffer sbuffer) {
        float[] buffer = sbuffer.array();
        if (this.dirty) {
            this.filter2calc();
            this.dirty = false;
        }
        if (!this.last_set) {
            this.last_a0 = this.a0;
            this.last_a1 = this.a1;
            this.last_a2 = this.a2;
            this.last_b1 = this.b1;
            this.last_b2 = this.b2;
            this.last_gain = this.gain;
            this.last_wet = this.wet;
            this.last_set = true;
        }
        if (this.wet > 0.0f || this.last_wet > 0.0f) {
            int len = buffer.length;
            float a0 = this.last_a0;
            float a1 = this.last_a1;
            float a2 = this.last_a2;
            float b1 = this.last_b1;
            float b2 = this.last_b2;
            float gain = this.last_gain;
            float wet = this.last_wet;
            float a0_delta = (this.a0 - this.last_a0) / (float)len;
            float a1_delta = (this.a1 - this.last_a1) / (float)len;
            float a2_delta = (this.a2 - this.last_a2) / (float)len;
            float b1_delta = (this.b1 - this.last_b1) / (float)len;
            float b2_delta = (this.b2 - this.last_b2) / (float)len;
            float gain_delta = (this.gain - this.last_gain) / (float)len;
            float wet_delta = (this.wet - this.last_wet) / (float)len;
            float x1 = this.x1;
            float x2 = this.x2;
            float y1 = this.y1;
            float y2 = this.y2;
            float xx1 = this.xx1;
            float xx2 = this.xx2;
            float yy1 = this.yy1;
            float yy2 = this.yy2;
            if (wet_delta != 0.0f) {
                for (int i = 0; i < len; ++i) {
                    float x = buffer[i];
                    float y = (a0 += a0_delta) * x + (a1 += a1_delta) * x1 + (a2 += a2_delta) * x2 - (b1 += b1_delta) * y1 - (b2 += b2_delta) * y2;
                    float xx = y * (gain += gain_delta) * (wet += wet_delta) + x * (1.0f - wet);
                    x2 = x1;
                    x1 = x;
                    y2 = y1;
                    y1 = y;
                    float yy = a0 * xx + a1 * xx1 + a2 * xx2 - b1 * yy1 - b2 * yy2;
                    buffer[i] = yy * gain * wet + xx * (1.0f - wet);
                    xx2 = xx1;
                    xx1 = xx;
                    yy2 = yy1;
                    yy1 = yy;
                }
            } else if (a0_delta == 0.0f && a1_delta == 0.0f && a2_delta == 0.0f && b1_delta == 0.0f && b2_delta == 0.0f) {
                for (int i = 0; i < len; ++i) {
                    float x = buffer[i];
                    float y = a0 * x + a1 * x1 + a2 * x2 - b1 * y1 - b2 * y2;
                    float xx = y * gain * wet + x * (1.0f - wet);
                    x2 = x1;
                    x1 = x;
                    y2 = y1;
                    y1 = y;
                    float yy = a0 * xx + a1 * xx1 + a2 * xx2 - b1 * yy1 - b2 * yy2;
                    buffer[i] = yy * gain * wet + xx * (1.0f - wet);
                    xx2 = xx1;
                    xx1 = xx;
                    yy2 = yy1;
                    yy1 = yy;
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    float x = buffer[i];
                    float y = (a0 += a0_delta) * x + (a1 += a1_delta) * x1 + (a2 += a2_delta) * x2 - (b1 += b1_delta) * y1 - (b2 += b2_delta) * y2;
                    float xx = y * (gain += gain_delta) * wet + x * (1.0f - wet);
                    x2 = x1;
                    x1 = x;
                    y2 = y1;
                    y1 = y;
                    float yy = a0 * xx + a1 * xx1 + a2 * xx2 - b1 * yy1 - b2 * yy2;
                    buffer[i] = yy * gain * wet + xx * (1.0f - wet);
                    xx2 = xx1;
                    xx1 = xx;
                    yy2 = yy1;
                    yy1 = yy;
                }
            }
            if ((double)Math.abs(x1) < 1.0E-8) {
                x1 = 0.0f;
            }
            if ((double)Math.abs(x2) < 1.0E-8) {
                x2 = 0.0f;
            }
            if ((double)Math.abs(y1) < 1.0E-8) {
                y1 = 0.0f;
            }
            if ((double)Math.abs(y2) < 1.0E-8) {
                y2 = 0.0f;
            }
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
            this.xx1 = xx1;
            this.xx2 = xx2;
            this.yy1 = yy1;
            this.yy2 = yy2;
        }
        this.last_a0 = this.a0;
        this.last_a1 = this.a1;
        this.last_a2 = this.a2;
        this.last_b1 = this.b1;
        this.last_b2 = this.b2;
        this.last_gain = this.gain;
        this.last_wet = this.wet;
    }

    private double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) * 0.5;
    }

    public void filter2calc() {
        double b2;
        double b1;
        double a2;
        double a1;
        double a0;
        double q;
        double resonance;
        double csq;
        double c;
        double cf;
        double a22;
        double a12;
        double a02;
        double b22;
        double b12;
        double b0;
        double alpha;
        double sn;
        double cs;
        double omega;
        double bandwidth;
        double r;
        double resonancedB = this.resonancedB;
        if (resonancedB < 0.0) {
            resonancedB = 0.0;
        }
        if (resonancedB > 30.0) {
            resonancedB = 30.0;
        }
        if (this.filtertype == 3 || this.filtertype == 19) {
            resonancedB *= 0.6;
        }
        if (this.filtertype == 33) {
            this.wet = 1.0f;
            r = this.cutoff / (double)this.samplerate;
            if (r > 0.45) {
                r = 0.45;
            }
            bandwidth = Math.PI * Math.pow(10.0, -(resonancedB / 20.0));
            omega = Math.PI * 2 * r;
            cs = Math.cos(omega);
            sn = Math.sin(omega);
            b0 = alpha = sn * this.sinh(Math.log(2.0) * bandwidth * omega / (sn * 2.0));
            b12 = 0.0;
            b22 = -alpha;
            a02 = 1.0 + alpha;
            a12 = -2.0 * cs;
            a22 = 1.0 - alpha;
            cf = 1.0 / a02;
            this.b1 = (float)(a12 * cf);
            this.b2 = (float)(a22 * cf);
            this.a0 = (float)(b0 * cf);
            this.a1 = (float)(b12 * cf);
            this.a2 = (float)(b22 * cf);
        }
        if (this.filtertype == 49) {
            this.wet = 1.0f;
            r = this.cutoff / (double)this.samplerate;
            if (r > 0.45) {
                r = 0.45;
            }
            bandwidth = Math.PI * Math.pow(10.0, -(resonancedB / 20.0));
            omega = Math.PI * 2 * r;
            cs = Math.cos(omega);
            sn = Math.sin(omega);
            alpha = sn * this.sinh(Math.log(2.0) * bandwidth * omega / (sn * 2.0));
            b0 = 1.0;
            b12 = -2.0 * cs;
            b22 = 1.0;
            a02 = 1.0 + alpha;
            a12 = -2.0 * cs;
            a22 = 1.0 - alpha;
            cf = 1.0 / a02;
            this.b1 = (float)(a12 * cf);
            this.b2 = (float)(a22 * cf);
            this.a0 = (float)(b0 * cf);
            this.a1 = (float)(b12 * cf);
            this.a2 = (float)(b22 * cf);
        }
        if (this.filtertype == 1 || this.filtertype == 3) {
            r = this.cutoff / (double)this.samplerate;
            if (r > 0.45) {
                if (this.wet == 0.0f) {
                    this.wet = resonancedB < 1.0E-5 ? 0.0f : 1.0f;
                }
                r = 0.45;
            } else {
                this.wet = 1.0f;
            }
            c = 1.0 / Math.tan(Math.PI * r);
            csq = c * c;
            resonance = Math.pow(10.0, -(resonancedB / 20.0));
            q = Math.sqrt(2.0) * resonance;
            a0 = 1.0 / (1.0 + q * c + csq);
            a1 = 2.0 * a0;
            a2 = a0;
            b1 = 2.0 * a0 * (1.0 - csq);
            b2 = a0 * (1.0 - q * c + csq);
            this.a0 = (float)a0;
            this.a1 = (float)a1;
            this.a2 = (float)a2;
            this.b1 = (float)b1;
            this.b2 = (float)b2;
        }
        if (this.filtertype == 17 || this.filtertype == 19) {
            r = this.cutoff / (double)this.samplerate;
            if (r > 0.45) {
                r = 0.45;
            }
            if (r < 1.0E-4) {
                r = 1.0E-4;
            }
            this.wet = 1.0f;
            c = Math.tan(Math.PI * r);
            csq = c * c;
            resonance = Math.pow(10.0, -(resonancedB / 20.0));
            q = Math.sqrt(2.0) * resonance;
            a0 = 1.0 / (1.0 + q * c + csq);
            a1 = -2.0 * a0;
            a2 = a0;
            b1 = 2.0 * a0 * (csq - 1.0);
            b2 = a0 * (1.0 - q * c + csq);
            this.a0 = (float)a0;
            this.a1 = (float)a1;
            this.a2 = (float)a2;
            this.b1 = (float)b1;
            this.b2 = (float)b2;
        }
    }

    public void filter2(SoftAudioBuffer sbuffer) {
        float[] buffer = sbuffer.array();
        if (this.dirty) {
            this.filter2calc();
            this.dirty = false;
        }
        if (!this.last_set) {
            this.last_a0 = this.a0;
            this.last_a1 = this.a1;
            this.last_a2 = this.a2;
            this.last_b1 = this.b1;
            this.last_b2 = this.b2;
            this.last_q = this.q;
            this.last_gain = this.gain;
            this.last_wet = this.wet;
            this.last_set = true;
        }
        if (this.wet > 0.0f || this.last_wet > 0.0f) {
            int len = buffer.length;
            float a0 = this.last_a0;
            float a1 = this.last_a1;
            float a2 = this.last_a2;
            float b1 = this.last_b1;
            float b2 = this.last_b2;
            float gain = this.last_gain;
            float wet = this.last_wet;
            float a0_delta = (this.a0 - this.last_a0) / (float)len;
            float a1_delta = (this.a1 - this.last_a1) / (float)len;
            float a2_delta = (this.a2 - this.last_a2) / (float)len;
            float b1_delta = (this.b1 - this.last_b1) / (float)len;
            float b2_delta = (this.b2 - this.last_b2) / (float)len;
            float gain_delta = (this.gain - this.last_gain) / (float)len;
            float wet_delta = (this.wet - this.last_wet) / (float)len;
            float x1 = this.x1;
            float x2 = this.x2;
            float y1 = this.y1;
            float y2 = this.y2;
            if (wet_delta != 0.0f) {
                for (int i = 0; i < len; ++i) {
                    float x = buffer[i];
                    float y = (a0 += a0_delta) * x + (a1 += a1_delta) * x1 + (a2 += a2_delta) * x2 - (b1 += b1_delta) * y1 - (b2 += b2_delta) * y2;
                    buffer[i] = y * (gain += gain_delta) * (wet += wet_delta) + x * (1.0f - wet);
                    x2 = x1;
                    x1 = x;
                    y2 = y1;
                    y1 = y;
                }
            } else if (a0_delta == 0.0f && a1_delta == 0.0f && a2_delta == 0.0f && b1_delta == 0.0f && b2_delta == 0.0f) {
                for (int i = 0; i < len; ++i) {
                    float x = buffer[i];
                    float y = a0 * x + a1 * x1 + a2 * x2 - b1 * y1 - b2 * y2;
                    buffer[i] = y * gain;
                    x2 = x1;
                    x1 = x;
                    y2 = y1;
                    y1 = y;
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    float x = buffer[i];
                    float y = (a0 += a0_delta) * x + (a1 += a1_delta) * x1 + (a2 += a2_delta) * x2 - (b1 += b1_delta) * y1 - (b2 += b2_delta) * y2;
                    buffer[i] = y * (gain += gain_delta);
                    x2 = x1;
                    x1 = x;
                    y2 = y1;
                    y1 = y;
                }
            }
            if ((double)Math.abs(x1) < 1.0E-8) {
                x1 = 0.0f;
            }
            if ((double)Math.abs(x2) < 1.0E-8) {
                x2 = 0.0f;
            }
            if ((double)Math.abs(y1) < 1.0E-8) {
                y1 = 0.0f;
            }
            if ((double)Math.abs(y2) < 1.0E-8) {
                y2 = 0.0f;
            }
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
        }
        this.last_a0 = this.a0;
        this.last_a1 = this.a1;
        this.last_a2 = this.a2;
        this.last_b1 = this.b1;
        this.last_b2 = this.b2;
        this.last_q = this.q;
        this.last_gain = this.gain;
        this.last_wet = this.wet;
    }

    public void filter1calc() {
        double c;
        if (this.cutoff < 120.0) {
            this.cutoff = 120.0;
        }
        if ((c = 7.3303828583761845 * this.cutoff / (double)this.samplerate) > 1.0) {
            c = 1.0;
        }
        this.a0 = (float)(Math.sqrt(1.0 - Math.cos(c)) * Math.sqrt(1.5707963267948966));
        if (this.resonancedB < 0.0) {
            this.resonancedB = 0.0;
        }
        if (this.resonancedB > 20.0) {
            this.resonancedB = 20.0;
        }
        this.q = (float)(Math.sqrt(0.5) * Math.pow(10.0, -(this.resonancedB / 20.0)));
        this.gain = (float)Math.pow(10.0, -this.resonancedB / 40.0);
        if (this.wet == 0.0f && (this.resonancedB > 1.0E-5 || c < 0.9999999)) {
            this.wet = 1.0f;
        }
    }

    public void filter1(SoftAudioBuffer sbuffer) {
        if (this.dirty) {
            this.filter1calc();
            this.dirty = false;
        }
        if (!this.last_set) {
            this.last_a0 = this.a0;
            this.last_q = this.q;
            this.last_gain = this.gain;
            this.last_wet = this.wet;
            this.last_set = true;
        }
        if (this.wet > 0.0f || this.last_wet > 0.0f) {
            float[] buffer = sbuffer.array();
            int len = buffer.length;
            float a0 = this.last_a0;
            float q = this.last_q;
            float gain = this.last_gain;
            float wet = this.last_wet;
            float a0_delta = (this.a0 - this.last_a0) / (float)len;
            float q_delta = (this.q - this.last_q) / (float)len;
            float gain_delta = (this.gain - this.last_gain) / (float)len;
            float wet_delta = (this.wet - this.last_wet) / (float)len;
            float y2 = this.y2;
            float y1 = this.y1;
            if (wet_delta != 0.0f) {
                for (int i = 0; i < len; ++i) {
                    float ga0 = 1.0f - (q += q_delta) * (a0 += a0_delta);
                    y1 = ga0 * y1 + a0 * (buffer[i] - y2);
                    y2 = ga0 * y2 + a0 * y1;
                    buffer[i] = y2 * (gain += gain_delta) * (wet += wet_delta) + buffer[i] * (1.0f - wet);
                }
            } else if (a0_delta == 0.0f && q_delta == 0.0f) {
                float ga0 = 1.0f - q * a0;
                for (int i = 0; i < len; ++i) {
                    y1 = ga0 * y1 + a0 * (buffer[i] - y2);
                    y2 = ga0 * y2 + a0 * y1;
                    buffer[i] = y2 * gain;
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    float ga0 = 1.0f - (q += q_delta) * (a0 += a0_delta);
                    y1 = ga0 * y1 + a0 * (buffer[i] - y2);
                    y2 = ga0 * y2 + a0 * y1;
                    buffer[i] = y2 * (gain += gain_delta);
                }
            }
            if ((double)Math.abs(y2) < 1.0E-8) {
                y2 = 0.0f;
            }
            if ((double)Math.abs(y1) < 1.0E-8) {
                y1 = 0.0f;
            }
            this.y2 = y2;
            this.y1 = y1;
        }
        this.last_a0 = this.a0;
        this.last_q = this.q;
        this.last_gain = this.gain;
        this.last_wet = this.wet;
    }
}

