/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.ConstantPool;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

final class Fixups
extends AbstractCollection<Fixup> {
    byte[] bytes;
    int head;
    int tail;
    int size;
    ConstantPool.Entry[] entries;
    int[] bigDescs;
    private static final int MINBIGSIZE = 1;
    private static int[] noBigDescs = new int[]{1};
    static final int LOC_SHIFT = 1;
    static final int FMT_MASK = 1;
    static final byte UNUSED_BYTE = 0;
    static final byte OVERFLOW_BYTE = -1;
    static final int BIGSIZE = 0;
    public static final int U2_FORMAT = 0;
    public static final int U1_FORMAT = 1;
    private static final int SPECIAL_LOC = 0;
    private static final int SPECIAL_FMT = 0;

    Fixups(byte[] bytes) {
        this.bytes = bytes;
        this.entries = new ConstantPool.Entry[3];
        this.bigDescs = noBigDescs;
    }

    Fixups() {
        this((byte[])null);
    }

    Fixups(byte[] bytes, Collection<Fixup> fixups) {
        this(bytes);
        this.addAll((Collection<? extends Fixup>)fixups);
    }

    Fixups(Collection<Fixup> fixups) {
        this((byte[])null);
        this.addAll((Collection<? extends Fixup>)fixups);
    }

    @Override
    public int size() {
        return this.size;
    }

    public void trimToSize() {
        int bigSize;
        if (this.size != this.entries.length) {
            ConstantPool.Entry[] oldEntries = this.entries;
            this.entries = new ConstantPool.Entry[this.size];
            System.arraycopy(oldEntries, 0, this.entries, 0, this.size);
        }
        if ((bigSize = this.bigDescs[0]) == 1) {
            this.bigDescs = noBigDescs;
        } else if (bigSize != this.bigDescs.length) {
            int[] oldBigDescs = this.bigDescs;
            this.bigDescs = new int[bigSize];
            System.arraycopy(oldBigDescs, 0, this.bigDescs, 0, bigSize);
        }
    }

    public void visitRefs(Collection<ConstantPool.Entry> refs) {
        for (int i = 0; i < this.size; ++i) {
            refs.add(this.entries[i]);
        }
    }

    @Override
    public void clear() {
        if (this.bytes != null) {
            for (Fixup fx : this) {
                this.storeIndex(fx.location(), fx.format(), 0);
            }
        }
        this.size = 0;
        if (this.bigDescs != noBigDescs) {
            this.bigDescs[0] = 1;
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] newBytes) {
        if (this.bytes == newBytes) {
            return;
        }
        ArrayList<Fixup> old = null;
        assert ((old = new ArrayList<Fixup>(this)) != null);
        if (this.bytes == null || newBytes == null) {
            ArrayList<Fixup> save = new ArrayList<Fixup>(this);
            this.clear();
            this.bytes = newBytes;
            this.addAll((Collection<? extends Fixup>)save);
        } else {
            this.bytes = newBytes;
        }
        assert (old.equals(new ArrayList<Fixup>(this)));
    }

    static int fmtLen(int fmt) {
        return 1 + (fmt - 1) / -1;
    }

    static int descLoc(int desc) {
        return desc >>> 1;
    }

    static int descFmt(int desc) {
        return desc & 1;
    }

    static int descEnd(int desc) {
        return Fixups.descLoc(desc) + Fixups.fmtLen(Fixups.descFmt(desc));
    }

    static int makeDesc(int loc, int fmt) {
        int desc = loc << 1 | fmt;
        assert (Fixups.descLoc(desc) == loc);
        assert (Fixups.descFmt(desc) == fmt);
        return desc;
    }

    int fetchDesc(int loc, int fmt) {
        int value;
        byte b1 = this.bytes[loc];
        assert (b1 != -1);
        if (fmt == 0) {
            byte b2 = this.bytes[loc + 1];
            value = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
        } else {
            value = b1 & 0xFF;
        }
        return value + (loc << 1);
    }

    boolean storeDesc(int loc, int fmt, int desc) {
        if (this.bytes == null) {
            return false;
        }
        int value = desc - (loc << 1);
        switch (fmt) {
            case 0: {
                assert (this.bytes[loc + 0] == 0);
                assert (this.bytes[loc + 1] == 0);
                byte b1 = (byte)(value >> 8);
                byte b2 = (byte)(value >> 0);
                if (value != (value & 0xFFFF) || b1 == -1) break;
                this.bytes[loc + 0] = b1;
                this.bytes[loc + 1] = b2;
                assert (this.fetchDesc(loc, fmt) == desc);
                return true;
            }
            case 1: {
                assert (this.bytes[loc] == 0);
                byte b1 = (byte)value;
                if (value != (value & 0xFF) || b1 == -1) break;
                this.bytes[loc] = b1;
                assert (this.fetchDesc(loc, fmt) == desc);
                return true;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.bytes[loc] = -1;
        assert (fmt == 1 || (this.bytes[loc + 1] = (byte)this.bigDescs[0]) != 999);
        return false;
    }

    void storeIndex(int loc, int fmt, int value) {
        Fixups.storeIndex(this.bytes, loc, fmt, value);
    }

    static void storeIndex(byte[] bytes, int loc, int fmt, int value) {
        switch (fmt) {
            case 0: {
                assert (value == (value & 0xFFFF)) : value;
                bytes[loc + 0] = (byte)(value >> 8);
                bytes[loc + 1] = (byte)(value >> 0);
                break;
            }
            case 1: {
                assert (value == (value & 0xFF)) : value;
                bytes[loc] = (byte)value;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public Iterator<Fixup> iterator() {
        return new Itr();
    }

    public void add(int location, int format, ConstantPool.Entry entry) {
        this.addDesc(Fixups.makeDesc(location, format), entry);
    }

    @Override
    public boolean add(Fixup f) {
        this.addDesc(f.desc, f.entry);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Fixup> c) {
        if (c instanceof Fixups) {
            Fixups that = (Fixups)c;
            if (that.size == 0) {
                return false;
            }
            if (this.size == 0 && this.entries.length < that.size) {
                this.growEntries(that.size);
            }
            ConstantPool.Entry[] thatEntries = that.entries;
            Fixups fixups = that;
            fixups.getClass();
            Itr i = fixups.new Itr();
            while (i.hasNext()) {
                int ni = i.index;
                this.addDesc(i.nextDesc(), thatEntries[ni]);
            }
            return true;
        }
        return super.addAll(c);
    }

    private void addDesc(int thisDesc, ConstantPool.Entry entry) {
        if (this.entries.length == this.size) {
            this.growEntries(this.size * 2);
        }
        this.entries[this.size] = entry;
        if (this.size == 0) {
            this.head = this.tail = thisDesc;
        } else {
            int prevDesc = this.tail;
            int prevLoc = Fixups.descLoc(prevDesc);
            int prevFmt = Fixups.descFmt(prevDesc);
            int prevLen = Fixups.fmtLen(prevFmt);
            int thisLoc = Fixups.descLoc(thisDesc);
            if (thisLoc < prevLoc + prevLen) {
                this.badOverlap(thisLoc);
            }
            this.tail = thisDesc;
            if (!this.storeDesc(prevLoc, prevFmt, thisDesc)) {
                int bigSize = this.bigDescs[0];
                if (this.bigDescs.length == bigSize) {
                    this.growBigDescs();
                }
                this.bigDescs[bigSize++] = thisDesc;
                this.bigDescs[0] = bigSize;
            }
        }
        ++this.size;
    }

    private void badOverlap(int thisLoc) {
        throw new IllegalArgumentException("locs must be ascending and must not overlap:  " + thisLoc + " >> " + this);
    }

    private void growEntries(int newSize) {
        ConstantPool.Entry[] oldEntries = this.entries;
        this.entries = new ConstantPool.Entry[Math.max(3, newSize)];
        System.arraycopy(oldEntries, 0, this.entries, 0, oldEntries.length);
    }

    private void growBigDescs() {
        int[] oldBigDescs = this.bigDescs;
        this.bigDescs = new int[oldBigDescs.length * 2];
        System.arraycopy(oldBigDescs, 0, this.bigDescs, 0, oldBigDescs.length);
    }

    public static Object add(Object prevFixups, byte[] bytes, int loc, int fmt, ConstantPool.Entry e) {
        Fixups f;
        if (prevFixups == null) {
            if (loc == 0 && fmt == 0) {
                return e;
            }
            f = new Fixups(bytes);
        } else if (!(prevFixups instanceof Fixups)) {
            ConstantPool.Entry firstEntry = (ConstantPool.Entry)prevFixups;
            f = new Fixups(bytes);
            f.add(0, 0, firstEntry);
        } else {
            f = (Fixups)prevFixups;
            assert (f.bytes == bytes);
        }
        f.add(loc, fmt, e);
        return f;
    }

    public static void setBytes(Object fixups, byte[] bytes) {
        if (fixups instanceof Fixups) {
            Fixups f = (Fixups)fixups;
            f.setBytes(bytes);
        }
    }

    public static Object trimToSize(Object fixups) {
        if (fixups instanceof Fixups) {
            Fixups f = (Fixups)fixups;
            f.trimToSize();
            if (f.size() == 0) {
                fixups = null;
            }
        }
        return fixups;
    }

    public static void visitRefs(Object fixups, Collection<ConstantPool.Entry> refs) {
        if (fixups != null) {
            if (!(fixups instanceof Fixups)) {
                refs.add((ConstantPool.Entry)fixups);
            } else {
                Fixups f = (Fixups)fixups;
                f.visitRefs(refs);
            }
        }
    }

    public static void finishRefs(Object fixups, byte[] bytes, ConstantPool.Index ix) {
        if (fixups == null) {
            return;
        }
        if (!(fixups instanceof Fixups)) {
            int index = ix.indexOf((ConstantPool.Entry)fixups);
            Fixups.storeIndex(bytes, 0, 0, index);
            return;
        }
        Fixups f = (Fixups)fixups;
        assert (f.bytes == bytes);
        f.finishRefs(ix);
    }

    void finishRefs(ConstantPool.Index ix) {
        if (this.isEmpty()) {
            return;
        }
        for (Fixup fx : this) {
            int index = ix.indexOf(fx.entry);
            this.storeIndex(fx.location(), fx.format(), index);
        }
        this.bytes = null;
        this.clear();
    }

    private class Itr
    implements Iterator<Fixup> {
        int index = 0;
        int bigIndex = 1;
        int next;

        private Itr() {
            this.next = Fixups.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.index < Fixups.this.size;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Fixup next() {
            int thisIndex = this.index;
            return new Fixup(this.nextDesc(), Fixups.this.entries[thisIndex]);
        }

        int nextDesc() {
            ++this.index;
            int thisDesc = this.next;
            if (this.index < Fixups.this.size) {
                int loc = Fixups.descLoc(thisDesc);
                int fmt = Fixups.descFmt(thisDesc);
                if (Fixups.this.bytes != null && Fixups.this.bytes[loc] != -1) {
                    this.next = Fixups.this.fetchDesc(loc, fmt);
                } else {
                    assert (fmt == 1 || Fixups.this.bytes == null || Fixups.this.bytes[loc + 1] == (byte)this.bigIndex);
                    this.next = Fixups.this.bigDescs[this.bigIndex++];
                }
            }
            return thisDesc;
        }
    }

    public static class Fixup
    implements Comparable<Fixup> {
        int desc;
        ConstantPool.Entry entry;

        Fixup(int desc, ConstantPool.Entry entry) {
            this.desc = desc;
            this.entry = entry;
        }

        public Fixup(int loc, int fmt, ConstantPool.Entry entry) {
            this.desc = Fixups.makeDesc(loc, fmt);
            this.entry = entry;
        }

        public int location() {
            return Fixups.descLoc(this.desc);
        }

        public int format() {
            return Fixups.descFmt(this.desc);
        }

        public ConstantPool.Entry entry() {
            return this.entry;
        }

        @Override
        public int compareTo(Fixup that) {
            return this.location() - that.location();
        }

        public boolean equals(Object x) {
            if (!(x instanceof Fixup)) {
                return false;
            }
            Fixup that = (Fixup)x;
            return this.desc == that.desc && this.entry == that.entry;
        }

        public String toString() {
            return "@" + this.location() + (this.format() == 1 ? ".1" : "") + "=" + this.entry;
        }
    }
}

