/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

abstract class ISO2022
extends Charset {
    private static final byte ISO_ESC = 27;
    private static final byte ISO_SI = 15;
    private static final byte ISO_SO = 14;
    private static final byte ISO_SS2_7 = 78;
    private static final byte ISO_SS3_7 = 79;
    private static final byte MSB = -128;
    private static final char REPLACE_CHAR = '\ufffd';
    private static final byte minDesignatorLength = 3;

    public ISO2022(String csname, String[] aliases) {
        super(csname, aliases);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected static class Encoder
    extends CharsetEncoder {
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        public static final byte SS2 = -114;
        public static final byte PLANE2 = -94;
        public static final byte PLANE3 = -93;
        private final byte MSB = (byte)-128;
        protected final byte maximumDesignatorLength = (byte)4;
        protected String SODesig;
        protected String SS2Desig = null;
        protected String SS3Desig = null;
        protected CharsetEncoder ISOEncoder;
        private boolean shiftout = false;
        private boolean SODesDefined = false;
        private boolean SS2DesDefined = false;
        private boolean SS3DesDefined = false;
        private boolean newshiftout = false;
        private boolean newSODesDefined = false;
        private boolean newSS2DesDefined = false;
        private boolean newSS3DesDefined = false;

        protected Encoder(Charset cs) {
            super(cs, 4.0f, 8.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return this.ISOEncoder.canEncode(c);
        }

        @Override
        protected void implReset() {
            this.shiftout = false;
            this.SODesDefined = false;
            this.SS2DesDefined = false;
            this.SS3DesDefined = false;
        }

        private int unicodeToNative(char unicode, byte[] ebyte) {
            int converted;
            int index = 0;
            char[] convChar = new char[]{unicode};
            byte[] convByte = new byte[4];
            try {
                CharBuffer cc = CharBuffer.wrap(convChar);
                ByteBuffer bb = ByteBuffer.allocate(4);
                this.ISOEncoder.encode(cc, bb, true);
                bb.flip();
                converted = bb.remaining();
                bb.get(convByte, 0, converted);
            }
            catch (Exception e) {
                return -1;
            }
            if (converted == 2) {
                if (!this.SODesDefined) {
                    this.newSODesDefined = true;
                    ebyte[0] = 27;
                    byte[] tmpByte = this.SODesig.getBytes();
                    System.arraycopy(tmpByte, 0, ebyte, 1, tmpByte.length);
                    index = tmpByte.length + 1;
                }
                if (!this.shiftout) {
                    this.newshiftout = true;
                    ebyte[index++] = 14;
                }
                ebyte[index++] = (byte)(convByte[0] & 0x7F);
                ebyte[index++] = (byte)(convByte[1] & 0x7F);
            } else if (convByte[0] == -114) {
                if (convByte[1] == -94) {
                    if (!this.SS2DesDefined) {
                        this.newSS2DesDefined = true;
                        ebyte[0] = 27;
                        byte[] tmpByte = this.SS2Desig.getBytes();
                        System.arraycopy(tmpByte, 0, ebyte, 1, tmpByte.length);
                        index = tmpByte.length + 1;
                    }
                    ebyte[index++] = 27;
                    ebyte[index++] = 78;
                    ebyte[index++] = (byte)(convByte[2] & 0x7F);
                    ebyte[index++] = (byte)(convByte[3] & 0x7F);
                } else if (convByte[1] == -93) {
                    if (!this.SS3DesDefined) {
                        this.newSS3DesDefined = true;
                        ebyte[0] = 27;
                        byte[] tmpByte = this.SS3Desig.getBytes();
                        System.arraycopy(tmpByte, 0, ebyte, 1, tmpByte.length);
                        index = tmpByte.length + 1;
                    }
                    ebyte[index++] = 27;
                    ebyte[index++] = 79;
                    ebyte[index++] = (byte)(convByte[2] & 0x7F);
                    ebyte[index++] = (byte)(convByte[3] & 0x7F);
                }
            }
            return index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            char[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            assert (sp <= sl);
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            assert (dp <= dl);
            dp = dp <= dl ? dp : dl;
            int outputSize = 0;
            byte[] outputByte = new byte[8];
            this.newshiftout = this.shiftout;
            this.newSODesDefined = this.SODesDefined;
            this.newSS2DesDefined = this.SS2DesDefined;
            this.newSS3DesDefined = this.SS3DesDefined;
            try {
                for (sp = sp <= sl ? sp : sl; sp < sl; ++sp) {
                    char c = sa[sp];
                    if (Character.isSurrogate(c)) {
                        if (this.sgp.parse(c, sa, sp, sl) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    if (c < '\u0080') {
                        if (this.shiftout) {
                            this.newshiftout = false;
                            outputSize = 2;
                            outputByte[0] = 15;
                            outputByte[1] = (byte)(c & 0x7F);
                        } else {
                            outputSize = 1;
                            outputByte[0] = (byte)(c & 0x7F);
                        }
                        if (sa[sp] == '\n') {
                            this.newSODesDefined = false;
                            this.newSS2DesDefined = false;
                            this.newSS3DesDefined = false;
                        }
                    } else {
                        outputSize = this.unicodeToNative(c, outputByte);
                        if (outputSize == 0) {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (dl - dp < outputSize) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (int i = 0; i < outputSize; ++i) {
                        da[dp++] = outputByte[i];
                    }
                    this.shiftout = this.newshiftout;
                    this.SODesDefined = this.newSODesDefined;
                    this.SS2DesDefined = this.newSS2DesDefined;
                    this.SS3DesDefined = this.newSS3DesDefined;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int outputSize = 0;
            byte[] outputByte = new byte[8];
            boolean inputSize = false;
            this.newshiftout = this.shiftout;
            this.newSODesDefined = this.SODesDefined;
            this.newSS2DesDefined = this.SS2DesDefined;
            this.newSS3DesDefined = this.SS3DesDefined;
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    char inputChar = src.get();
                    if (Character.isSurrogate(inputChar)) {
                        if (this.sgp.parse(inputChar, src) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    if (inputChar < '\u0080') {
                        if (this.shiftout) {
                            this.newshiftout = false;
                            outputSize = 2;
                            outputByte[0] = 15;
                            outputByte[1] = (byte)(inputChar & 0x7F);
                        } else {
                            outputSize = 1;
                            outputByte[0] = (byte)(inputChar & 0x7F);
                        }
                        if (inputChar == '\n') {
                            this.newSODesDefined = false;
                            this.newSS2DesDefined = false;
                            this.newSS3DesDefined = false;
                        }
                    } else {
                        outputSize = this.unicodeToNative(inputChar, outputByte);
                        if (outputSize == 0) {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (dst.remaining() < outputSize) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (int i = 0; i < outputSize; ++i) {
                        dst.put(outputByte[i]);
                    }
                    ++mark;
                    this.shiftout = this.newshiftout;
                    this.SODesDefined = this.newSODesDefined;
                    this.SS2DesDefined = this.newSS2DesDefined;
                    this.SS3DesDefined = this.newSS3DesDefined;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }
    }

    protected static class Decoder
    extends CharsetDecoder {
        protected byte[][] SODesig;
        protected byte[][] SS2Desig = null;
        protected byte[][] SS3Desig = null;
        protected CharsetDecoder[] SODecoder;
        protected CharsetDecoder[] SS2Decoder = null;
        protected CharsetDecoder[] SS3Decoder = null;
        private static final byte SOFlag = 0;
        private static final byte SS2Flag = 1;
        private static final byte SS3Flag = 2;
        private int curSODes;
        private int curSS2Des;
        private int curSS3Des;
        private boolean shiftout;
        private CharsetDecoder[] tmpDecoder;

        protected Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        @Override
        protected void implReset() {
            this.curSODes = 0;
            this.curSS2Des = 0;
            this.curSS3Des = 0;
            this.shiftout = false;
        }

        private char decode(byte byte1, byte byte2, byte shiftFlag) {
            byte1 = (byte)(byte1 | 0xFFFFFF80);
            byte2 = (byte)(byte2 | 0xFFFFFF80);
            byte[] tmpByte = new byte[]{byte1, byte2};
            char[] tmpChar = new char[1];
            int i = 0;
            int tmpIndex = 0;
            switch (shiftFlag) {
                case 0: {
                    tmpIndex = this.curSODes;
                    this.tmpDecoder = this.SODecoder;
                    break;
                }
                case 1: {
                    tmpIndex = this.curSS2Des;
                    this.tmpDecoder = this.SS2Decoder;
                    break;
                }
                case 2: {
                    tmpIndex = this.curSS3Des;
                    this.tmpDecoder = this.SS3Decoder;
                }
            }
            if (this.tmpDecoder != null) {
                for (i = 0; i < this.tmpDecoder.length; ++i) {
                    if (tmpIndex != i) continue;
                    try {
                        ByteBuffer bb = ByteBuffer.wrap(tmpByte, 0, 2);
                        CharBuffer cc = CharBuffer.wrap(tmpChar, 0, 1);
                        this.tmpDecoder[i].decode(bb, cc, true);
                        cc.flip();
                        return cc.get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return '\ufffd';
        }

        private int findDesig(byte[] in, int sp, int sl, byte[][] desigs) {
            if (desigs == null) {
                return -1;
            }
            for (int i = 0; i < desigs.length; ++i) {
                int j;
                if (desigs[i] == null || sl - sp < desigs[i].length) continue;
                for (j = 0; j < desigs[i].length && in[sp + j] == desigs[i][j]; ++j) {
                }
                if (j != desigs[i].length) continue;
                return i;
            }
            return -1;
        }

        private int findDesigBuf(ByteBuffer in, byte[][] desigs) {
            if (desigs == null) {
                return -1;
            }
            for (int i = 0; i < desigs.length; ++i) {
                int j;
                if (desigs[i] == null || in.remaining() < desigs[i].length) continue;
                in.mark();
                for (j = 0; j < desigs[i].length && in.get() == desigs[i][j]; ++j) {
                }
                if (j == desigs[i].length) {
                    return i;
                }
                in.reset();
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            byte[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            assert (sp <= sl);
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            assert (dp <= dl);
            dp = dp <= dl ? dp : dl;
            int b1 = 0;
            int b2 = 0;
            byte b3 = 0;
            try {
                int inputSize;
                block22: for (sp = sp <= sl ? sp : sl; sp < sl; sp += inputSize) {
                    b1 = sa[sp] & 0xFF;
                    inputSize = 1;
                    switch (b1) {
                        case 14: {
                            this.shiftout = true;
                            inputSize = 1;
                            continue block22;
                        }
                        case 15: {
                            this.shiftout = false;
                            inputSize = 1;
                            continue block22;
                        }
                        case 27: {
                            if (sl - sp - 1 < 3) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            int desig = this.findDesig(sa, sp + 1, sl, this.SODesig);
                            if (desig != -1) {
                                this.curSODes = desig;
                                inputSize = this.SODesig[desig].length + 1;
                                continue block22;
                            }
                            desig = this.findDesig(sa, sp + 1, sl, this.SS2Desig);
                            if (desig != -1) {
                                this.curSS2Des = desig;
                                inputSize = this.SS2Desig[desig].length + 1;
                                continue block22;
                            }
                            desig = this.findDesig(sa, sp + 1, sl, this.SS3Desig);
                            if (desig != -1) {
                                this.curSS3Des = desig;
                                inputSize = this.SS3Desig[desig].length + 1;
                                continue block22;
                            }
                            if (sl - sp < 2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            b1 = sa[sp + 1];
                            switch (b1) {
                                case 78: {
                                    if (sl - sp < 4) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    b2 = sa[sp + 2];
                                    b3 = sa[sp + 3];
                                    if (dl - dp < 1) {
                                        CoderResult coderResult = CoderResult.OVERFLOW;
                                        return coderResult;
                                    }
                                    da[dp] = this.decode((byte)b2, b3, (byte)1);
                                    ++dp;
                                    inputSize = 4;
                                    continue block22;
                                }
                                case 79: {
                                    if (sl - sp < 4) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    b2 = sa[sp + 2];
                                    b3 = sa[sp + 3];
                                    if (dl - dp < 1) {
                                        CoderResult coderResult = CoderResult.OVERFLOW;
                                        return coderResult;
                                    }
                                    da[dp] = this.decode((byte)b2, b3, (byte)2);
                                    ++dp;
                                    inputSize = 4;
                                    continue block22;
                                }
                            }
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        default: {
                            if (dl - dp < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (!this.shiftout) {
                                da[dp++] = (char)(sa[sp] & 0xFF);
                                continue block22;
                            }
                            if (dl - dp < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (sl - sp < 2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            b2 = sa[sp + 1] & 0xFF;
                            da[dp++] = this.decode((byte)b1, (byte)b2, (byte)0);
                            inputSize = 2;
                        }
                    }
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            byte b1 = 0;
            int b2 = 0;
            byte b3 = 0;
            try {
                while (src.hasRemaining()) {
                    b1 = src.get();
                    int inputSize = 1;
                    block12 : switch (b1) {
                        case 14: {
                            this.shiftout = true;
                            break;
                        }
                        case 15: {
                            this.shiftout = false;
                            break;
                        }
                        case 27: {
                            if (src.remaining() < 3) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            int desig = this.findDesigBuf(src, this.SODesig);
                            if (desig != -1) {
                                this.curSODes = desig;
                                inputSize = this.SODesig[desig].length + 1;
                                break;
                            }
                            desig = this.findDesigBuf(src, this.SS2Desig);
                            if (desig != -1) {
                                this.curSS2Des = desig;
                                inputSize = this.SS2Desig[desig].length + 1;
                                break;
                            }
                            desig = this.findDesigBuf(src, this.SS3Desig);
                            if (desig != -1) {
                                this.curSS3Des = desig;
                                inputSize = this.SS3Desig[desig].length + 1;
                                break;
                            }
                            if (src.remaining() < 1) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            b1 = src.get();
                            switch (b1) {
                                case 78: {
                                    if (src.remaining() < 2) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    b2 = src.get();
                                    b3 = src.get();
                                    if (dst.remaining() < 1) {
                                        CoderResult coderResult = CoderResult.OVERFLOW;
                                        return coderResult;
                                    }
                                    dst.put(this.decode((byte)b2, b3, (byte)1));
                                    inputSize = 4;
                                    break block12;
                                }
                                case 79: {
                                    if (src.remaining() < 2) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    b2 = src.get();
                                    b3 = src.get();
                                    if (dst.remaining() < 1) {
                                        CoderResult coderResult = CoderResult.OVERFLOW;
                                        return coderResult;
                                    }
                                    dst.put(this.decode((byte)b2, b3, (byte)2));
                                    inputSize = 4;
                                    break block12;
                                }
                            }
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        default: {
                            if (dst.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (!this.shiftout) {
                                dst.put((char)(b1 & 0xFF));
                                break;
                            }
                            if (dst.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (src.remaining() < 1) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            b2 = src.get() & 0xFF;
                            dst.put(this.decode(b1, (byte)b2, (byte)0));
                            inputSize = 2;
                        }
                    }
                    mark += inputSize;
                }
                CoderResult inputSize = CoderResult.UNDERFLOW;
                return inputSize;
            }
            catch (Exception e) {
                e.printStackTrace();
                CoderResult coderResult = CoderResult.OVERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }
    }
}

