/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.text.Bidi;

public final class BidiUtils {
    static final char NUMLEVELS = '>';

    public static void getLevels(Bidi bidi, byte[] levels, int start) {
        int limit = start + bidi.getLength();
        if (start < 0 || limit > levels.length) {
            throw new IndexOutOfBoundsException("levels.length = " + levels.length + " start: " + start + " limit: " + limit);
        }
        int runCount = bidi.getRunCount();
        int p = start;
        for (int i = 0; i < runCount; ++i) {
            int rlimit = start + bidi.getRunLimit(i);
            byte rlevel = (byte)bidi.getRunLevel(i);
            while (p < rlimit) {
                levels[p++] = rlevel;
            }
        }
    }

    public static byte[] getLevels(Bidi bidi) {
        byte[] levels = new byte[bidi.getLength()];
        BidiUtils.getLevels(bidi, levels, 0);
        return levels;
    }

    /*
     * Unable to fully structure code
     */
    public static int[] createVisualToLogicalMap(byte[] levels) {
        len = levels.length;
        mapping = new int[len];
        lowestOddLevel = 63;
        highestLevel = 0;
        for (i = 0; i < len; ++i) {
            mapping[i] = i;
            level = levels[i];
            if (level > highestLevel) {
                highestLevel = level;
            }
            if ((level & 1) == 0 || level >= lowestOddLevel) continue;
            lowestOddLevel = level;
        }
        while (highestLevel >= lowestOddLevel) {
            i = 0;
            block2: while (true) {
                if (i < len && levels[i] < highestLevel) {
                    ++i;
                    continue;
                }
                if ((begin = i++) == levels.length) break;
                while (i < len && levels[i] >= highestLevel) {
                    ++i;
                }
                end = i - 1;
                while (true) {
                    if (begin < end) ** break;
                    continue block2;
                    temp = mapping[begin];
                    mapping[begin] = mapping[end];
                    mapping[end] = temp;
                    ++begin;
                    --end;
                }
                break;
            }
            highestLevel = (byte)(highestLevel - 1);
        }
        return mapping;
    }

    public static int[] createInverseMap(int[] values) {
        if (values == null) {
            return null;
        }
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[values[i]] = i;
        }
        return result;
    }

    public static int[] createContiguousOrder(int[] values) {
        if (values != null) {
            return BidiUtils.computeContiguousOrder(values, 0, values.length);
        }
        return null;
    }

    private static int[] computeContiguousOrder(int[] values, int start, int limit) {
        int k;
        int i;
        int[] result = new int[limit - start];
        for (i = 0; i < result.length; ++i) {
            result[i] = i + start;
        }
        for (i = 0; i < result.length - 1; ++i) {
            int minIndex = i;
            int currentValue = values[result[minIndex]];
            for (int j = i; j < result.length; ++j) {
                if (values[result[j]] >= currentValue) continue;
                minIndex = j;
                currentValue = values[result[minIndex]];
            }
            int temp = result[i];
            result[i] = result[minIndex];
            result[minIndex] = temp;
        }
        if (start != 0) {
            i = 0;
            while (i < result.length) {
                int n = i++;
                result[n] = result[n] - start;
            }
        }
        for (k = 0; k < result.length && result[k] == k; ++k) {
        }
        if (k == result.length) {
            return null;
        }
        return BidiUtils.createInverseMap(result);
    }

    public static int[] createNormalizedMap(int[] values, byte[] levels, int start, int limit) {
        if (values != null) {
            if (start != 0 || limit != values.length) {
                boolean canonical;
                boolean copyRange;
                byte primaryLevel;
                if (levels == null) {
                    primaryLevel = 0;
                    copyRange = true;
                    canonical = true;
                } else if (levels[start] == levels[limit - 1]) {
                    int i;
                    primaryLevel = levels[start];
                    canonical = (primaryLevel & 1) == 0;
                    for (i = start; i < limit && levels[i] >= primaryLevel; ++i) {
                        if (!canonical) continue;
                        canonical = levels[i] == primaryLevel;
                    }
                    copyRange = i == limit;
                } else {
                    copyRange = false;
                    primaryLevel = 0;
                    canonical = false;
                }
                if (copyRange) {
                    if (canonical) {
                        return null;
                    }
                    int[] result = new int[limit - start];
                    int baseValue = (primaryLevel & 1) != 0 ? values[limit - 1] : values[start];
                    if (baseValue == 0) {
                        System.arraycopy(values, start, result, 0, limit - start);
                    } else {
                        for (int j = 0; j < result.length; ++j) {
                            result[j] = values[j + start] - baseValue;
                        }
                    }
                    return result;
                }
                return BidiUtils.computeContiguousOrder(values, start, limit);
            }
            return values;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void reorderVisually(byte[] levels, Object[] objects) {
        len = levels.length;
        lowestOddLevel = 63;
        highestLevel = 0;
        for (i = 0; i < len; ++i) {
            level = levels[i];
            if (level > highestLevel) {
                highestLevel = level;
            }
            if ((level & 1) == 0 || level >= lowestOddLevel) continue;
            lowestOddLevel = level;
        }
        while (highestLevel >= lowestOddLevel) {
            i = 0;
            block2: while (true) {
                if (i < len && levels[i] < highestLevel) {
                    ++i;
                    continue;
                }
                if ((begin = i++) == levels.length) break;
                while (i < len && levels[i] >= highestLevel) {
                    ++i;
                }
                end = i - 1;
                while (true) {
                    if (begin < end) ** break;
                    continue block2;
                    temp = objects[begin];
                    objects[begin] = objects[end];
                    objects[end] = temp;
                    ++begin;
                    --end;
                }
                break;
            }
            highestLevel = (byte)(highestLevel - 1);
        }
    }
}

