/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import sun.io.ConversionBufferFullException;
import sun.io.Converters;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

@Deprecated
public abstract class CharToByteConverter {
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};
    protected int charOff;
    protected int byteOff;
    protected int badInputLength;

    public static CharToByteConverter getDefault() {
        Object cvt = Converters.newDefaultConverter(1);
        return (CharToByteConverter)cvt;
    }

    public static CharToByteConverter getConverter(String encoding) throws UnsupportedEncodingException {
        Object cvt = Converters.newConverter(1, encoding);
        return (CharToByteConverter)cvt;
    }

    public abstract String getCharacterEncoding();

    public abstract int convert(char[] var1, int var2, int var3, byte[] var4, int var5, int var6) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException;

    public int convertAny(char[] input, int inStart, int inEnd, byte[] output, int outStart, int outEnd) throws ConversionBufferFullException {
        if (!this.subMode) {
            throw new IllegalStateException("Substitution mode is not on");
        }
        int localInOff = inStart;
        int localOutOff = outStart;
        while (localInOff < inEnd) {
            try {
                int discard = this.convert(input, localInOff, inEnd, output, localOutOff, outEnd);
                return this.nextByteIndex() - outStart;
            }
            catch (MalformedInputException e) {
                byte[] s = this.subBytes;
                int subSize = s.length;
                localOutOff = this.nextByteIndex();
                if (localOutOff + subSize > outEnd) {
                    throw new ConversionBufferFullException();
                }
                for (int i = 0; i < subSize; ++i) {
                    output[localOutOff++] = s[i];
                }
                localInOff = this.nextCharIndex();
                this.badInputLength = 0;
                if ((localInOff += this.badInputLength) < inEnd) continue;
                this.byteOff = localOutOff;
                return this.byteOff - outStart;
            }
            catch (UnknownCharacterException e) {
                throw new Error("UnknownCharacterException thrown in substititution mode", e);
            }
        }
        return this.nextByteIndex() - outStart;
    }

    public byte[] convertAll(char[] input) throws MalformedInputException {
        this.reset();
        boolean savedSubMode = this.subMode;
        this.subMode = true;
        byte[] output = new byte[this.getMaxBytesPerChar() * input.length];
        try {
            int outputLength = this.convert(input, 0, input.length, output, 0, output.length);
            byte[] returnedOutput = new byte[outputLength += this.flush(output, this.nextByteIndex(), output.length)];
            System.arraycopy(output, 0, returnedOutput, 0, outputLength);
            byte[] byArray = returnedOutput;
            return byArray;
        }
        catch (ConversionBufferFullException e) {
            throw new InternalError("this.getMaxBytesPerChar returned bad value");
        }
        catch (UnknownCharacterException e) {
            throw new InternalError();
        }
        finally {
            this.subMode = savedSubMode;
        }
    }

    public abstract int flush(byte[] var1, int var2, int var3) throws MalformedInputException, ConversionBufferFullException;

    public int flushAny(byte[] output, int outStart, int outEnd) throws ConversionBufferFullException {
        if (!this.subMode) {
            throw new IllegalStateException("Substitution mode is not on");
        }
        try {
            return this.flush(output, outStart, outEnd);
        }
        catch (MalformedInputException e) {
            int subSize = this.subBytes.length;
            byte[] s = this.subBytes;
            int outIndex = outStart;
            if (outStart + subSize > outEnd) {
                throw new ConversionBufferFullException();
            }
            for (int i = 0; i < subSize; ++i) {
                output[outIndex++] = s[i];
            }
            this.charOff = 0;
            this.byteOff = 0;
            this.badInputLength = 0;
            return subSize;
        }
    }

    public abstract void reset();

    public boolean canConvert(char c) {
        try {
            char[] input = new char[1];
            byte[] output = new byte[3];
            input[0] = c;
            this.convert(input, 0, 1, output, 0, 3);
            return true;
        }
        catch (CharConversionException e) {
            return false;
        }
    }

    public abstract int getMaxBytesPerChar();

    public int getBadInputLength() {
        return this.badInputLength;
    }

    public int nextCharIndex() {
        return this.charOff;
    }

    public int nextByteIndex() {
        return this.byteOff;
    }

    public void setSubstitutionMode(boolean doSub) {
        this.subMode = doSub;
    }

    public void setSubstitutionBytes(byte[] newSubBytes) throws IllegalArgumentException {
        if (newSubBytes.length > this.getMaxBytesPerChar()) {
            throw new IllegalArgumentException();
        }
        this.subBytes = new byte[newSubBytes.length];
        System.arraycopy(newSubBytes, 0, this.subBytes, 0, newSubBytes.length);
    }

    public String toString() {
        return "CharToByteConverter: " + this.getCharacterEncoding();
    }
}

