/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferAsIntBufferL;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;

class ByteBufferAsIntBufferRL
extends ByteBufferAsIntBufferL {
    ByteBufferAsIntBufferRL(ByteBuffer bb) {
        super(bb);
    }

    ByteBufferAsIntBufferRL(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {
        super(bb, mark, pos, lim, cap, off);
    }

    @Override
    public IntBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 2) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsIntBufferRL(this.bb, -1, 0, rem, rem, off);
    }

    @Override
    public IntBuffer duplicate() {
        return new ByteBufferAsIntBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public IntBuffer put(int x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer put(int i, int x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

