/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.service.aws;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.exceptions.ServiceAccessException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.service.HttpServiceResponseHandler;
import amazon.fws.clicommando.processors.service.ServiceCallConfig;
import amazon.fws.clicommando.processors.service.aws.AwsServiceCaller;
import amazon.fws.clicommando.security.AwsSignatureHelper;
import amazon.fws.clicommando.security.SignatureInfo;
import amazon.fws.clicommando.util.DateUtils;
import amazon.fws.clicommando.util.StringUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwsQueryCaller
extends AwsServiceCaller {
    public AwsQueryCaller(ServiceCallConfig awsCallConfig) {
        this.awsCallConfig = awsCallConfig;
    }

    @Override
    public void call(Command command) {
        Map<String, String> paramMap = this.awsCallConfig.getParameters();
        this.createBoilerplate(paramMap);
        String url = this.awsCallConfig.getServiceUrl();
        String method = this.awsCallConfig.getHttpMethod();
        AwsSignatureHelper sigHelp = new AwsSignatureHelper(url, method, command);
        String accessId = command.getCurrentCommandConfig().getParameter("AWSAccessKeyId").getValue();
        String secretKey = command.getCurrentCommandConfig().getParameter("AWSSecretKey").getValue();
        SignatureInfo signature = sigHelp.signParameters(paramMap, accessId, secretKey);
        paramMap.put(signature.getQueryParameterName(), signature.getSignature());
        String queryString = this.createQueryString(paramMap);
        this.callService(url, queryString, method, command);
    }

    private void createBoilerplate(Map<String, String> paramMap) {
        if (StringUtils.isEmpty(this.awsCallConfig.getServiceVersion())) {
            paramMap.remove("Version");
        } else {
            paramMap.put("Version", this.awsCallConfig.getServiceVersion());
        }
        paramMap.put("Action", this.awsCallConfig.getAction());
        paramMap.put("SignatureVersion", this.awsCallConfig.getSigVersion());
        if (this.awsCallConfig.getSigVersion().equals("1")) {
            paramMap.put("SignatureMethod", "HmacSHA1");
        } else if (this.awsCallConfig.getSigVersion().equals("2")) {
            paramMap.put("SignatureMethod", "HmacSHA256");
        } else if (this.awsCallConfig.getSigVersion().equals("4")) {
            paramMap.put("SignatureMethod", "HmacSHA256");
        } else {
            throw new ConfigurationErrorException("Unsupported signature version: got '" + this.awsCallConfig.getSigVersion() + "'");
        }
        if (this.awsCallConfig.getSigVersion().equals("1")) {
            paramMap.put("Timestamp", DateUtils.getFormattedTimestampV2());
        } else if (this.awsCallConfig.getSigVersion().equals("2")) {
            paramMap.put("Timestamp", DateUtils.getFormattedTimestampV2());
        } else if (this.awsCallConfig.getSigVersion().equals("4")) {
            paramMap.put("Timestamp", DateUtils.getFormattedTimestampV4());
        }
    }

    Proxy getProxy(URL connectionAddress) {
        String protocol = connectionAddress.getProtocol();
        String proxyHost = null;
        String proxyPort = null;
        if ("http".equals(protocol)) {
            proxyHost = System.getProperty("http.proxyHost");
            proxyPort = System.getProperty("http.proxyPort", "80");
        } else if ("https".equals(protocol)) {
            proxyHost = System.getProperty("https.proxyHost");
            proxyPort = System.getProperty("https.proxyPort", "443");
        }
        if (proxyHost == null) {
            return Proxy.NO_PROXY;
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort)));
    }

    void callService(String url, String queryString, String method, Command cmd) {
        String connectUrl;
        HttpURLConnection connection = null;
        String getUrl = url;
        try {
            URI uri = new URI(url);
            if (uri.getPath() == null || uri.getPath().isEmpty()) {
                getUrl = getUrl + "/";
            }
        }
        catch (URISyntaxException e1) {
            throw new BadInputException(ErrorMessages.ErrorCode.MALFORMED_URL, url);
        }
        getUrl = getUrl + "?" + queryString;
        if ("POST".equals(method)) {
            connectUrl = url;
            this.awsRequestUrl = connectUrl + "\n\nBEGIN POST request:\n" + queryString + "\nEND POST request";
        } else {
            this.awsRequestUrl = connectUrl = getUrl;
        }
        try {
            try {
                URL serverAddress = new URL(connectUrl);
                connection = (HttpURLConnection)serverAddress.openConnection(this.getProxy(serverAddress));
                connection.setRequestMethod(method);
                connection.setReadTimeout(this.awsCallConfig.getTimeout());
                connection.setConnectTimeout(this.awsCallConfig.getTimeout());
                cmd.getCurrentCommandConfig().setRequestUrl(getUrl);
                connection.setRequestProperty("User-Agent", this.awsCallConfig.getUserAgent());
                if ("POST".equals(method)) {
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    connection.setUseCaches(false);
                    connection.setDoInput(true);
                    connection.setDoOutput(true);
                    DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                    out.writeBytes(queryString);
                    out.flush();
                    out.close();
                } else {
                    connection.connect();
                }
                connection.getResponseCode();
                this.responseHandler = new HttpServiceResponseHandler(getUrl, connection, cmd);
            }
            catch (MalformedURLException e) {
                int loc = getUrl.indexOf("/");
                String displayedUrl = loc <= 0 ? getUrl.substring(0, 30) + "..." : getUrl.substring(0, loc);
                throw new BadInputException(ErrorMessages.ErrorCode.MALFORMED_URL, displayedUrl);
            }
            catch (ProtocolException e) {
                throw new InternalErrorException("Some protocol problem reaching: " + getUrl, e);
            }
            catch (SocketTimeoutException e) {
                throw new ServiceAccessException(e.getMessage(), ErrorMessages.ErrorCode.COMMAND_TIMEOUT, new String[0]);
            }
            catch (UnknownHostException uhe) {
                throw new BadInputException(ErrorMessages.ErrorCode.UNKNOWN_TARGET_URL, uhe.getLocalizedMessage());
            }
            catch (IOException e) {
                if (e.getMessage().contains("unable to find valid certification path to requested target") || e.getMessage().contains("No trusted certificate found")) {
                    throw new BadInputException(ErrorMessages.ErrorCode.SSL_NOT_AUTH, e.getLocalizedMessage());
                }
                if (e.getMessage().contains("Read timed out")) {
                    throw new ServiceAccessException(e.getMessage(), ErrorMessages.ErrorCode.COMMAND_TIMEOUT, new String[0]);
                }
                throw new ServiceAccessException(e.getMessage(), ErrorMessages.ErrorCode.ERROR_REACHING_AWS, e.getLocalizedMessage());
            }
            Object var12_17 = null;
            if (connection != null) {
                connection.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            if (connection != null) {
                connection.disconnect();
            }
            throw throwable;
        }
    }

    private String createQueryString(Map<String, String> paramMap) {
        StringBuilder urlBld = new StringBuilder("");
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            urlBld.append(entry.getKey() + "=" + AwsSignatureHelper.urlEncode(entry.getValue(), false) + "&");
        }
        if (urlBld.charAt(urlBld.length() - 1) == '&') {
            urlBld.deleteCharAt(urlBld.length() - 1);
        }
        return urlBld.toString();
    }
}

