/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.ForceInline;
import java.lang.invoke.InvokeGeneric;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.lang.invoke.SimpleMethodHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.util.Arrays;
import sun.invoke.empty.Empty;

class Invokers {
    private final MethodType targetType;
    private MethodHandle exactInvoker;
    private MethodHandle erasedInvoker;
    MethodHandle erasedInvokerWithDrops;
    private MethodHandle generalInvoker;
    private MethodHandle varargsInvoker;
    private final MethodHandle[] spreadInvokers;
    private MethodHandle uninitializedCallSite;
    private static MethodHandle THROW_UCS = null;
    private static final int GENERIC_INVOKER_SLOP = 2;
    private static final LambdaForm.NamedFunction NF_checkExactType;
    private static final LambdaForm.NamedFunction NF_checkGenericType;
    private static final LambdaForm.NamedFunction NF_asType;
    private static final LambdaForm.NamedFunction NF_getCallSiteTarget;

    Invokers(MethodType targetType) {
        this.targetType = targetType;
        this.spreadInvokers = new MethodHandle[targetType.parameterCount() + 1];
    }

    MethodHandle exactInvoker() {
        MethodHandle invoker = this.exactInvoker;
        if (invoker != null) {
            return invoker;
        }
        MethodType mtype = this.targetType;
        MethodType invokerType = mtype.invokerType();
        boolean MTYPE_ARG_APPENDED = true;
        if (mtype.parameterSlotCount() <= 252) {
            LambdaForm lform = Invokers.invokeForm(mtype, false, 10);
            invoker = BoundMethodHandle.bindSingle(invokerType, lform, mtype);
        } else {
            LambdaForm lform = Invokers.invokeForm(mtype, true, 10);
            invoker = SimpleMethodHandle.make(invokerType, lform);
        }
        assert (this.checkInvoker(invoker));
        this.exactInvoker = invoker;
        return invoker;
    }

    MethodHandle generalInvoker() {
        MethodHandle invoker = this.generalInvoker;
        if (invoker != null) {
            return invoker;
        }
        MethodType mtype = this.targetType;
        MethodType invokerType = mtype.invokerType();
        boolean MTYPE_ARG_APPENDED = true;
        if (mtype.parameterSlotCount() <= 251) {
            Invokers.prepareForGenericCall(mtype);
            LambdaForm lform = Invokers.invokeForm(mtype, false, 12);
            invoker = BoundMethodHandle.bindSingle(invokerType, lform, mtype);
        } else {
            LambdaForm lform = Invokers.invokeForm(mtype, true, 12);
            invoker = SimpleMethodHandle.make(invokerType, lform);
        }
        assert (this.checkInvoker(invoker));
        this.generalInvoker = invoker;
        return invoker;
    }

    MethodHandle makeBasicInvoker() {
        DirectMethodHandle invoker = DirectMethodHandle.make(Invokers.invokeBasicMethod(this.targetType));
        assert (this.targetType == this.targetType.basicType());
        assert (this.checkInvoker(invoker));
        return invoker;
    }

    static MemberName invokeBasicMethod(MethodType type) {
        type = type.basicType();
        String name = "invokeBasic";
        try {
            return MethodHandles.Lookup.IMPL_LOOKUP.resolveOrFail((byte)5, MethodHandle.class, name, type);
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError("JVM cannot find invoker for " + type, ex);
        }
    }

    private boolean checkInvoker(MethodHandle invoker) {
        assert (this.targetType.invokerType().equals((Object)invoker.type())) : Arrays.asList(this.targetType, this.targetType.invokerType(), invoker);
        assert (invoker.internalMemberName() == null || invoker.internalMemberName().getMethodType().equals((Object)this.targetType));
        assert (!invoker.isVarargsCollector());
        return true;
    }

    MethodHandle erasedInvoker() {
        MethodHandle xinvoker = this.exactInvoker();
        MethodHandle invoker = this.erasedInvoker;
        if (invoker != null) {
            return invoker;
        }
        MethodType erasedType = this.targetType.erase();
        this.erasedInvoker = invoker = xinvoker.asType(erasedType.invokerType());
        return invoker;
    }

    MethodHandle spreadInvoker(int leadingArgCount) {
        MethodHandle vaInvoker = this.spreadInvokers[leadingArgCount];
        if (vaInvoker != null) {
            return vaInvoker;
        }
        int spreadArgCount = this.targetType.parameterCount() - leadingArgCount;
        MethodType spreadInvokerType = this.targetType.replaceParameterTypes(leadingArgCount, this.targetType.parameterCount(), Object[].class);
        if (this.targetType.parameterSlotCount() <= 253) {
            MethodHandle genInvoker = this.generalInvoker();
            vaInvoker = genInvoker.asSpreader(Object[].class, spreadArgCount);
        } else {
            MethodHandle makeSpreader;
            MethodHandle arrayInvoker = MethodHandles.exactInvoker(spreadInvokerType);
            try {
                makeSpreader = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(MethodHandle.class, "asSpreader", MethodType.methodType(MethodHandle.class, Class.class, Integer.TYPE));
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
            makeSpreader = MethodHandles.insertArguments(makeSpreader, 1, Object[].class, spreadArgCount);
            vaInvoker = MethodHandles.filterArgument(arrayInvoker, 0, makeSpreader);
        }
        assert (vaInvoker.type().equals((Object)spreadInvokerType.invokerType()));
        this.spreadInvokers[leadingArgCount] = vaInvoker;
        return vaInvoker;
    }

    MethodHandle varargsInvoker() {
        MethodHandle vaInvoker = this.varargsInvoker;
        if (vaInvoker != null) {
            return vaInvoker;
        }
        this.varargsInvoker = vaInvoker = this.spreadInvoker(0).asType(MethodType.genericMethodType(0, true).invokerType());
        return vaInvoker;
    }

    MethodHandle uninitializedCallSite() {
        MethodHandle invoker = this.uninitializedCallSite;
        if (invoker != null) {
            return invoker;
        }
        if (this.targetType.parameterCount() > 0) {
            MethodType type0 = this.targetType.dropParameterTypes(0, this.targetType.parameterCount());
            Invokers invokers0 = type0.invokers();
            invoker = MethodHandles.dropArguments(invokers0.uninitializedCallSite(), 0, this.targetType.parameterList());
            assert (invoker.type().equals((Object)this.targetType));
            this.uninitializedCallSite = invoker;
            return invoker;
        }
        invoker = THROW_UCS;
        if (invoker == null) {
            try {
                THROW_UCS = invoker = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(CallSite.class, "uninitializedCallSite", MethodType.methodType(Empty.class));
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
        }
        invoker = MethodHandles.explicitCastArguments(invoker, MethodType.methodType(this.targetType.returnType()));
        invoker = invoker.dropArguments(this.targetType, 0, this.targetType.parameterCount());
        assert (invoker.type().equals((Object)this.targetType));
        this.uninitializedCallSite = invoker;
        return invoker;
    }

    public String toString() {
        return "Invokers" + this.targetType;
    }

    static MemberName exactInvokerMethod(MethodType mtype, Object[] appendixResult) {
        LambdaForm lform;
        boolean MTYPE_ARG_APPENDED = true;
        if (mtype.parameterSlotCount() <= 253) {
            lform = Invokers.invokeForm(mtype, false, 9);
            appendixResult[0] = mtype;
        } else {
            lform = Invokers.invokeForm(mtype, true, 9);
        }
        return lform.vmentry;
    }

    static MemberName genericInvokerMethod(MethodType mtype, Object[] appendixResult) {
        LambdaForm lform;
        boolean MTYPE_ARG_APPENDED = true;
        if (mtype.parameterSlotCount() <= 251) {
            lform = Invokers.invokeForm(mtype, false, 11);
            appendixResult[0] = mtype;
            Invokers.prepareForGenericCall(mtype);
        } else {
            lform = Invokers.invokeForm(mtype, true, 11);
        }
        return lform.vmentry;
    }

    private static LambdaForm invokeForm(MethodType mtype, boolean customized, int which) {
        MethodType outCallType;
        Object[] outArgs;
        MethodType mtypeArg;
        LambdaForm lform;
        String debugName;
        boolean isGeneric;
        boolean isLinker;
        boolean isCached;
        if (!customized) {
            mtype = mtype.basicType();
            isCached = true;
        } else {
            isCached = false;
        }
        switch (which) {
            case 9: {
                isLinker = true;
                isGeneric = false;
                debugName = "invokeExact_MT";
                break;
            }
            case 10: {
                isLinker = false;
                isGeneric = false;
                debugName = "exactInvoker";
                break;
            }
            case 11: {
                isLinker = true;
                isGeneric = true;
                debugName = "invoke_MT";
                break;
            }
            case 12: {
                isLinker = false;
                isGeneric = true;
                debugName = "invoker";
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        if (isCached && (lform = mtype.form().cachedLambdaForm(which)) != null) {
            return lform;
        }
        boolean THIS_MH = false;
        int CALL_MH = 0 + (isLinker ? 0 : 1);
        int ARG_BASE = CALL_MH + 1;
        int OUTARG_LIMIT = ARG_BASE + mtype.parameterCount();
        int INARG_LIMIT = OUTARG_LIMIT + (isLinker && !customized ? 1 : 0);
        int nameCursor = OUTARG_LIMIT;
        int MTYPE_ARG = customized ? -1 : nameCursor++;
        int CHECK_TYPE = nameCursor++;
        int LINKER_CALL = nameCursor++;
        MethodType invokerFormType = mtype.invokerType();
        if (isLinker) {
            if (!customized) {
                invokerFormType = invokerFormType.appendParameterTypes(MemberName.class);
            }
        } else {
            invokerFormType = invokerFormType.invokerType();
        }
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - INARG_LIMIT, invokerFormType);
        assert (names.length == nameCursor) : Arrays.asList(mtype, customized, which, nameCursor, names.length);
        if (MTYPE_ARG >= INARG_LIMIT) {
            assert (names[MTYPE_ARG] == null);
            names[MTYPE_ARG] = BoundMethodHandle.getSpeciesData("L").getterName(names[0], 0);
        }
        MethodType methodType = mtypeArg = customized ? mtype : names[MTYPE_ARG];
        if (!isGeneric) {
            names[CHECK_TYPE] = new LambdaForm.Name(NF_checkExactType, names[CALL_MH], mtypeArg);
            outArgs = Arrays.copyOfRange(names, CALL_MH, OUTARG_LIMIT, Object[].class);
            outCallType = mtype;
        } else if (customized) {
            names[CHECK_TYPE] = new LambdaForm.Name(NF_asType, names[CALL_MH], mtypeArg);
            outArgs = Arrays.copyOfRange(names, CALL_MH, OUTARG_LIMIT, Object[].class);
            outArgs[0] = names[CHECK_TYPE];
            outCallType = mtype;
        } else {
            names[CHECK_TYPE] = new LambdaForm.Name(NF_checkGenericType, names[CALL_MH], mtypeArg);
            boolean PREPEND_GAMH = false;
            boolean PREPEND_MT = true;
            int PREPEND_COUNT = 2;
            outArgs = Arrays.copyOfRange(names, CALL_MH, OUTARG_LIMIT + 2, Object[].class);
            System.arraycopy(outArgs, 0, outArgs, 2, outArgs.length - 2);
            outArgs[0] = names[CHECK_TYPE];
            outArgs[1] = mtypeArg;
            outCallType = mtype.insertParameterTypes(0, MethodType.class, MethodHandle.class);
        }
        names[LINKER_CALL] = new LambdaForm.Name(Invokers.invokeBasicMethod(outCallType), outArgs);
        lform = new LambdaForm(debugName, INARG_LIMIT, names);
        if (isLinker) {
            lform.compileToBytecode();
        }
        if (isCached) {
            lform = mtype.form().setCachedLambdaForm(which, lform);
        }
        return lform;
    }

    static WrongMethodTypeException newWrongMethodTypeException(MethodType actual, MethodType expected) {
        return new WrongMethodTypeException("expected " + expected + " but found " + actual);
    }

    @ForceInline
    static void checkExactType(Object mhObj, Object expectedObj) {
        MethodHandle mh = (MethodHandle)mhObj;
        MethodType expected = (MethodType)expectedObj;
        MethodType actual = mh.type();
        if (actual != expected) {
            throw Invokers.newWrongMethodTypeException(expected, actual);
        }
    }

    @ForceInline
    static Object checkGenericType(Object mhObj, Object expectedObj) {
        MethodHandle mh = (MethodHandle)mhObj;
        MethodType expected = (MethodType)expectedObj;
        MethodHandle gamh = expected.form().genericInvoker;
        if (gamh != null) {
            return gamh;
        }
        return Invokers.prepareForGenericCall(expected);
    }

    static MethodHandle prepareForGenericCall(MethodType mtype) {
        MethodTypeForm form = mtype.form();
        MethodHandle gamh = form.genericInvoker;
        if (gamh != null) {
            return gamh;
        }
        try {
            form.genericInvoker = gamh = InvokeGeneric.generalInvokerOf(form.erasedType);
            return gamh;
        }
        catch (Exception ex) {
            throw MethodHandleStatics.newInternalError("Exception while resolving inexact invoke", ex);
        }
    }

    static MemberName linkToCallSiteMethod(MethodType mtype) {
        LambdaForm lform = Invokers.callSiteForm(mtype);
        return lform.vmentry;
    }

    private static LambdaForm callSiteForm(MethodType mtype) {
        LambdaForm lform = (mtype = mtype.basicType()).form().cachedLambdaForm(13);
        if (lform != null) {
            return lform;
        }
        boolean ARG_BASE = false;
        int OUTARG_LIMIT = 0 + mtype.parameterCount();
        int INARG_LIMIT = OUTARG_LIMIT + 1;
        int nameCursor = OUTARG_LIMIT;
        int CSITE_ARG = nameCursor++;
        int CALL_MH = nameCursor++;
        int LINKER_CALL = nameCursor++;
        MethodType invokerFormType = mtype.appendParameterTypes(CallSite.class);
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - INARG_LIMIT, invokerFormType);
        assert (names.length == nameCursor);
        assert (names[CSITE_ARG] != null);
        names[CALL_MH] = new LambdaForm.Name(NF_getCallSiteTarget, names[CSITE_ARG]);
        boolean PREPEND_MH = false;
        boolean PREPEND_COUNT = true;
        Object[] outArgs = Arrays.copyOfRange(names, 0, OUTARG_LIMIT + 1, Object[].class);
        System.arraycopy(outArgs, 0, outArgs, 1, outArgs.length - 1);
        outArgs[0] = names[CALL_MH];
        names[LINKER_CALL] = new LambdaForm.Name(Invokers.invokeBasicMethod(mtype), outArgs);
        lform = new LambdaForm("linkToCallSite", INARG_LIMIT, names);
        lform.compileToBytecode();
        lform = mtype.form().setCachedLambdaForm(13, lform);
        return lform;
    }

    @ForceInline
    static Object getCallSiteTarget(Object site) {
        return ((CallSite)site).getTarget();
    }

    static {
        try {
            NF_checkExactType = new LambdaForm.NamedFunction(Invokers.class.getDeclaredMethod("checkExactType", Object.class, Object.class));
            NF_checkGenericType = new LambdaForm.NamedFunction(Invokers.class.getDeclaredMethod("checkGenericType", Object.class, Object.class));
            NF_asType = new LambdaForm.NamedFunction(MethodHandle.class.getDeclaredMethod("asType", MethodType.class));
            NF_getCallSiteTarget = new LambdaForm.NamedFunction(Invokers.class.getDeclaredMethod("getCallSiteTarget", Object.class));
            NF_checkExactType.resolve();
            NF_checkGenericType.resolve();
            NF_getCallSiteTarget.resolve();
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
    }
}

