/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.plaf.FontUIResource;
import sun.awt.FontConfiguration;
import sun.awt.motif.MFontConfiguration;
import sun.font.CompositeFont;
import sun.font.FcFontConfiguration;
import sun.font.FontAccess;
import sun.font.FontConfigManager;
import sun.font.FontUtilities;
import sun.font.NativeFont;
import sun.font.SunFontManager;
import sun.util.logging.PlatformLogger;

public class X11FontManager
extends SunFontManager {
    private static final int FOUNDRY_FIELD = 1;
    private static final int FAMILY_NAME_FIELD = 2;
    private static final int WEIGHT_NAME_FIELD = 3;
    private static final int SLANT_FIELD = 4;
    private static final int SETWIDTH_NAME_FIELD = 5;
    private static final int ADD_STYLE_NAME_FIELD = 6;
    private static final int PIXEL_SIZE_FIELD = 7;
    private static final int POINT_SIZE_FIELD = 8;
    private static final int RESOLUTION_X_FIELD = 9;
    private static final int RESOLUTION_Y_FIELD = 10;
    private static final int SPACING_FIELD = 11;
    private static final int AVERAGE_WIDTH_FIELD = 12;
    private static final int CHARSET_REGISTRY_FIELD = 13;
    private static final int CHARSET_ENCODING_FIELD = 14;
    private static Map fontNameMap = new HashMap();
    private static Map xlfdMap = new HashMap();
    private static Map xFontDirsMap;
    private static HashSet<String> fontConfigDirs;
    HashMap<String, String> oblmap = null;
    private static HashMap registeredDirs;
    private static String[] fontdirs;
    private static String[] defaultPlatformFont;
    private FontConfigManager fcManager = null;

    public static X11FontManager getInstance() {
        return (X11FontManager)SunFontManager.getInstance();
    }

    @Override
    public String getFileNameFromPlatformName(String platName) {
        if (platName.startsWith("/")) {
            return platName;
        }
        String fileName = null;
        String fontID = this.specificFontIDForName(platName);
        fileName = super.getFileNameFromPlatformName(platName);
        if (fileName != null) {
            if (this.isHeadless() && fileName.startsWith("-")) {
                return null;
            }
            if (fileName.startsWith("/")) {
                Vector<String> xVal = (Vector<String>)xlfdMap.get(fileName);
                if (xVal == null) {
                    if (this.getFontConfiguration().needToSearchForFile(fileName)) {
                        fileName = null;
                    }
                    if (fileName != null) {
                        xVal = new Vector<String>();
                        xVal.add(platName);
                        xlfdMap.put(fileName, xVal);
                    }
                } else if (!xVal.contains(platName)) {
                    xVal.add(platName);
                }
            }
            if (fileName != null) {
                fontNameMap.put(fontID, fileName);
                return fileName;
            }
        }
        if (fontID != null) {
            fileName = (String)fontNameMap.get(fontID);
            if (fileName == null && FontUtilities.isLinux && !X11FontManager.isOpenJDK()) {
                String oblkey;
                if (this.oblmap == null) {
                    this.initObliqueLucidaFontMap();
                }
                if ((oblkey = this.getObliqueLucidaFontID(fontID)) != null) {
                    fileName = this.oblmap.get(oblkey);
                }
            }
            if (!(this.fontPath != null || fileName != null && fileName.startsWith("/"))) {
                if (FontUtilities.debugFonts()) {
                    FontUtilities.getLogger().warning("** Registering all font paths because can't find file for " + platName);
                }
                this.fontPath = this.getPlatformFontPath(noType1Font);
                this.registerFontDirs(this.fontPath);
                if (FontUtilities.debugFonts()) {
                    FontUtilities.getLogger().warning("** Finished registering all font paths");
                }
                fileName = (String)fontNameMap.get(fontID);
            }
            if (fileName == null && !this.isHeadless()) {
                fileName = X11FontManager.getX11FontName(platName);
            }
            if (fileName == null) {
                fontID = this.switchFontIDForName(platName);
                fileName = (String)fontNameMap.get(fontID);
            }
            if (fileName != null) {
                fontNameMap.put(fontID, fileName);
            }
        }
        return fileName;
    }

    @Override
    protected String[] getNativeNames(String fontFileName, String platformName) {
        Vector nativeNames = (Vector)xlfdMap.get(fontFileName);
        if (nativeNames == null) {
            if (platformName == null) {
                return null;
            }
            String[] natNames = new String[]{platformName};
            return natNames;
        }
        int len = nativeNames.size();
        return nativeNames.toArray(new String[len]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void registerFontDir(String path) {
        block27: {
            if (FontUtilities.debugFonts()) {
                FontUtilities.getLogger().info("ParseFontDir " + path);
            }
            File fontsDotDir = new File(path + File.separator + "fonts.dir");
            InputStreamReader fr = null;
            try {
                if (!fontsDotDir.canRead()) break block27;
                fr = new FileReader(fontsDotDir);
                BufferedReader br = new BufferedReader(fr, 8192);
                StreamTokenizer st = new StreamTokenizer(br);
                st.eolIsSignificant(true);
                int ttype = st.nextToken();
                if (ttype == -2) {
                    int numEntries = (int)st.nval;
                    ttype = st.nextToken();
                    if (ttype == 10) {
                        st.resetSyntax();
                        st.wordChars(32, 127);
                        st.wordChars(160, 255);
                        st.whitespaceChars(0, 31);
                        for (int i = 0; i < numEntries && (ttype = st.nextToken()) != -1 && ttype == -3; ++i) {
                            int breakPos = st.sval.indexOf(32);
                            if (breakPos <= 0) {
                                ++numEntries;
                                ttype = st.nextToken();
                                if (ttype == 10) continue;
                                break;
                            }
                            if (st.sval.charAt(0) == '!') {
                                ++numEntries;
                                ttype = st.nextToken();
                                if (ttype == 10) continue;
                                break;
                            }
                            String fileName = st.sval.substring(0, breakPos);
                            int lastColon = fileName.lastIndexOf(58);
                            if (lastColon > 0) {
                                if (lastColon + 1 >= fileName.length()) continue;
                                fileName = fileName.substring(lastColon + 1);
                            }
                            String fontPart = st.sval.substring(breakPos + 1);
                            String fontID = this.specificFontIDForName(fontPart);
                            String sVal = (String)fontNameMap.get(fontID);
                            if (FontUtilities.debugFonts()) {
                                PlatformLogger logger = FontUtilities.getLogger();
                                logger.info("file=" + fileName + " xlfd=" + fontPart);
                                logger.info("fontID=" + fontID + " sVal=" + sVal);
                            }
                            String fullPath = null;
                            try {
                                File file = new File(path, fileName);
                                if (xFontDirsMap == null) {
                                    xFontDirsMap = new HashMap();
                                }
                                xFontDirsMap.put(fontID, path);
                                fullPath = file.getCanonicalPath();
                            }
                            catch (IOException e) {
                                fullPath = path + File.separator + fileName;
                            }
                            Vector<String> xVal = (Vector<String>)xlfdMap.get(fullPath);
                            if (FontUtilities.debugFonts()) {
                                FontUtilities.getLogger().info("fullPath=" + fullPath + " xVal=" + xVal);
                            }
                            if ((xVal == null || !xVal.contains(fontPart)) && sVal == null || !sVal.startsWith("/")) {
                                if (FontUtilities.debugFonts()) {
                                    FontUtilities.getLogger().info("Map fontID:" + fontID + "to file:" + fullPath);
                                }
                                fontNameMap.put(fontID, fullPath);
                                if (xVal == null) {
                                    xVal = new Vector<String>();
                                    xlfdMap.put(fullPath, xVal);
                                }
                                xVal.add(fontPart);
                            }
                            if ((ttype = st.nextToken()) != 10) break;
                        }
                    }
                }
                fr.close();
            }
            catch (IOException iOException) {
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public void loadFonts() {
        super.loadFonts();
        xFontDirsMap = null;
        xlfdMap = new HashMap(1);
        fontNameMap = new HashMap(1);
    }

    private String getObliqueLucidaFontID(String fontID) {
        if (fontID.startsWith("-lucidasans-medium-i-normal") || fontID.startsWith("-lucidasans-bold-i-normal") || fontID.startsWith("-lucidatypewriter-medium-i-normal") || fontID.startsWith("-lucidatypewriter-bold-i-normal")) {
            return fontID.substring(0, fontID.indexOf("-i-"));
        }
        return null;
    }

    private static String getX11FontName(String platName) {
        String xlfd = platName.replaceAll("%d", "*");
        if (NativeFont.fontExists(xlfd)) {
            return xlfd;
        }
        return null;
    }

    private void initObliqueLucidaFontMap() {
        this.oblmap = new HashMap();
        this.oblmap.put("-lucidasans-medium", jreLibDirName + "/fonts/LucidaSansRegular.ttf");
        this.oblmap.put("-lucidasans-bold", jreLibDirName + "/fonts/LucidaSansDemiBold.ttf");
        this.oblmap.put("-lucidatypewriter-medium", jreLibDirName + "/fonts/LucidaTypewriterRegular.ttf");
        this.oblmap.put("-lucidatypewriter-bold", jreLibDirName + "/fonts/LucidaTypewriterBold.ttf");
    }

    private boolean isHeadless() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return GraphicsEnvironment.isHeadless();
    }

    private String specificFontIDForName(String name) {
        int[] hPos = new int[14];
        int hyphenCnt = 1;
        int pos = 1;
        while (pos != -1 && hyphenCnt < 14) {
            if ((pos = name.indexOf(45, pos)) == -1) continue;
            hPos[hyphenCnt++] = pos++;
        }
        if (hyphenCnt != 14) {
            if (FontUtilities.debugFonts()) {
                FontUtilities.getLogger().severe("Font Configuration Font ID is malformed:" + name);
            }
            return name;
        }
        StringBuffer sb = new StringBuffer(name.substring(hPos[1], hPos[5]));
        sb.append(name.substring(hPos[12]));
        String retval = sb.toString().toLowerCase(Locale.ENGLISH);
        return retval;
    }

    private String switchFontIDForName(String name) {
        int[] hPos = new int[14];
        int hyphenCnt = 1;
        int pos = 1;
        while (pos != -1 && hyphenCnt < 14) {
            if ((pos = name.indexOf(45, pos)) == -1) continue;
            hPos[hyphenCnt++] = pos++;
        }
        if (hyphenCnt != 14) {
            if (FontUtilities.debugFonts()) {
                FontUtilities.getLogger().severe("Font Configuration Font ID is malformed:" + name);
            }
            return name;
        }
        String slant = name.substring(hPos[3] + 1, hPos[4]);
        String family = name.substring(hPos[1] + 1, hPos[2]);
        String registry = name.substring(hPos[12] + 1, hPos[13]);
        String encoding = name.substring(hPos[13] + 1);
        if (slant.equals("i")) {
            slant = "o";
        } else if (slant.equals("o")) {
            slant = "i";
        }
        if (family.equals("itc zapfdingbats") && registry.equals("sun") && encoding.equals("fontspecific")) {
            registry = "adobe";
        }
        StringBuffer sb = new StringBuffer(name.substring(hPos[1], hPos[3] + 1));
        sb.append(slant);
        sb.append(name.substring(hPos[4], hPos[5] + 1));
        sb.append(registry);
        sb.append(name.substring(hPos[13]));
        String retval = sb.toString().toLowerCase(Locale.ENGLISH);
        return retval;
    }

    public String getFileNameFromXLFD(String name) {
        String fileName = null;
        String fontID = this.specificFontIDForName(name);
        if (fontID != null) {
            fileName = (String)fontNameMap.get(fontID);
            if (fileName == null) {
                fontID = this.switchFontIDForName(name);
                fileName = (String)fontNameMap.get(fontID);
            }
            if (fileName == null) {
                fileName = this.getDefaultFontFile();
            }
        }
        return fileName;
    }

    @Override
    protected void registerFontDirs(String pathName) {
        StringTokenizer parser = new StringTokenizer(pathName, File.pathSeparator);
        try {
            while (parser.hasMoreTokens()) {
                String dirPath = parser.nextToken();
                if (dirPath == null || registeredDirs.containsKey(dirPath)) continue;
                registeredDirs.put(dirPath, null);
                this.registerFontDir(dirPath);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    protected void addFontToPlatformFontPath(String platformName) {
        String fontID;
        String dirName;
        this.getPlatformFontPathFromFontConfig();
        if (xFontDirsMap != null && (dirName = (String)xFontDirsMap.get(fontID = this.specificFontIDForName(platformName))) != null) {
            fontConfigDirs.add(dirName);
        }
    }

    private void getPlatformFontPathFromFontConfig() {
        if (fontConfigDirs == null) {
            fontConfigDirs = this.getFontConfiguration().getAWTFontPathSet();
            if (FontUtilities.debugFonts() && fontConfigDirs != null) {
                String[] names = fontConfigDirs.toArray(new String[0]);
                for (int i = 0; i < names.length; ++i) {
                    FontUtilities.getLogger().info("awtfontpath : " + names[i]);
                }
            }
        }
    }

    @Override
    protected void registerPlatformFontsUsedByFontConfiguration() {
        this.getPlatformFontPathFromFontConfig();
        if (fontConfigDirs == null) {
            return;
        }
        if (FontUtilities.isLinux) {
            fontConfigDirs.add(jreLibDirName + File.separator + "oblique-fonts");
        }
        fontdirs = fontConfigDirs.toArray(new String[0]);
    }

    @Override
    protected FontConfiguration createFontConfiguration() {
        FcFontConfiguration fcFontConfig;
        MFontConfiguration mFontConfig = new MFontConfiguration(this);
        if ((FontUtilities.isOpenSolaris || FontUtilities.isLinux && (!mFontConfig.foundOsSpecificFile() || !mFontConfig.fontFilesArePresent()) || FontUtilities.isSolaris && !mFontConfig.fontFilesArePresent()) && (fcFontConfig = new FcFontConfiguration(this)).init()) {
            return fcFontConfig;
        }
        mFontConfig.init();
        return mFontConfig;
    }

    @Override
    public FontConfiguration createFontConfiguration(boolean preferLocaleFonts, boolean preferPropFonts) {
        return new MFontConfiguration(this, preferLocaleFonts, preferPropFonts);
    }

    public synchronized native String getFontPathNative(boolean var1);

    @Override
    protected synchronized String getFontPath(boolean noType1Fonts) {
        this.isHeadless();
        return this.getFontPathNative(noType1Fonts);
    }

    @Override
    public String[] getDefaultPlatformFont() {
        if (defaultPlatformFont != null) {
            return defaultPlatformFont;
        }
        String[] info = new String[2];
        this.getFontConfigManager().initFontConfigFonts(false);
        FontConfigManager.FcCompFont[] fontConfigFonts = this.getFontConfigManager().getFontConfigFonts();
        for (int i = 0; i < fontConfigFonts.length; ++i) {
            if (!"sans".equals(fontConfigFonts[i].fcFamily) || 0 != fontConfigFonts[i].style) continue;
            info[0] = fontConfigFonts[i].firstFont.familyName;
            info[1] = fontConfigFonts[i].firstFont.fontFile;
            break;
        }
        if (info[0] == null) {
            if (fontConfigFonts.length > 0 && fontConfigFonts[0].firstFont.fontFile != null) {
                info[0] = fontConfigFonts[0].firstFont.familyName;
                info[1] = fontConfigFonts[0].firstFont.fontFile;
            } else {
                info[0] = "Dialog";
                info[1] = "/dialog.ttf";
            }
        }
        defaultPlatformFont = info;
        return defaultPlatformFont;
    }

    public synchronized FontConfigManager getFontConfigManager() {
        if (this.fcManager == null) {
            this.fcManager = new FontConfigManager();
        }
        return this.fcManager;
    }

    @Override
    protected FontUIResource getFontConfigFUIR(String family, int style, int size) {
        CompositeFont font2D = this.getFontConfigManager().getFontConfigFont(family, style);
        if (font2D == null) {
            return new FontUIResource(family, style, size);
        }
        FontUIResource fuir = new FontUIResource(font2D.getFamilyName(null), style, size);
        FontAccess.getFontAccess().setFont2D(fuir, font2D.handle);
        FontAccess.getFontAccess().setCreatedFont(fuir);
        return fuir;
    }

    static {
        fontConfigDirs = null;
        registeredDirs = new HashMap();
        fontdirs = null;
        defaultPlatformFont = null;
    }
}

