/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm;

public class ProfileDataVerifier {
    private static final int MAX_TAG_COUNT = 100;
    private static final int HEADER_SIZE = 128;
    private static final int TOC_OFFSET = 132;
    private static final int TOC_RECORD_SIZE = 12;
    private static final int PROFILE_FILE_SIGNATURE = 1633907568;

    public static void verify(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        if (data.length < 132) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        int size = ProfileDataVerifier.readInt32(data, 0);
        int tagCount = ProfileDataVerifier.readInt32(data, 128);
        if (tagCount < 0 || tagCount > 100) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        if (size < 132 + tagCount * 12 || size > data.length) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        int sig = ProfileDataVerifier.readInt32(data, 36);
        if (1633907568 != sig) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        for (int i = 0; i < tagCount; ++i) {
            int tag_offset = ProfileDataVerifier.getTagOffset(i, data);
            int tag_size = ProfileDataVerifier.getTagSize(i, data);
            if (tag_offset < 132 || tag_offset > size) {
                throw new IllegalArgumentException("Invalid ICC Profile Data");
            }
            if (tag_size >= 0 && tag_size <= Integer.MAX_VALUE - tag_offset && tag_size + tag_offset <= size) continue;
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
    }

    private static int getTagOffset(int idx, byte[] data) {
        int pos = 132 + idx * 12 + 4;
        return ProfileDataVerifier.readInt32(data, pos);
    }

    private static int getTagSize(int idx, byte[] data) {
        int pos = 132 + idx * 12 + 8;
        return ProfileDataVerifier.readInt32(data, pos);
    }

    private static int readInt32(byte[] data, int off) {
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            res <<= 8;
            res |= 0xFF & data[off++];
        }
        return res;
    }
}

