/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.jgss.GSSToken;
import sun.security.jgss.krb5.CipherHelper;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5Token;

abstract class MessageToken_v2
extends Krb5Token {
    protected static final int TOKEN_HEADER_SIZE = 16;
    private static final int TOKEN_ID_POS = 0;
    private static final int TOKEN_FLAG_POS = 2;
    private static final int TOKEN_EC_POS = 4;
    private static final int TOKEN_RRC_POS = 6;
    protected static final int CONFOUNDER_SIZE = 16;
    static final int KG_USAGE_ACCEPTOR_SEAL = 22;
    static final int KG_USAGE_ACCEPTOR_SIGN = 23;
    static final int KG_USAGE_INITIATOR_SEAL = 24;
    static final int KG_USAGE_INITIATOR_SIGN = 25;
    private static final int FLAG_SENDER_IS_ACCEPTOR = 1;
    private static final int FLAG_WRAP_CONFIDENTIAL = 2;
    private static final int FLAG_ACCEPTOR_SUBKEY = 4;
    private static final int FILLER = 255;
    private MessageTokenHeader tokenHeader = null;
    private int tokenId = 0;
    private int seqNumber;
    protected byte[] tokenData;
    protected int tokenDataLen;
    private int key_usage = 0;
    private int ec = 0;
    private int rrc = 0;
    byte[] checksum = null;
    private boolean confState = true;
    private boolean initiator = true;
    private boolean have_acceptor_subkey = false;
    CipherHelper cipherHelper = null;

    MessageToken_v2(int tokenId, Krb5Context context, byte[] tokenBytes, int tokenOffset, int tokenLen, MessageProp prop) throws GSSException {
        this(tokenId, context, new ByteArrayInputStream(tokenBytes, tokenOffset, tokenLen), prop);
    }

    MessageToken_v2(int tokenId, Krb5Context context, InputStream is, MessageProp prop) throws GSSException {
        this.init(tokenId, context);
        try {
            if (!this.confState) {
                prop.setPrivacy(false);
            }
            this.tokenHeader = new MessageTokenHeader(is, prop, tokenId);
            if (tokenId == 1284) {
                this.key_usage = !this.initiator ? 24 : 22;
            } else if (tokenId == 1028) {
                this.key_usage = !this.initiator ? 25 : 23;
            }
            int minSize = 0;
            minSize = tokenId == 1284 && prop.getPrivacy() ? 32 + this.cipherHelper.getChecksumLength() : this.cipherHelper.getChecksumLength();
            if (tokenId == 1028) {
                this.tokenDataLen = minSize;
                this.tokenData = new byte[minSize];
                MessageToken_v2.readFully(is, this.tokenData);
            } else {
                this.tokenDataLen = is.available();
                if (this.tokenDataLen >= minSize) {
                    this.tokenData = new byte[this.tokenDataLen];
                    MessageToken_v2.readFully(is, this.tokenData);
                } else {
                    byte[] tmp = new byte[minSize];
                    MessageToken_v2.readFully(is, tmp);
                    int more = is.available();
                    this.tokenDataLen = minSize + more;
                    this.tokenData = Arrays.copyOf(tmp, this.tokenDataLen);
                    MessageToken_v2.readFully(is, this.tokenData, minSize, more);
                }
            }
            if (tokenId == 1284) {
                this.rotate();
            }
            if (tokenId == 1028 || tokenId == 1284 && !prop.getPrivacy()) {
                int chkLen = this.cipherHelper.getChecksumLength();
                this.checksum = new byte[chkLen];
                System.arraycopy(this.tokenData, this.tokenDataLen - chkLen, this.checksum, 0, chkLen);
                if (tokenId == 1284 && !prop.getPrivacy() && chkLen != this.ec) {
                    throw new GSSException(10, -1, MessageToken_v2.getTokenName(tokenId) + ":" + "EC incorrect!");
                }
            }
        }
        catch (IOException e) {
            throw new GSSException(10, -1, MessageToken_v2.getTokenName(tokenId) + ":" + e.getMessage());
        }
    }

    public final int getTokenId() {
        return this.tokenId;
    }

    public final int getKeyUsage() {
        return this.key_usage;
    }

    public final boolean getConfState() {
        return this.confState;
    }

    public void genSignAndSeqNumber(MessageProp prop, byte[] data, int offset, int len) throws GSSException {
        int qop = prop.getQOP();
        if (qop != 0) {
            qop = 0;
            prop.setQOP(qop);
        }
        if (!this.confState) {
            prop.setPrivacy(false);
        }
        this.tokenHeader = new MessageTokenHeader(this.tokenId, prop.getPrivacy());
        if (this.tokenId == 1284) {
            this.key_usage = this.initiator ? 24 : 22;
        } else if (this.tokenId == 1028) {
            int n = this.key_usage = this.initiator ? 25 : 23;
        }
        if (this.tokenId == 1028 || !prop.getPrivacy() && this.tokenId == 1284) {
            this.checksum = this.getChecksum(data, offset, len);
        }
        if (!prop.getPrivacy() && this.tokenId == 1284) {
            byte[] tok_header = this.tokenHeader.getBytes();
            tok_header[4] = (byte)(this.checksum.length >>> 8);
            tok_header[5] = (byte)this.checksum.length;
        }
    }

    public final boolean verifySign(byte[] data, int offset, int len) throws GSSException {
        byte[] myChecksum = this.getChecksum(data, offset, len);
        return MessageDigest.isEqual(this.checksum, myChecksum);
    }

    private void rotate() {
        if (this.rrc % this.tokenDataLen != 0) {
            this.rrc %= this.tokenDataLen;
            byte[] newBytes = new byte[this.tokenDataLen];
            System.arraycopy(this.tokenData, this.rrc, newBytes, 0, this.tokenDataLen - this.rrc);
            System.arraycopy(this.tokenData, 0, newBytes, this.tokenDataLen - this.rrc, this.rrc);
            this.tokenData = newBytes;
        }
    }

    public final int getSequenceNumber() {
        return this.seqNumber;
    }

    byte[] getChecksum(byte[] data, int offset, int len) throws GSSException {
        byte[] tokenHeaderBytes = this.tokenHeader.getBytes();
        int conf_flag = tokenHeaderBytes[2] & 2;
        if (conf_flag == 0 && this.tokenId == 1284) {
            tokenHeaderBytes[4] = 0;
            tokenHeaderBytes[5] = 0;
            tokenHeaderBytes[6] = 0;
            tokenHeaderBytes[7] = 0;
        }
        return this.cipherHelper.calculateChecksum(tokenHeaderBytes, data, offset, len, this.key_usage);
    }

    MessageToken_v2(int tokenId, Krb5Context context) throws GSSException {
        this.init(tokenId, context);
        this.seqNumber = context.incrementMySequenceNumber();
    }

    private void init(int tokenId, Krb5Context context) throws GSSException {
        this.tokenId = tokenId;
        this.confState = context.getConfState();
        this.initiator = context.isInitiator();
        this.have_acceptor_subkey = context.getKeySrc() == 2;
        this.cipherHelper = context.getCipherHelper(null);
    }

    protected void encodeHeader(OutputStream os) throws IOException {
        this.tokenHeader.encode(os);
    }

    public abstract void encode(OutputStream var1) throws IOException;

    protected final byte[] getTokenHeader() {
        return this.tokenHeader.getBytes();
    }

    class MessageTokenHeader {
        private int tokenId;
        private byte[] bytes = new byte[16];

        public MessageTokenHeader(int tokenId, boolean conf) throws GSSException {
            this.tokenId = tokenId;
            this.bytes[0] = (byte)(tokenId >>> 8);
            this.bytes[1] = (byte)tokenId;
            int flags = 0;
            flags = (MessageToken_v2.this.initiator ? 0 : 1) | (conf && tokenId != 1028 ? 2 : 0) | (MessageToken_v2.this.have_acceptor_subkey ? 4 : 0);
            this.bytes[2] = (byte)flags;
            this.bytes[3] = -1;
            if (tokenId == 1284) {
                this.bytes[4] = 0;
                this.bytes[5] = 0;
                this.bytes[6] = 0;
                this.bytes[7] = 0;
            } else if (tokenId == 1028) {
                for (int i = 4; i < 8; ++i) {
                    this.bytes[i] = -1;
                }
            }
            GSSToken.writeBigEndian(MessageToken_v2.this.seqNumber, this.bytes, 12);
        }

        public MessageTokenHeader(InputStream is, MessageProp prop, int tokId) throws IOException, GSSException {
            GSSToken.readFully(is, this.bytes, 0, 16);
            this.tokenId = GSSToken.readInt(this.bytes, 0);
            if (this.tokenId != tokId) {
                throw new GSSException(10, -1, Krb5Token.getTokenName(this.tokenId) + ":" + "Defective Token ID!");
            }
            int flag = this.bytes[2] & 1;
            int acceptor_flag = MessageToken_v2.this.initiator ? 1 : 0;
            if (flag != acceptor_flag) {
                throw new GSSException(10, -1, Krb5Token.getTokenName(this.tokenId) + ":" + "Acceptor Flag Error!");
            }
            int conf_flag = this.bytes[2] & 2;
            if (conf_flag == 2 && this.tokenId == 1284) {
                prop.setPrivacy(true);
            } else {
                prop.setPrivacy(false);
            }
            if (this.tokenId == 1284) {
                if ((this.bytes[3] & 0xFF) != 255) {
                    throw new GSSException(10, -1, Krb5Token.getTokenName(this.tokenId) + ":" + "Defective Token Filler!");
                }
                MessageToken_v2.this.ec = GSSToken.readBigEndian(this.bytes, 4, 2);
                MessageToken_v2.this.rrc = GSSToken.readBigEndian(this.bytes, 6, 2);
            } else if (this.tokenId == 1028) {
                for (int i = 3; i < 8; ++i) {
                    if ((this.bytes[i] & 0xFF) == 255) continue;
                    throw new GSSException(10, -1, Krb5Token.getTokenName(this.tokenId) + ":" + "Defective Token Filler!");
                }
            }
            prop.setQOP(0);
            MessageToken_v2.this.seqNumber = GSSToken.readBigEndian(this.bytes, 0, 8);
        }

        public final void encode(OutputStream os) throws IOException {
            os.write(this.bytes);
        }

        public final int getTokenId() {
            return this.tokenId;
        }

        public final byte[] getBytes() {
            return this.bytes;
        }
    }
}

