/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.registry;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import sun.rmi.registry.RegistryImpl;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.UnicastRef2;
import sun.rmi.server.Util;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.tcp.TCPEndpoint;

public final class LocateRegistry {
    private LocateRegistry() {
    }

    public static Registry getRegistry() throws RemoteException {
        return LocateRegistry.getRegistry(null, 1099);
    }

    public static Registry getRegistry(int port) throws RemoteException {
        return LocateRegistry.getRegistry(null, port);
    }

    public static Registry getRegistry(String host) throws RemoteException {
        return LocateRegistry.getRegistry(host, 1099);
    }

    public static Registry getRegistry(String host, int port) throws RemoteException {
        return LocateRegistry.getRegistry(host, port, null);
    }

    public static Registry getRegistry(String host, int port, RMIClientSocketFactory csf) throws RemoteException {
        Object registry = null;
        if (port <= 0) {
            port = 1099;
        }
        if (host == null || host.length() == 0) {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                host = "";
            }
        }
        LiveRef liveRef = new LiveRef(new ObjID(0), new TCPEndpoint(host, port, csf, null), false);
        UnicastRef ref = csf == null ? new UnicastRef(liveRef) : new UnicastRef2(liveRef);
        return (Registry)Util.createProxy(RegistryImpl.class, ref, false);
    }

    public static Registry createRegistry(int port) throws RemoteException {
        return new RegistryImpl(port);
    }

    public static Registry createRegistry(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        return new RegistryImpl(port, csf, ssf);
    }
}

