/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AudioFormat {
    protected Encoding encoding;
    protected float sampleRate;
    protected int sampleSizeInBits;
    protected int channels;
    protected int frameSize;
    protected float frameRate;
    protected boolean bigEndian;
    private HashMap<String, Object> properties;

    public AudioFormat(Encoding encoding, float sampleRate, int sampleSizeInBits, int channels, int frameSize, float frameRate, boolean bigEndian) {
        this.encoding = encoding;
        this.sampleRate = sampleRate;
        this.sampleSizeInBits = sampleSizeInBits;
        this.channels = channels;
        this.frameSize = frameSize;
        this.frameRate = frameRate;
        this.bigEndian = bigEndian;
        this.properties = null;
    }

    public AudioFormat(Encoding encoding, float sampleRate, int sampleSizeInBits, int channels, int frameSize, float frameRate, boolean bigEndian, Map<String, Object> properties) {
        this(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian);
        this.properties = new HashMap<String, Object>(properties);
    }

    public AudioFormat(float sampleRate, int sampleSizeInBits, int channels, boolean signed, boolean bigEndian) {
        this(signed ? Encoding.PCM_SIGNED : Encoding.PCM_UNSIGNED, sampleRate, sampleSizeInBits, channels, channels == -1 || sampleSizeInBits == -1 ? -1 : (sampleSizeInBits + 7) / 8 * channels, sampleRate, bigEndian);
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public Map<String, Object> properties() {
        Map ret = this.properties == null ? new HashMap(0) : (Map)this.properties.clone();
        return Collections.unmodifiableMap(ret);
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public boolean matches(AudioFormat format) {
        return !(!format.getEncoding().equals(this.getEncoding()) || format.getChannels() != -1 && format.getChannels() != this.getChannels() || format.getSampleRate() != -1.0f && format.getSampleRate() != this.getSampleRate() || format.getSampleSizeInBits() != -1 && format.getSampleSizeInBits() != this.getSampleSizeInBits() || format.getFrameRate() != -1.0f && format.getFrameRate() != this.getFrameRate() || format.getFrameSize() != -1 && format.getFrameSize() != this.getFrameSize() || this.getSampleSizeInBits() > 8 && format.isBigEndian() != this.isBigEndian());
    }

    public String toString() {
        String sEncoding = "";
        if (this.getEncoding() != null) {
            sEncoding = this.getEncoding().toString() + " ";
        }
        String sSampleRate = this.getSampleRate() == -1.0f ? "unknown sample rate, " : "" + this.getSampleRate() + " Hz, ";
        String sSampleSizeInBits = (float)this.getSampleSizeInBits() == -1.0f ? "unknown bits per sample, " : "" + this.getSampleSizeInBits() + " bit, ";
        String sChannels = this.getChannels() == 1 ? "mono, " : (this.getChannels() == 2 ? "stereo, " : (this.getChannels() == -1 ? " unknown number of channels, " : "" + this.getChannels() + " channels, "));
        String sFrameSize = (float)this.getFrameSize() == -1.0f ? "unknown frame size, " : "" + this.getFrameSize() + " bytes/frame, ";
        String sFrameRate = "";
        if ((double)Math.abs(this.getSampleRate() - this.getFrameRate()) > 1.0E-5) {
            sFrameRate = this.getFrameRate() == -1.0f ? "unknown frame rate, " : this.getFrameRate() + " frames/second, ";
        }
        String sEndian = "";
        if ((this.getEncoding().equals(Encoding.PCM_SIGNED) || this.getEncoding().equals(Encoding.PCM_UNSIGNED)) && (this.getSampleSizeInBits() > 8 || this.getSampleSizeInBits() == -1)) {
            sEndian = this.isBigEndian() ? "big-endian" : "little-endian";
        }
        return sEncoding + sSampleRate + sSampleSizeInBits + sChannels + sFrameSize + sFrameRate + sEndian;
    }

    public static class Encoding {
        public static final Encoding PCM_SIGNED = new Encoding("PCM_SIGNED");
        public static final Encoding PCM_UNSIGNED = new Encoding("PCM_UNSIGNED");
        public static final Encoding PCM_FLOAT = new Encoding("PCM_FLOAT");
        public static final Encoding ULAW = new Encoding("ULAW");
        public static final Encoding ALAW = new Encoding("ALAW");
        private String name;

        public Encoding(String name) {
            this.name = name;
        }

        public final boolean equals(Object obj) {
            if (this.toString() == null) {
                return obj != null && obj.toString() == null;
            }
            if (obj instanceof Encoding) {
                return this.toString().equals(obj.toString());
            }
            return false;
        }

        public final int hashCode() {
            if (this.toString() == null) {
                return 0;
            }
            return this.toString().hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }
}

