/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class HostAddress
implements Cloneable {
    int addrType;
    byte[] address = null;
    private static InetAddress localInetAddress;
    private static final boolean DEBUG;
    private volatile int hashCode = 0;

    private HostAddress(int dummy) {
    }

    public Object clone() {
        HostAddress new_hostAddress = new HostAddress(0);
        new_hostAddress.addrType = this.addrType;
        if (this.address != null) {
            new_hostAddress.address = (byte[])this.address.clone();
        }
        return new_hostAddress;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.addrType;
            if (this.address != null) {
                for (int i = 0; i < this.address.length; ++i) {
                    result = 37 * result + this.address[i];
                }
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HostAddress)) {
            return false;
        }
        HostAddress h = (HostAddress)obj;
        if (this.addrType != h.addrType || this.address != null && h.address == null || this.address == null && h.address != null) {
            return false;
        }
        if (this.address != null && h.address != null) {
            if (this.address.length != h.address.length) {
                return false;
            }
            for (int i = 0; i < this.address.length; ++i) {
                if (this.address[i] == h.address[i]) continue;
                return false;
            }
        }
        return true;
    }

    private static synchronized InetAddress getLocalInetAddress() throws UnknownHostException {
        if (localInetAddress == null) {
            localInetAddress = InetAddress.getLocalHost();
        }
        if (localInetAddress == null) {
            throw new UnknownHostException();
        }
        return localInetAddress;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.addrType == 2 || this.addrType == 24) {
            return InetAddress.getByAddress(this.address);
        }
        return null;
    }

    private int getAddrType(InetAddress inetAddress) {
        int addressType = 0;
        if (inetAddress instanceof Inet4Address) {
            addressType = 2;
        } else if (inetAddress instanceof Inet6Address) {
            addressType = 24;
        }
        return addressType;
    }

    public HostAddress() throws UnknownHostException {
        InetAddress inetAddress = HostAddress.getLocalInetAddress();
        this.addrType = this.getAddrType(inetAddress);
        this.address = inetAddress.getAddress();
    }

    public HostAddress(int new_addrType, byte[] new_address) throws KrbApErrException, UnknownHostException {
        switch (new_addrType) {
            case 2: {
                if (new_address.length == 4) break;
                throw new KrbApErrException(0, "Invalid Internet address");
            }
            case 5: {
                if (new_address.length == 2) break;
                throw new KrbApErrException(0, "Invalid CHAOSnet address");
            }
            case 7: {
                break;
            }
            case 6: {
                if (new_address.length == 6) break;
                throw new KrbApErrException(0, "Invalid XNS address");
            }
            case 16: {
                if (new_address.length == 3) break;
                throw new KrbApErrException(0, "Invalid DDP address");
            }
            case 12: {
                if (new_address.length == 2) break;
                throw new KrbApErrException(0, "Invalid DECnet Phase IV address");
            }
            case 24: {
                if (new_address.length == 16) break;
                throw new KrbApErrException(0, "Invalid Internet IPv6 address");
            }
        }
        this.addrType = new_addrType;
        if (new_address != null) {
            this.address = (byte[])new_address.clone();
        }
        if (DEBUG && (this.addrType == 2 || this.addrType == 24)) {
            System.out.println("Host address is " + InetAddress.getByAddress(this.address));
        }
    }

    public HostAddress(InetAddress inetAddress) {
        this.addrType = this.getAddrType(inetAddress);
        this.address = inetAddress.getAddress();
    }

    public HostAddress(DerValue encoding) throws Asn1Exception, IOException {
        DerValue der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.addrType = der.getData().getBigInteger().intValue();
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.address = der.getData().getOctetString();
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(this.addrType);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        temp = new DerOutputStream();
        temp.putOctetString(this.address);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public static HostAddress parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new HostAddress(subDer);
    }

    static {
        DEBUG = Krb5.DEBUG;
    }
}

