/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Enumeration;
import java.util.Vector;

public class RenderableImageProducer
implements ImageProducer,
Runnable {
    RenderableImage rdblImage;
    RenderContext rc;
    Vector ics = new Vector();

    public RenderableImageProducer(RenderableImage rdblImage, RenderContext rc) {
        this.rdblImage = rdblImage;
        this.rc = rc;
    }

    public synchronized void setRenderContext(RenderContext rc) {
        this.rc = rc;
    }

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        if (!this.ics.contains(ic)) {
            this.ics.addElement(ic);
        }
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        return this.ics.contains(ic);
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        this.ics.removeElement(ic);
    }

    @Override
    public synchronized void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
        Thread thread = new Thread((Runnable)this, "RenderableImageProducer Thread");
        thread.start();
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    @Override
    public void run() {
        ImageConsumer ic;
        RenderedImage rdrdImage = this.rc != null ? this.rdblImage.createRendering(this.rc) : this.rdblImage.createDefaultRendering();
        ColorModel colorModel = rdrdImage.getColorModel();
        Raster raster = rdrdImage.getData();
        SampleModel sampleModel = raster.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (colorModel == null) {
            colorModel = ColorModel.getRGBdefault();
        }
        int minX = raster.getMinX();
        int minY = raster.getMinY();
        int width = raster.getWidth();
        int height = raster.getHeight();
        Enumeration icList = this.ics.elements();
        while (icList.hasMoreElements()) {
            ic = (ImageConsumer)icList.nextElement();
            ic.setDimensions(width, height);
            ic.setHints(30);
        }
        int[] pix = new int[width];
        int numBands = sampleModel.getNumBands();
        int[] tmpPixel = new int[numBands];
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                sampleModel.getPixel(i, j, tmpPixel, dataBuffer);
                pix[i] = colorModel.getDataElement(tmpPixel, 0);
            }
            icList = this.ics.elements();
            while (icList.hasMoreElements()) {
                ic = (ImageConsumer)icList.nextElement();
                ic.setPixels(0, j, width, 1, colorModel, pix, 0, width);
            }
        }
        icList = this.ics.elements();
        while (icList.hasMoreElements()) {
            ic = (ImageConsumer)icList.nextElement();
            ic.imageComplete(3);
        }
    }
}

