/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.Serializable;
import java.util.Vector;

public class ParameterBlock
implements Cloneable,
Serializable {
    protected Vector<Object> sources = new Vector();
    protected Vector<Object> parameters = new Vector();

    public ParameterBlock() {
    }

    public ParameterBlock(Vector<Object> sources) {
        this.setSources(sources);
    }

    public ParameterBlock(Vector<Object> sources, Vector<Object> parameters) {
        this.setSources(sources);
        this.setParameters(parameters);
    }

    public Object shallowClone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object clone() {
        ParameterBlock theClone;
        try {
            theClone = (ParameterBlock)super.clone();
        }
        catch (Exception e) {
            return null;
        }
        if (this.sources != null) {
            theClone.setSources((Vector)this.sources.clone());
        }
        if (this.parameters != null) {
            theClone.setParameters((Vector)this.parameters.clone());
        }
        return theClone;
    }

    public ParameterBlock addSource(Object source) {
        this.sources.addElement(source);
        return this;
    }

    public Object getSource(int index) {
        return this.sources.elementAt(index);
    }

    public ParameterBlock setSource(Object source, int index) {
        int newSize;
        int oldSize = this.sources.size();
        if (oldSize < (newSize = index + 1)) {
            this.sources.setSize(newSize);
        }
        this.sources.setElementAt(source, index);
        return this;
    }

    public RenderedImage getRenderedSource(int index) {
        return (RenderedImage)this.sources.elementAt(index);
    }

    public RenderableImage getRenderableSource(int index) {
        return (RenderableImage)this.sources.elementAt(index);
    }

    public int getNumSources() {
        return this.sources.size();
    }

    public Vector<Object> getSources() {
        return this.sources;
    }

    public void setSources(Vector<Object> sources) {
        this.sources = sources;
    }

    public void removeSources() {
        this.sources = new Vector();
    }

    public int getNumParameters() {
        return this.parameters.size();
    }

    public Vector<Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Vector<Object> parameters) {
        this.parameters = parameters;
    }

    public void removeParameters() {
        this.parameters = new Vector();
    }

    public ParameterBlock add(Object obj) {
        this.parameters.addElement(obj);
        return this;
    }

    public ParameterBlock add(byte b) {
        return this.add(new Byte(b));
    }

    public ParameterBlock add(char c) {
        return this.add(new Character(c));
    }

    public ParameterBlock add(short s) {
        return this.add(new Short(s));
    }

    public ParameterBlock add(int i) {
        return this.add(new Integer(i));
    }

    public ParameterBlock add(long l) {
        return this.add(new Long(l));
    }

    public ParameterBlock add(float f) {
        return this.add(new Float(f));
    }

    public ParameterBlock add(double d) {
        return this.add(new Double(d));
    }

    public ParameterBlock set(Object obj, int index) {
        int newSize;
        int oldSize = this.parameters.size();
        if (oldSize < (newSize = index + 1)) {
            this.parameters.setSize(newSize);
        }
        this.parameters.setElementAt(obj, index);
        return this;
    }

    public ParameterBlock set(byte b, int index) {
        return this.set(new Byte(b), index);
    }

    public ParameterBlock set(char c, int index) {
        return this.set(new Character(c), index);
    }

    public ParameterBlock set(short s, int index) {
        return this.set(new Short(s), index);
    }

    public ParameterBlock set(int i, int index) {
        return this.set(new Integer(i), index);
    }

    public ParameterBlock set(long l, int index) {
        return this.set(new Long(l), index);
    }

    public ParameterBlock set(float f, int index) {
        return this.set(new Float(f), index);
    }

    public ParameterBlock set(double d, int index) {
        return this.set(new Double(d), index);
    }

    public Object getObjectParameter(int index) {
        return this.parameters.elementAt(index);
    }

    public byte getByteParameter(int index) {
        return (Byte)this.parameters.elementAt(index);
    }

    public char getCharParameter(int index) {
        return ((Character)this.parameters.elementAt(index)).charValue();
    }

    public short getShortParameter(int index) {
        return (Short)this.parameters.elementAt(index);
    }

    public int getIntParameter(int index) {
        return (Integer)this.parameters.elementAt(index);
    }

    public long getLongParameter(int index) {
        return (Long)this.parameters.elementAt(index);
    }

    public float getFloatParameter(int index) {
        return ((Float)this.parameters.elementAt(index)).floatValue();
    }

    public double getDoubleParameter(int index) {
        return (Double)this.parameters.elementAt(index);
    }

    public Class[] getParamClasses() {
        int numParams = this.getNumParameters();
        Class[] classes = new Class[numParams];
        for (int i = 0; i < numParams; ++i) {
            Object obj = this.getObjectParameter(i);
            classes[i] = obj instanceof Byte ? Byte.TYPE : (obj instanceof Character ? Character.TYPE : (obj instanceof Short ? Short.TYPE : (obj instanceof Integer ? Integer.TYPE : (obj instanceof Long ? Long.TYPE : (obj instanceof Float ? Float.TYPE : (obj instanceof Double ? Double.TYPE : obj.getClass()))))));
        }
        return classes;
    }
}

