/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset;

import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.WebRowSetImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.Predicate;

public class FilteredRowSetImpl
extends WebRowSetImpl
implements Serializable,
Cloneable,
FilteredRowSet {
    private Predicate p;
    private boolean onInsertRow = false;
    static final long serialVersionUID = 6178454588413509360L;

    public FilteredRowSetImpl() throws SQLException {
    }

    public FilteredRowSetImpl(Hashtable env) throws SQLException {
        super(env);
    }

    @Override
    public void setFilter(Predicate p) throws SQLException {
        this.p = p;
    }

    @Override
    public Predicate getFilter() {
        return this.p;
    }

    @Override
    protected boolean internalNext() throws SQLException {
        boolean bool = false;
        for (int rows = this.getRow(); rows <= this.size(); ++rows) {
            bool = super.internalNext();
            if (this.p == null) {
                return bool;
            }
            if (this.p.evaluate(this)) break;
        }
        return bool;
    }

    @Override
    protected boolean internalPrevious() throws SQLException {
        boolean bool = false;
        for (int rows = this.getRow(); rows > 0; --rows) {
            bool = super.internalPrevious();
            if (this.p == null) {
                return bool;
            }
            if (this.p.evaluate(this)) break;
        }
        return bool;
    }

    @Override
    protected boolean internalFirst() throws SQLException {
        boolean bool = super.internalFirst();
        if (this.p == null) {
            return bool;
        }
        while (bool && !this.p.evaluate(this)) {
            bool = super.internalNext();
        }
        return bool;
    }

    @Override
    protected boolean internalLast() throws SQLException {
        boolean bool = super.internalLast();
        if (this.p == null) {
            return bool;
        }
        while (bool && !this.p.evaluate(this)) {
            bool = super.internalPrevious();
        }
        return bool;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        boolean retval;
        boolean bool = false;
        boolean boolval = false;
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.relative").toString());
        }
        if (rows > 0) {
            for (int i = 0; i < rows; ++i) {
                if (this.isAfterLast()) {
                    return false;
                }
                bool = this.internalNext();
            }
            retval = bool;
        } else {
            for (int j = rows; j < 0; ++j) {
                if (this.isBeforeFirst()) {
                    return false;
                }
                boolval = this.internalPrevious();
            }
            retval = boolval;
        }
        if (rows != 0) {
            this.notifyCursorMoved();
        }
        return retval;
    }

    @Override
    public boolean absolute(int rows) throws SQLException {
        boolean retval;
        boolean bool = false;
        if (rows == 0 || this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.absolute").toString());
        }
        if (rows > 0) {
            bool = this.internalFirst();
            for (int i = 0; i < rows - 1; ++i) {
                if (this.isAfterLast()) {
                    return false;
                }
                bool = this.internalNext();
            }
            retval = bool;
        } else {
            bool = this.internalLast();
            int j = rows;
            while (j + 1 < 0) {
                if (this.isBeforeFirst()) {
                    return false;
                }
                bool = this.internalPrevious();
                ++j;
            }
            retval = bool;
        }
        this.notifyCursorMoved();
        return retval;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.onInsertRow = true;
        super.moveToInsertRow();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateInt(columnIndex, x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateBoolean(columnIndex, x);
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateByte(columnIndex, x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateShort(columnIndex, x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateLong(columnIndex, x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)new Float(x), columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateFloat(columnIndex, x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)new Double(x), columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateDouble(columnIndex, x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateString(columnIndex, x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        boolean bool;
        String val = "";
        Byte[] obj_arr = new Byte[x.length];
        for (int i = 0; i < x.length; ++i) {
            obj_arr[i] = x[i];
            val = val.concat(obj_arr[i].toString());
        }
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)val, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateBytes(columnIndex, x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateDate(columnIndex, x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateTime(columnIndex, x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateTimestamp(columnIndex, x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate((Object)x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate(x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateObject(columnIndex, x);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        boolean bool;
        if (this.onInsertRow && this.p != null && !(bool = this.p.evaluate(x, columnIndex))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateObject(columnIndex, x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public void insertRow() throws SQLException {
        this.onInsertRow = false;
        super.insertRow();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

