/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifBorders;
import com.sun.java.swing.plaf.motif.MotifDesktopIconUI;
import com.sun.java.swing.plaf.motif.MotifInternalFrameTitlePane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class MotifInternalFrameUI
extends BasicInternalFrameUI {
    Color color;
    Color highlight;
    Color shadow;
    MotifInternalFrameTitlePane titlePane;
    @Deprecated
    protected KeyStroke closeMenuKey;

    public static ComponentUI createUI(JComponent w) {
        return new MotifInternalFrameUI((JInternalFrame)w);
    }

    public MotifInternalFrameUI(JInternalFrame w) {
        super(w);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.setColors((JInternalFrame)c);
    }

    @Override
    protected void installDefaults() {
        Border frameBorder = this.frame.getBorder();
        this.internalFrameLayout = this.createLayoutManager();
        this.frame.setLayout(this.internalFrameLayout);
        if (frameBorder == null || frameBorder instanceof UIResource) {
            this.frame.setBorder(new MotifBorders.InternalFrameBorder(this.frame));
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.closeMenuKey = KeyStroke.getKeyStroke(27, 0);
    }

    @Override
    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.frame);
        this.frame.setLayout(null);
        this.internalFrameLayout = null;
    }

    private JInternalFrame getFrame() {
        return this.frame;
    }

    @Override
    public JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new MotifInternalFrameTitlePane(w);
        return this.titlePane;
    }

    @Override
    public Dimension getMaximumSize(JComponent x) {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    @Override
    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        if (this.isKeyBindingRegistered()) {
            JInternalFrame.JDesktopIcon di = this.frame.getDesktopIcon();
            SwingUtilities.replaceUIActionMap(di, null);
            SwingUtilities.replaceUIInputMap(di, 2, null);
        }
    }

    @Override
    protected void setupMenuOpenKey() {
        super.setupMenuOpenKey();
        ActionMap map = SwingUtilities.getUIActionMap(this.frame);
        if (map != null) {
            map.put("showSystemMenu", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MotifInternalFrameUI.this.titlePane.showSystemMenu();
                }

                @Override
                public boolean isEnabled() {
                    return MotifInternalFrameUI.this.isKeyBindingActive();
                }
            });
        }
    }

    @Override
    protected void setupMenuCloseKey() {
        ActionMap diActionMap;
        Object[] bindings;
        JInternalFrame.JDesktopIcon di;
        InputMap diInputMap;
        ActionMap map = SwingUtilities.getUIActionMap(this.frame);
        if (map != null) {
            map.put("hideSystemMenu", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MotifInternalFrameUI.this.titlePane.hideSystemMenu();
                }

                @Override
                public boolean isEnabled() {
                    return MotifInternalFrameUI.this.isKeyBindingActive();
                }
            });
        }
        if ((diInputMap = SwingUtilities.getUIInputMap(di = this.frame.getDesktopIcon(), 2)) == null && (bindings = (Object[])UIManager.get("DesktopIcon.windowBindings")) != null) {
            diInputMap = LookAndFeel.makeComponentInputMap(di, bindings);
            SwingUtilities.replaceUIInputMap(di, 2, diInputMap);
        }
        if ((diActionMap = SwingUtilities.getUIActionMap(di)) == null) {
            diActionMap = new ActionMapUIResource();
            diActionMap.put("hideSystemMenu", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JInternalFrame.JDesktopIcon icon = MotifInternalFrameUI.this.getFrame().getDesktopIcon();
                    MotifDesktopIconUI micon = (MotifDesktopIconUI)icon.getUI();
                    micon.hideSystemMenu();
                }

                @Override
                public boolean isEnabled() {
                    return MotifInternalFrameUI.this.isKeyBindingActive();
                }
            });
            SwingUtilities.replaceUIActionMap(di, diActionMap);
        }
    }

    @Override
    protected void activateFrame(JInternalFrame f) {
        super.activateFrame(f);
        this.setColors(f);
    }

    @Override
    protected void deactivateFrame(JInternalFrame f) {
        this.setColors(f);
        super.deactivateFrame(f);
    }

    void setColors(JInternalFrame frame) {
        this.color = frame.isSelected() ? UIManager.getColor("InternalFrame.activeTitleBackground") : UIManager.getColor("InternalFrame.inactiveTitleBackground");
        this.highlight = this.color.brighter();
        this.shadow = this.color.darker().darker();
        this.titlePane.setColors(this.color, this.highlight, this.shadow);
    }
}

