/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;

public abstract class OpenType<T>
implements Serializable {
    static final long serialVersionUID = -9195195325186646468L;
    public static final List<String> ALLOWED_CLASSNAMES_LIST = Collections.unmodifiableList(Arrays.asList("java.lang.Void", "java.lang.Boolean", "java.lang.Character", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.String", "java.math.BigDecimal", "java.math.BigInteger", "java.util.Date", "javax.management.ObjectName", CompositeData.class.getName(), TabularData.class.getName()));
    @Deprecated
    public static final String[] ALLOWED_CLASSNAMES = ALLOWED_CLASSNAMES_LIST.toArray(new String[0]);
    private String className;
    private String description;
    private String typeName;
    private transient boolean isArray = false;
    private transient Descriptor descriptor;

    protected OpenType(String className, String typeName, String description) throws OpenDataException {
        this.checkClassNameOverride();
        this.typeName = OpenType.valid("typeName", typeName);
        this.description = OpenType.valid("description", description);
        this.className = OpenType.validClassName(className);
        this.isArray = this.className != null && this.className.startsWith("[");
    }

    OpenType(String className, String typeName, String description, boolean isArray) {
        this.className = OpenType.valid("className", className);
        this.typeName = OpenType.valid("typeName", typeName);
        this.description = OpenType.valid("description", description);
        this.isArray = isArray;
    }

    private void checkClassNameOverride() throws SecurityException {
        GetPropertyAction getExtendOpenTypes;
        if (this.getClass().getClassLoader() == null) {
            return;
        }
        if (OpenType.overridesGetClassName(this.getClass()) && AccessController.doPrivileged(getExtendOpenTypes = new GetPropertyAction("jmx.extend.open.types")) == null) {
            throw new SecurityException("Cannot override getClassName() unless -Djmx.extend.open.types");
        }
    }

    private static boolean overridesGetClassName(final Class<?> c) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    return c.getMethod("getClassName", new Class[0]).getDeclaringClass() != OpenType.class;
                }
                catch (Exception e) {
                    return true;
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String validClassName(String className) throws OpenDataException {
        String eltClassName;
        className = OpenType.valid("className", className);
        int n = 0;
        while (className.startsWith("[", n)) {
            ++n;
        }
        boolean isPrimitiveArray = false;
        if (n > 0) {
            if (className.startsWith("L", n) && className.endsWith(";")) {
                eltClassName = className.substring(n + 1, className.length() - 1);
            } else {
                if (n != className.length() - 1) throw new OpenDataException("Argument className=\"" + className + "\" is not a valid class name");
                eltClassName = className.substring(n, className.length());
                isPrimitiveArray = true;
            }
        } else {
            eltClassName = className;
        }
        boolean ok = false;
        ok = isPrimitiveArray ? ArrayType.isPrimitiveContentType(eltClassName) : ALLOWED_CLASSNAMES_LIST.contains(eltClassName);
        if (ok) return className;
        throw new OpenDataException("Argument className=\"" + className + "\" is not one of the allowed Java class names for open data.");
    }

    private static String valid(String argName, String argValue) {
        if (argValue == null || (argValue = argValue.trim()).equals("")) {
            throw new IllegalArgumentException("Argument " + argName + " cannot be null or empty");
        }
        return argValue;
    }

    synchronized Descriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new ImmutableDescriptor(new String[]{"openType"}, new Object[]{this});
        }
        return this.descriptor;
    }

    public String getClassName() {
        return this.className;
    }

    String safeGetClassName() {
        return this.className;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public abstract boolean isValue(Object var1);

    boolean isAssignableFrom(OpenType<?> ot) {
        return this.equals(ot);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String typeNameField;
        String descriptionField;
        String classNameField;
        this.checkClassNameOverride();
        ObjectInputStream.GetField fields = in.readFields();
        try {
            classNameField = OpenType.validClassName((String)fields.get("className", null));
            descriptionField = OpenType.valid("description", (String)fields.get("description", null));
            typeNameField = OpenType.valid("typeName", (String)fields.get("typeName", null));
        }
        catch (Exception e) {
            InvalidObjectException e2 = new InvalidObjectException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
        this.className = classNameField;
        this.description = descriptionField;
        this.typeName = typeNameField;
        this.isArray = this.className.startsWith("[");
    }
}

