/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Enumeration;

public class MulticastSocket
extends DatagramSocket {
    private boolean interfaceSet;
    private Object ttlLock = new Object();
    private Object infLock = new Object();
    private InetAddress infAddress = null;

    public MulticastSocket() throws IOException {
        this(new InetSocketAddress(0));
    }

    public MulticastSocket(int port) throws IOException {
        this(new InetSocketAddress(port));
    }

    public MulticastSocket(SocketAddress bindaddr) throws IOException {
        super((SocketAddress)null);
        this.setReuseAddress(true);
        if (bindaddr != null) {
            this.bind(bindaddr);
        }
    }

    @Deprecated
    public void setTTL(byte ttl) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setTTL(ttl);
    }

    public void setTimeToLive(int ttl) throws IOException {
        if (ttl < 0 || ttl > 255) {
            throw new IllegalArgumentException("ttl out of range");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setTimeToLive(ttl);
    }

    @Deprecated
    public byte getTTL() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.getImpl().getTTL();
    }

    public int getTimeToLive() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.getImpl().getTimeToLive();
    }

    public void joinGroup(InetAddress mcastaddr) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.checkAddress(mcastaddr, "joinGroup");
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkMulticast(mcastaddr);
        }
        if (!mcastaddr.isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        NetworkInterface defaultInterface = NetworkInterface.getDefault();
        if (!this.interfaceSet && defaultInterface != null) {
            this.setNetworkInterface(defaultInterface);
        }
        this.getImpl().join(mcastaddr);
    }

    public void leaveGroup(InetAddress mcastaddr) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.checkAddress(mcastaddr, "leaveGroup");
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkMulticast(mcastaddr);
        }
        if (!mcastaddr.isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        this.getImpl().leave(mcastaddr);
    }

    public void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (mcastaddr == null || !(mcastaddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        if (this.oldImpl) {
            throw new UnsupportedOperationException();
        }
        this.checkAddress(((InetSocketAddress)mcastaddr).getAddress(), "joinGroup");
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkMulticast(((InetSocketAddress)mcastaddr).getAddress());
        }
        if (!((InetSocketAddress)mcastaddr).getAddress().isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        this.getImpl().joinGroup(mcastaddr, netIf);
    }

    public void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (mcastaddr == null || !(mcastaddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        if (this.oldImpl) {
            throw new UnsupportedOperationException();
        }
        this.checkAddress(((InetSocketAddress)mcastaddr).getAddress(), "leaveGroup");
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkMulticast(((InetSocketAddress)mcastaddr).getAddress());
        }
        if (!((InetSocketAddress)mcastaddr).getAddress().isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        this.getImpl().leaveGroup(mcastaddr, netIf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterface(InetAddress inf) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.checkAddress(inf, "setInterface");
        Object object = this.infLock;
        synchronized (object) {
            this.getImpl().setOption(16, inf);
            this.infAddress = inf;
            this.interfaceSet = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getInterface() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object = this.infLock;
        synchronized (object) {
            InetAddress ia = (InetAddress)this.getImpl().getOption(16);
            if (this.infAddress == null) {
                return ia;
            }
            if (ia.equals(this.infAddress)) {
                return ia;
            }
            try {
                NetworkInterface ni = NetworkInterface.getByInetAddress(ia);
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!addr.equals(this.infAddress)) continue;
                    return this.infAddress;
                }
                this.infAddress = null;
                return ia;
            }
            catch (Exception e) {
                return ia;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetworkInterface(NetworkInterface netIf) throws SocketException {
        Object object = this.infLock;
        synchronized (object) {
            this.getImpl().setOption(31, netIf);
            this.infAddress = null;
            this.interfaceSet = true;
        }
    }

    public NetworkInterface getNetworkInterface() throws SocketException {
        NetworkInterface ni = (NetworkInterface)this.getImpl().getOption(31);
        if (ni.getIndex() == 0 || ni.getIndex() == -1) {
            InetAddress[] addrs = new InetAddress[]{InetAddress.anyLocalAddress()};
            return new NetworkInterface(addrs[0].getHostName(), 0, addrs);
        }
        return ni;
    }

    public void setLoopbackMode(boolean disable) throws SocketException {
        this.getImpl().setOption(18, (Object)disable);
    }

    public boolean getLoopbackMode() throws SocketException {
        return (Boolean)this.getImpl().getOption(18);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void send(DatagramPacket p, byte ttl) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.checkAddress(p.getAddress(), "send");
        Object object = this.ttlLock;
        synchronized (object) {
            DatagramPacket datagramPacket = p;
            synchronized (datagramPacket) {
                if (this.connectState == 0) {
                    SecurityManager security = System.getSecurityManager();
                    if (security != null) {
                        if (p.getAddress().isMulticastAddress()) {
                            security.checkMulticast(p.getAddress(), ttl);
                        } else {
                            security.checkConnect(p.getAddress().getHostAddress(), p.getPort());
                        }
                    }
                } else {
                    InetAddress packetAddress = null;
                    packetAddress = p.getAddress();
                    if (packetAddress == null) {
                        p.setAddress(this.connectedAddress);
                        p.setPort(this.connectedPort);
                    } else if (!packetAddress.equals(this.connectedAddress) || p.getPort() != this.connectedPort) {
                        throw new SecurityException("connected address and packet address differ");
                    }
                }
                byte dttl = this.getTTL();
                try {
                    if (ttl != dttl) {
                        this.getImpl().setTTL(ttl);
                    }
                    this.getImpl().send(p);
                }
                finally {
                    if (ttl != dttl) {
                        this.getImpl().setTTL(dttl);
                    }
                }
            }
        }
    }
}

