/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;

public class Role
implements Serializable {
    private static final long oldSerialVersionUID = -1959486389343113026L;
    private static final long newSerialVersionUID = -279985518429862552L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myName", String.class), new ObjectStreamField("myObjNameList", ArrayList.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", String.class), new ObjectStreamField("objectNameList", List.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private String name = null;
    private List<ObjectName> objectNameList = new ArrayList<ObjectName>();

    public Role(String roleName, List<ObjectName> roleValue) throws IllegalArgumentException {
        if (roleName == null || roleValue == null) {
            String excMsg = "Invalid parameter";
            throw new IllegalArgumentException(excMsg);
        }
        this.setRoleName(roleName);
        this.setRoleValue(roleValue);
    }

    public String getRoleName() {
        return this.name;
    }

    public List<ObjectName> getRoleValue() {
        return this.objectNameList;
    }

    public void setRoleName(String roleName) throws IllegalArgumentException {
        if (roleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        this.name = roleName;
    }

    public void setRoleValue(List<ObjectName> roleValue) throws IllegalArgumentException {
        if (roleValue == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        this.objectNameList = new ArrayList<ObjectName>(roleValue);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("role name: " + this.name + "; role value: ");
        Iterator<ObjectName> objNameIter = this.objectNameList.iterator();
        while (objNameIter.hasNext()) {
            ObjectName currObjName = objNameIter.next();
            result.append(currObjName.toString());
            if (!objNameIter.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public Object clone() {
        try {
            return new Role(this.name, this.objectNameList);
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    public static String roleValueToString(List<ObjectName> roleValue) throws IllegalArgumentException {
        if (roleValue == null) {
            String excMsg = "Invalid parameter";
            throw new IllegalArgumentException(excMsg);
        }
        StringBuilder result = new StringBuilder();
        for (ObjectName currObjName : roleValue) {
            if (result.length() > 0) {
                result.append("\n");
            }
            result.append(currObjName.toString());
        }
        return result.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField fields = in.readFields();
            this.name = (String)fields.get("myName", null);
            if (fields.defaulted("myName")) {
                throw new NullPointerException("myName");
            }
            this.objectNameList = (List)Util.cast(fields.get("myObjNameList", null));
            if (fields.defaulted("myObjNameList")) {
                throw new NullPointerException("myObjNameList");
            }
        } else {
            in.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("myName", this.name);
            fields.put("myObjNameList", this.objectNameList);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -1959486389343113026L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -279985518429862552L;
        }
    }
}

