/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DetachVolumeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DetachVolumeRequestMarshaller
implements Marshaller<Request<DetachVolumeRequest>, DetachVolumeRequest> {
    public Request<DetachVolumeRequest> marshall(DetachVolumeRequest detachVolumeRequest) {
        if (detachVolumeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachVolumeRequest, "AmazonEC2");
        request.addParameter("Action", "DetachVolume");
        request.addParameter("Version", "2014-10-01");
        if (detachVolumeRequest.isDryRun() != null) {
            request.addParameter("DryRun", StringUtils.fromBoolean((Boolean)detachVolumeRequest.isDryRun()));
        }
        if (detachVolumeRequest.getVolumeId() != null) {
            request.addParameter("VolumeId", StringUtils.fromString((String)detachVolumeRequest.getVolumeId()));
        }
        if (detachVolumeRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)detachVolumeRequest.getInstanceId()));
        }
        if (detachVolumeRequest.getDevice() != null) {
            request.addParameter("Device", StringUtils.fromString((String)detachVolumeRequest.getDevice()));
        }
        if (detachVolumeRequest.isForce() != null) {
            request.addParameter("Force", StringUtils.fromBoolean((Boolean)detachVolumeRequest.isForce()));
        }
        return request;
    }
}

