/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.IllegalChannelGroupException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import sun.nio.ch.AixPollPort;
import sun.nio.ch.Port;
import sun.nio.ch.ThreadPool;
import sun.nio.ch.UnixAsynchronousServerSocketChannelImpl;
import sun.nio.ch.UnixAsynchronousSocketChannelImpl;

public class AixAsynchronousChannelProvider
extends AsynchronousChannelProvider {
    private static volatile AixPollPort defaultPort;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AixPollPort defaultEventPort() throws IOException {
        if (defaultPort != null) return defaultPort;
        Class<AixAsynchronousChannelProvider> clazz = AixAsynchronousChannelProvider.class;
        synchronized (AixAsynchronousChannelProvider.class) {
            if (defaultPort != null) return defaultPort;
            defaultPort = new AixPollPort(this, ThreadPool.getDefault()).start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultPort;
        }
    }

    @Override
    public AsynchronousChannelGroup openAsynchronousChannelGroup(int nThreads, ThreadFactory factory) throws IOException {
        return new AixPollPort(this, ThreadPool.create(nThreads, factory)).start();
    }

    @Override
    public AsynchronousChannelGroup openAsynchronousChannelGroup(ExecutorService executor, int initialSize) throws IOException {
        return new AixPollPort(this, ThreadPool.wrap(executor, initialSize)).start();
    }

    private Port toPort(AsynchronousChannelGroup group) throws IOException {
        if (group == null) {
            return this.defaultEventPort();
        }
        if (!(group instanceof AixPollPort)) {
            throw new IllegalChannelGroupException();
        }
        return (Port)group;
    }

    @Override
    public AsynchronousServerSocketChannel openAsynchronousServerSocketChannel(AsynchronousChannelGroup group) throws IOException {
        return new UnixAsynchronousServerSocketChannelImpl(this.toPort(group));
    }

    @Override
    public AsynchronousSocketChannel openAsynchronousSocketChannel(AsynchronousChannelGroup group) throws IOException {
        return new UnixAsynchronousSocketChannelImpl(this.toPort(group));
    }
}

