/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

public class RowFilter {
    private static final int abs(int x) {
        return x < 0 ? -x : x;
    }

    protected static int subFilter(byte[] currRow, byte[] subFilteredRow, int bytesPerPixel, int bytesPerRow) {
        int badness = 0;
        for (int i = bytesPerPixel; i < bytesPerRow + bytesPerPixel; ++i) {
            int curr = currRow[i] & 0xFF;
            int left = currRow[i - bytesPerPixel] & 0xFF;
            int difference = curr - left;
            subFilteredRow[i] = (byte)difference;
            badness += RowFilter.abs(difference);
        }
        return badness;
    }

    protected static int upFilter(byte[] currRow, byte[] prevRow, byte[] upFilteredRow, int bytesPerPixel, int bytesPerRow) {
        int badness = 0;
        for (int i = bytesPerPixel; i < bytesPerRow + bytesPerPixel; ++i) {
            int curr = currRow[i] & 0xFF;
            int up = prevRow[i] & 0xFF;
            int difference = curr - up;
            upFilteredRow[i] = (byte)difference;
            badness += RowFilter.abs(difference);
        }
        return badness;
    }

    protected final int paethPredictor(int a, int b, int c) {
        int p = a + b - c;
        int pa = RowFilter.abs(p - a);
        int pb = RowFilter.abs(p - b);
        int pc = RowFilter.abs(p - c);
        if (pa <= pb && pa <= pc) {
            return a;
        }
        if (pb <= pc) {
            return b;
        }
        return c;
    }

    public int filterRow(int colorType, byte[] currRow, byte[] prevRow, byte[][] scratchRows, int bytesPerRow, int bytesPerPixel) {
        int up;
        int left;
        int curr;
        int i;
        int badness;
        if (colorType != 3) {
            System.arraycopy(currRow, bytesPerPixel, scratchRows[0], bytesPerPixel, bytesPerRow);
            return 0;
        }
        int[] filterBadness = new int[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            filterBadness[i2] = Integer.MAX_VALUE;
        }
        int badness2 = 0;
        for (int i3 = bytesPerPixel; i3 < bytesPerRow + bytesPerPixel; ++i3) {
            int curr2 = currRow[i3] & 0xFF;
            badness2 += curr2;
        }
        filterBadness[0] = badness2;
        byte[] subFilteredRow = scratchRows[1];
        filterBadness[1] = badness = RowFilter.subFilter(currRow, subFilteredRow, bytesPerPixel, bytesPerRow);
        byte[] upFilteredRow = scratchRows[2];
        filterBadness[2] = badness = RowFilter.upFilter(currRow, prevRow, upFilteredRow, bytesPerPixel, bytesPerRow);
        byte[] averageFilteredRow = scratchRows[3];
        badness = 0;
        for (i = bytesPerPixel; i < bytesPerRow + bytesPerPixel; ++i) {
            curr = currRow[i] & 0xFF;
            left = currRow[i - bytesPerPixel] & 0xFF;
            up = prevRow[i] & 0xFF;
            int difference = curr - (left + up) / 2;
            averageFilteredRow[i] = (byte)difference;
            badness += RowFilter.abs(difference);
        }
        filterBadness[3] = badness;
        byte[] paethFilteredRow = scratchRows[4];
        badness = 0;
        for (i = bytesPerPixel; i < bytesPerRow + bytesPerPixel; ++i) {
            curr = currRow[i] & 0xFF;
            left = currRow[i - bytesPerPixel] & 0xFF;
            up = prevRow[i] & 0xFF;
            int upleft = prevRow[i - bytesPerPixel] & 0xFF;
            int predictor = this.paethPredictor(left, up, upleft);
            int difference = curr - predictor;
            paethFilteredRow[i] = (byte)difference;
            badness += RowFilter.abs(difference);
        }
        filterBadness[4] = badness;
        int minBadness = filterBadness[0];
        int filterType = 0;
        for (i = 1; i < 5; ++i) {
            if (filterBadness[i] >= minBadness) continue;
            minBadness = filterBadness[i];
            filterType = i;
        }
        if (filterType == 0) {
            System.arraycopy(currRow, bytesPerPixel, scratchRows[0], bytesPerPixel, bytesPerRow);
        }
        return filterType;
    }
}

