/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jdp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.management.jdp.JdpException;
import sun.management.jdp.JdpGenericPacket;

public final class JdpPacketReader {
    private final DataInputStream pkt;
    private Map<String, String> pmap = null;

    public JdpPacketReader(byte[] packet) throws JdpException {
        ByteArrayInputStream bais = new ByteArrayInputStream(packet);
        this.pkt = new DataInputStream(bais);
        try {
            int magic = this.pkt.readInt();
            JdpGenericPacket.checkMagic(magic);
        }
        catch (IOException e) {
            throw new JdpException("Invalid JDP packet received, bad magic");
        }
        try {
            short version = this.pkt.readShort();
            JdpGenericPacket.checkVersion(version);
        }
        catch (IOException e) {
            throw new JdpException("Invalid JDP packet received, bad protocol version");
        }
    }

    public String getEntry() throws EOFException, JdpException {
        try {
            short len = this.pkt.readShort();
            if (len < 1 && len > this.pkt.available()) {
                throw new JdpException("Broken JDP packet. Invalid entry length field.");
            }
            byte[] b = new byte[len];
            if (this.pkt.read(b) != len) {
                throw new JdpException("Broken JDP packet. Unable to read entry.");
            }
            return new String(b, "UTF-8");
        }
        catch (EOFException e) {
            throw e;
        }
        catch (UnsupportedEncodingException ex) {
            throw new JdpException("Broken JDP packet. Unable to decode entry.");
        }
        catch (IOException e) {
            throw new JdpException("Broken JDP packet. Unable to read entry.");
        }
    }

    public Map<String, String> getDiscoveryDataAsMap() throws JdpException {
        if (this.pmap != null) {
            return this.pmap;
        }
        String key = null;
        String value = null;
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        try {
            while (true) {
                key = this.getEntry();
                value = this.getEntry();
                tmpMap.put(key, value);
            }
        }
        catch (EOFException e) {
            if (value == null) {
                throw new JdpException("Broken JDP packet. Key without value." + key);
            }
            this.pmap = Collections.unmodifiableMap(tmpMap);
            return this.pmap;
        }
    }
}

