/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.Util;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;

final class PerInterface<M> {
    private final Class<?> mbeanInterface;
    private final MBeanIntrospector<M> introspector;
    private final MBeanInfo mbeanInfo;
    private final Map<String, M> getters = Util.newMap();
    private final Map<String, M> setters = Util.newMap();
    private final Map<String, List<MethodAndSig>> ops = Util.newMap();

    PerInterface(Class<?> mbeanInterface, MBeanIntrospector<M> introspector, MBeanAnalyzer<M> analyzer, MBeanInfo mbeanInfo) {
        this.mbeanInterface = mbeanInterface;
        this.introspector = introspector;
        this.mbeanInfo = mbeanInfo;
        analyzer.visit(new InitMaps());
    }

    Class<?> getMBeanInterface() {
        return this.mbeanInterface;
    }

    MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    boolean isMXBean() {
        return this.introspector.isMXBean();
    }

    Object getAttribute(Object resource, String attribute, Object cookie) throws AttributeNotFoundException, MBeanException, ReflectionException {
        M cm = this.getters.get(attribute);
        if (cm == null) {
            String msg = this.setters.containsKey(attribute) ? "Write-only attribute: " + attribute : "No such attribute: " + attribute;
            throw new AttributeNotFoundException(msg);
        }
        return this.introspector.invokeM(cm, resource, null, cookie);
    }

    void setAttribute(Object resource, String attribute, Object value, Object cookie) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        M cm = this.setters.get(attribute);
        if (cm == null) {
            String msg = this.getters.containsKey(attribute) ? "Read-only attribute: " + attribute : "No such attribute: " + attribute;
            throw new AttributeNotFoundException(msg);
        }
        this.introspector.invokeSetter(attribute, cm, resource, value, cookie);
    }

    Object invoke(Object resource, String operation, Object[] params, String[] signature, Object cookie) throws MBeanException, ReflectionException {
        List<MethodAndSig> list = this.ops.get(operation);
        if (list == null) {
            String msg = "No such operation: " + operation;
            return this.noSuchMethod(msg, resource, operation, params, signature, cookie);
        }
        if (signature == null) {
            signature = new String[]{};
        }
        MethodAndSig found = null;
        for (MethodAndSig mas : list) {
            if (!Arrays.equals(mas.signature, signature)) continue;
            found = mas;
            break;
        }
        if (found == null) {
            String badSig = this.sigString(signature);
            String msg = list.size() == 1 ? "Signature mismatch for operation " + operation + ": " + badSig + " should be " + this.sigString(list.get((int)0).signature) : "Operation " + operation + " exists but not with " + "this signature: " + badSig;
            return this.noSuchMethod(msg, resource, operation, params, signature, cookie);
        }
        return this.introspector.invokeM(found.method, resource, params, cookie);
    }

    private Object noSuchMethod(String msg, Object resource, String operation, Object[] params, String[] signature, Object cookie) throws MBeanException, ReflectionException {
        String attrName;
        M method;
        String invokeGettersS;
        NoSuchMethodException nsme = new NoSuchMethodException(operation + this.sigString(signature));
        ReflectionException exception = new ReflectionException(nsme, msg);
        if (this.introspector.isMXBean()) {
            throw exception;
        }
        GetPropertyAction act = new GetPropertyAction("jmx.invoke.getters");
        try {
            invokeGettersS = AccessController.doPrivileged(act);
        }
        catch (Exception e) {
            invokeGettersS = null;
        }
        if (invokeGettersS == null) {
            throw exception;
        }
        int rest = 0;
        Map<String, M> methods = null;
        if (signature == null || signature.length == 0) {
            if (operation.startsWith("get")) {
                rest = 3;
            } else if (operation.startsWith("is")) {
                rest = 2;
            }
            if (rest != 0) {
                methods = this.getters;
            }
        } else if (signature.length == 1 && operation.startsWith("set")) {
            rest = 3;
            methods = this.setters;
        }
        if (rest != 0 && (method = methods.get(attrName = operation.substring(rest))) != null && this.introspector.getName(method).equals(operation)) {
            Object[] msig = this.introspector.getSignature(method);
            if (signature == null && msig.length == 0 || Arrays.equals(signature, msig)) {
                return this.introspector.invokeM(method, resource, params, cookie);
            }
        }
        throw exception;
    }

    private String sigString(String[] signature) {
        StringBuilder b = new StringBuilder("(");
        if (signature != null) {
            for (String s : signature) {
                if (b.length() > 1) {
                    b.append(", ");
                }
                b.append(s);
            }
        }
        return b.append(")").toString();
    }

    private class MethodAndSig {
        M method;
        String[] signature;

        private MethodAndSig() {
        }
    }

    private class InitMaps
    implements MBeanAnalyzer.MBeanVisitor<M> {
        private InitMaps() {
        }

        @Override
        public void visitAttribute(String attributeName, M getter, M setter) {
            Object old;
            if (getter != null) {
                PerInterface.this.introspector.checkMethod(getter);
                old = PerInterface.this.getters.put(attributeName, getter);
                assert (old == null);
            }
            if (setter != null) {
                PerInterface.this.introspector.checkMethod(setter);
                old = PerInterface.this.setters.put(attributeName, setter);
                assert (old == null);
            }
        }

        @Override
        public void visitOperation(String operationName, M operation) {
            PerInterface.this.introspector.checkMethod(operation);
            String[] sig = PerInterface.this.introspector.getSignature(operation);
            MethodAndSig mas = new MethodAndSig();
            mas.method = operation;
            mas.signature = sig;
            List<MethodAndSig> list = (List<MethodAndSig>)PerInterface.this.ops.get(operationName);
            if (list == null) {
                list = Collections.singletonList(mas);
            } else {
                if (list.size() == 1) {
                    list = Util.newList(list);
                }
                list.add(mas);
            }
            PerInterface.this.ops.put(operationName, list);
        }
    }
}

