/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.protocol.http.HttpCallerInfo;
import sun.net.www.protocol.http.NegotiateAuthentication;
import sun.security.action.GetPropertyAction;

public class AuthenticationHeader {
    MessageHeader rsp;
    HeaderParser preferred;
    String preferred_r;
    private final HttpCallerInfo hci;
    boolean dontUseNegotiate = false;
    static String authPref = null;
    String hdrname;
    HashMap<String, SchemeMapValue> schemes;

    public String toString() {
        return "AuthenticationHeader: prefer " + this.preferred_r;
    }

    public AuthenticationHeader(String hdrname, MessageHeader response, HttpCallerInfo hci, boolean dontUseNegotiate) {
        this(hdrname, response, hci, dontUseNegotiate, Collections.emptySet());
    }

    public AuthenticationHeader(String hdrname, MessageHeader response, HttpCallerInfo hci, boolean dontUseNegotiate, Set<String> disabledSchemes) {
        this.hci = hci;
        this.dontUseNegotiate = dontUseNegotiate;
        this.rsp = response;
        this.hdrname = hdrname;
        this.schemes = new HashMap();
        this.parse(disabledSchemes);
    }

    public HttpCallerInfo getHttpCallerInfo() {
        return this.hci;
    }

    private void parse(Set<String> disabledSchemes) {
        Iterator<String> iter = this.rsp.multiValueIterator(this.hdrname);
        while (iter.hasNext()) {
            HeaderParser hpn;
            String scheme;
            String raw = iter.next();
            HeaderParser hp = new HeaderParser(raw);
            Iterator<String> keys = hp.keys();
            int i = 0;
            int lastSchemeIndex = -1;
            while (keys.hasNext()) {
                keys.next();
                if (hp.findValue(i) == null) {
                    if (lastSchemeIndex != -1 && !disabledSchemes.contains(scheme = (hpn = hp.subsequence(lastSchemeIndex, i)).findKey(0))) {
                        this.schemes.put(scheme, new SchemeMapValue(hpn, raw));
                    }
                    lastSchemeIndex = i;
                }
                ++i;
            }
            if (i <= lastSchemeIndex || disabledSchemes.contains(scheme = (hpn = hp.subsequence(lastSchemeIndex, i)).findKey(0))) continue;
            this.schemes.put(scheme, new SchemeMapValue(hpn, raw));
        }
        SchemeMapValue v = null;
        if (authPref == null || (v = this.schemes.get(authPref)) == null) {
            SchemeMapValue tmp;
            if (v == null && !this.dontUseNegotiate && (tmp = this.schemes.get("negotiate")) != null) {
                if (this.hci == null || !NegotiateAuthentication.isSupported(new HttpCallerInfo(this.hci, "Negotiate"))) {
                    tmp = null;
                }
                v = tmp;
            }
            if (v == null && !this.dontUseNegotiate && (tmp = this.schemes.get("kerberos")) != null) {
                if (this.hci == null || !NegotiateAuthentication.isSupported(new HttpCallerInfo(this.hci, "Kerberos"))) {
                    tmp = null;
                }
                v = tmp;
            }
            if (v == null && (v = this.schemes.get("digest")) == null && (v = this.schemes.get("ntlm")) == null) {
                v = this.schemes.get("basic");
            }
        } else if (this.dontUseNegotiate && authPref.equals("negotiate")) {
            v = null;
        }
        if (v != null) {
            this.preferred = v.parser;
            this.preferred_r = v.raw;
        }
    }

    public HeaderParser headerParser() {
        return this.preferred;
    }

    public String scheme() {
        if (this.preferred != null) {
            return this.preferred.findKey(0);
        }
        return null;
    }

    public String raw() {
        return this.preferred_r;
    }

    public boolean isPresent() {
        return this.preferred != null;
    }

    static {
        authPref = AccessController.doPrivileged(new GetPropertyAction("http.auth.preference"));
        if (authPref != null && ((authPref = authPref.toLowerCase()).equals("spnego") || authPref.equals("kerberos"))) {
            authPref = "negotiate";
        }
    }

    static class SchemeMapValue {
        String raw;
        HeaderParser parser;

        SchemeMapValue(HeaderParser h, String r) {
            this.raw = r;
            this.parser = h;
        }
    }
}

